/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.kotlin.cli.common.messages;

import java.util.function.Predicate;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.kotlin.cli.common.messages.CompilerMessageLocation;
import org.jetbrains.kotlin.cli.common.messages.CompilerMessageSeverity;
import org.jetbrains.kotlin.cli.common.messages.MessageCollector;

public class FilteringMessageCollector
implements MessageCollector {
    private final MessageCollector messageCollector;
    private final Predicate<CompilerMessageSeverity> decline;

    public FilteringMessageCollector(@NotNull MessageCollector messageCollector2, @NotNull Predicate<CompilerMessageSeverity> decline) {
        this.messageCollector = messageCollector2;
        this.decline = decline;
    }

    @Override
    public void clear() {
        this.messageCollector.clear();
    }

    @Override
    public void report(@NotNull CompilerMessageSeverity severity, @NotNull String message, @Nullable CompilerMessageLocation location2) {
        if (!this.decline.test(severity)) {
            this.messageCollector.report(severity, message, location2);
        }
    }

    @Override
    public boolean hasErrors() {
        return this.messageCollector.hasErrors();
    }
}

