/*
 * Decompiled with CFR 0.152.
 */
package org.gradle.internal.component.external.model;

import com.google.common.base.Objects;
import com.google.common.base.Optional;
import com.google.common.collect.ImmutableList;
import java.util.List;
import javax.annotation.Nullable;
import org.gradle.api.artifacts.ModuleVersionIdentifier;
import org.gradle.api.artifacts.component.ComponentIdentifier;
import org.gradle.api.artifacts.component.ModuleComponentIdentifier;
import org.gradle.api.internal.attributes.AttributeContainerInternal;
import org.gradle.api.internal.attributes.AttributesSchemaInternal;
import org.gradle.api.internal.attributes.ImmutableAttributes;
import org.gradle.api.internal.attributes.ImmutableAttributesFactory;
import org.gradle.api.internal.project.ProjectInternal;
import org.gradle.internal.component.external.model.AbstractMutableModuleComponentResolveMetadata;
import org.gradle.internal.component.external.model.ComponentVariant;
import org.gradle.internal.component.external.model.DefaultModuleComponentArtifactMetadata;
import org.gradle.internal.component.external.model.ModuleComponentArtifactMetadata;
import org.gradle.internal.component.external.model.ModuleComponentResolveMetadata;
import org.gradle.internal.component.external.model.PreferJavaRuntimeVariant;
import org.gradle.internal.component.model.ConfigurationMetadata;
import org.gradle.internal.component.model.DefaultIvyArtifactName;
import org.gradle.internal.component.model.ModuleSource;
import org.gradle.internal.hash.HashValue;

abstract class AbstractModuleComponentResolveMetadata
implements ModuleComponentResolveMetadata {
    private static final PreferJavaRuntimeVariant SCHEMA_DEFAULT_JAVA_VARIANTS = PreferJavaRuntimeVariant.schema();
    private final ImmutableAttributesFactory attributesFactory;
    private final ModuleVersionIdentifier moduleVersionIdentifier;
    private final ModuleComponentIdentifier componentIdentifier;
    private final boolean changing;
    private final boolean missing;
    private final List<String> statusScheme;
    @Nullable
    private final ModuleSource moduleSource;
    private final ImmutableList<? extends ComponentVariant> variants;
    private final HashValue originalContentHash;
    private final ImmutableAttributes attributes;
    private final ImmutableList<? extends ComponentIdentifier> platformOwners;

    private static ImmutableAttributes extractAttributes(AbstractMutableModuleComponentResolveMetadata metadata) {
        return ((AttributeContainerInternal)metadata.getAttributes()).asImmutable();
    }

    public AbstractModuleComponentResolveMetadata(AbstractMutableModuleComponentResolveMetadata metadata) {
        this.componentIdentifier = metadata.getId();
        this.moduleVersionIdentifier = metadata.getModuleVersionId();
        this.changing = metadata.isChanging();
        this.missing = metadata.isMissing();
        this.statusScheme = metadata.getStatusScheme();
        this.moduleSource = metadata.getSource();
        this.attributesFactory = metadata.getAttributesFactory();
        this.originalContentHash = metadata.getContentHash();
        this.attributes = AbstractModuleComponentResolveMetadata.extractAttributes(metadata);
        this.variants = metadata.getVariants();
        this.platformOwners = metadata.getPlatformOwners() == null ? ImmutableList.of() : ImmutableList.copyOf(metadata.getPlatformOwners());
    }

    public AbstractModuleComponentResolveMetadata(AbstractModuleComponentResolveMetadata metadata, ImmutableList<? extends ComponentVariant> variants) {
        this.componentIdentifier = metadata.getId();
        this.moduleVersionIdentifier = metadata.getModuleVersionId();
        this.changing = metadata.isChanging();
        this.missing = metadata.isMissing();
        this.statusScheme = metadata.getStatusScheme();
        this.moduleSource = metadata.getSource();
        this.attributesFactory = metadata.getAttributesFactory();
        this.originalContentHash = metadata.getOriginalContentHash();
        this.attributes = metadata.getAttributes();
        this.variants = variants;
        this.platformOwners = metadata.getPlatformOwners();
    }

    public AbstractModuleComponentResolveMetadata(AbstractModuleComponentResolveMetadata metadata) {
        this.componentIdentifier = metadata.componentIdentifier;
        this.moduleVersionIdentifier = metadata.moduleVersionIdentifier;
        this.changing = metadata.changing;
        this.missing = metadata.missing;
        this.statusScheme = metadata.statusScheme;
        this.moduleSource = metadata.moduleSource;
        this.attributesFactory = metadata.attributesFactory;
        this.originalContentHash = metadata.originalContentHash;
        this.attributes = metadata.attributes;
        this.variants = metadata.variants;
        this.platformOwners = metadata.platformOwners;
    }

    public AbstractModuleComponentResolveMetadata(AbstractModuleComponentResolveMetadata metadata, ModuleSource source) {
        this.componentIdentifier = metadata.componentIdentifier;
        this.moduleVersionIdentifier = metadata.moduleVersionIdentifier;
        this.changing = metadata.changing;
        this.missing = metadata.missing;
        this.statusScheme = metadata.statusScheme;
        this.attributesFactory = metadata.attributesFactory;
        this.originalContentHash = metadata.originalContentHash;
        this.attributes = metadata.attributes;
        this.variants = metadata.variants;
        this.platformOwners = metadata.platformOwners;
        this.moduleSource = source;
    }

    @Override
    public ImmutableAttributesFactory getAttributesFactory() {
        return this.attributesFactory;
    }

    @Override
    public boolean isChanging() {
        return this.changing;
    }

    @Override
    public boolean isMissing() {
        return this.missing;
    }

    @Override
    public List<String> getStatusScheme() {
        return this.statusScheme;
    }

    @Override
    public ModuleComponentIdentifier getId() {
        return this.componentIdentifier;
    }

    @Override
    public ModuleVersionIdentifier getModuleVersionId() {
        return this.moduleVersionIdentifier;
    }

    @Override
    public ModuleSource getSource() {
        return this.moduleSource;
    }

    public String toString() {
        return this.componentIdentifier.getDisplayName();
    }

    @Override
    @Nullable
    public AttributesSchemaInternal getAttributesSchema() {
        return SCHEMA_DEFAULT_JAVA_VARIANTS;
    }

    public ImmutableAttributes getAttributes() {
        return this.attributes;
    }

    @Override
    public HashValue getOriginalContentHash() {
        return this.originalContentHash;
    }

    @Override
    public String getStatus() {
        return (String)this.attributes.getAttribute(ProjectInternal.STATUS_ATTRIBUTE);
    }

    @Override
    public ImmutableList<? extends ComponentVariant> getVariants() {
        return this.variants;
    }

    @Override
    public ModuleComponentArtifactMetadata artifact(String type, @Nullable String extension, @Nullable String classifier) {
        DefaultIvyArtifactName ivyArtifactName = new DefaultIvyArtifactName(this.getModuleVersionId().getName(), type, extension, classifier);
        return new DefaultModuleComponentArtifactMetadata(this.getId(), ivyArtifactName);
    }

    protected Optional<ImmutableList<? extends ConfigurationMetadata>> maybeDeriveVariants() {
        return Optional.absent();
    }

    @Override
    public ImmutableList<? extends ComponentIdentifier> getPlatformOwners() {
        return this.platformOwners;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        AbstractModuleComponentResolveMetadata that = (AbstractModuleComponentResolveMetadata)o;
        return this.changing == that.changing && this.missing == that.missing && Objects.equal((Object)this.moduleVersionIdentifier, (Object)that.moduleVersionIdentifier) && Objects.equal((Object)this.componentIdentifier, (Object)that.componentIdentifier) && Objects.equal(this.statusScheme, that.statusScheme) && Objects.equal((Object)this.moduleSource, (Object)that.moduleSource) && Objects.equal((Object)this.attributes, (Object)that.attributes) && Objects.equal(this.variants, that.variants) && Objects.equal((Object)this.originalContentHash, (Object)that.originalContentHash);
    }

    public int hashCode() {
        return Objects.hashCode((Object[])new Object[]{this.moduleVersionIdentifier, this.componentIdentifier, this.changing, this.missing, this.statusScheme, this.moduleSource, this.attributes, this.variants, this.originalContentHash});
    }
}

