/*
 * Decompiled with CFR 0.152.
 */
package org.gradle.api.internal.tasks.execution;

import com.google.common.collect.ImmutableSortedMap;
import java.io.File;
import org.gradle.api.execution.internal.TaskInputsListener;
import org.gradle.api.file.FileCollection;
import org.gradle.api.internal.TaskInternal;
import org.gradle.api.internal.file.FileCollectionInternal;
import org.gradle.api.internal.tasks.TaskExecuter;
import org.gradle.api.internal.tasks.TaskExecuterResult;
import org.gradle.api.internal.tasks.TaskExecutionContext;
import org.gradle.api.internal.tasks.TaskExecutionOutcome;
import org.gradle.api.internal.tasks.TaskStateInternal;
import org.gradle.api.internal.tasks.properties.TaskProperties;
import org.gradle.api.logging.Logger;
import org.gradle.api.logging.Logging;
import org.gradle.internal.Cast;
import org.gradle.internal.cleanup.BuildOutputCleanupRegistry;
import org.gradle.internal.execution.OutputChangeListener;
import org.gradle.internal.execution.history.AfterPreviousExecutionState;
import org.gradle.internal.execution.history.ExecutionHistoryStore;
import org.gradle.internal.fingerprint.FileCollectionFingerprint;
import org.gradle.util.GFileUtils;

public class SkipEmptySourceFilesTaskExecuter
implements TaskExecuter {
    private static final Logger LOGGER = Logging.getLogger(SkipEmptySourceFilesTaskExecuter.class);
    private final TaskInputsListener taskInputsListener;
    private final BuildOutputCleanupRegistry buildOutputCleanupRegistry;
    private final OutputChangeListener outputChangeListener;
    private final TaskExecuter executer;
    private final ExecutionHistoryStore executionHistoryStore;

    public SkipEmptySourceFilesTaskExecuter(TaskInputsListener taskInputsListener, ExecutionHistoryStore executionHistoryStore, BuildOutputCleanupRegistry buildOutputCleanupRegistry, OutputChangeListener outputChangeListener, TaskExecuter executer) {
        this.taskInputsListener = taskInputsListener;
        this.executionHistoryStore = executionHistoryStore;
        this.buildOutputCleanupRegistry = buildOutputCleanupRegistry;
        this.outputChangeListener = outputChangeListener;
        this.executer = executer;
    }

    @Override
    public TaskExecuterResult execute(TaskInternal task, TaskStateInternal state, TaskExecutionContext context) {
        TaskProperties properties = context.getTaskProperties();
        FileCollection sourceFiles = properties.getSourceFiles();
        if (properties.hasSourceFiles() && sourceFiles.isEmpty()) {
            ImmutableSortedMap outputFiles;
            AfterPreviousExecutionState previousExecution = context.getAfterPreviousExecution();
            ImmutableSortedMap immutableSortedMap = outputFiles = previousExecution == null ? ImmutableSortedMap.of() : previousExecution.getOutputFileProperties();
            if (outputFiles.isEmpty()) {
                state.setOutcome(TaskExecutionOutcome.NO_SOURCE);
                LOGGER.info("Skipping {} as it has no source files and no previous output files.", (Object)task);
            } else {
                boolean cleanupDirectories;
                boolean bl = cleanupDirectories = !context.getOverlappingOutputs().isPresent();
                if (!cleanupDirectories) {
                    LOGGER.info("No leftover directories for {} will be deleted since overlapping outputs were detected.", (Object)task);
                }
                this.outputChangeListener.beforeOutputChange();
                boolean deletedFiles = false;
                boolean debugEnabled = LOGGER.isDebugEnabled();
                for (FileCollectionFingerprint outputFingerprints : outputFiles.values()) {
                    for (String outputPath : outputFingerprints.getFingerprints().keySet()) {
                        File file = new File(outputPath);
                        if (!file.exists() || !this.buildOutputCleanupRegistry.isOutputOwnedByBuild(file) || !cleanupDirectories && file.isDirectory()) continue;
                        if (debugEnabled) {
                            LOGGER.debug("Deleting stale output file '{}'.", (Object)file.getAbsolutePath());
                        }
                        GFileUtils.forceDelete((File)file);
                        deletedFiles = true;
                    }
                }
                if (deletedFiles) {
                    LOGGER.info("Cleaned previous output of {} as it has no source files.", (Object)task);
                    state.setOutcome(TaskExecutionOutcome.EXECUTED);
                } else {
                    state.setOutcome(TaskExecutionOutcome.NO_SOURCE);
                }
            }
            this.taskInputsListener.onExecute(task, (FileCollectionInternal)Cast.cast(FileCollectionInternal.class, (Object)sourceFiles));
            this.executionHistoryStore.remove(task.getPath());
            return TaskExecuterResult.NO_REUSED_OUTPUT;
        }
        this.taskInputsListener.onExecute(task, (FileCollectionInternal)Cast.cast(FileCollectionInternal.class, (Object)properties.getInputFiles()));
        return this.executer.execute(task, state, context);
    }
}

