/*
 * Decompiled with CFR 0.152.
 */
package org.gradle.api.internal.tasks.properties;

import com.google.common.base.Function;
import com.google.common.collect.ImmutableList;
import com.google.common.collect.ImmutableMap;
import com.google.common.collect.ImmutableSet;
import com.google.common.collect.ImmutableSetMultimap;
import com.google.common.collect.Maps;
import com.google.common.collect.Multimap;
import groovy.lang.GroovyObject;
import java.lang.annotation.Annotation;
import java.util.Collection;
import java.util.Set;
import javax.annotation.Nullable;
import org.gradle.api.DefaultTask;
import org.gradle.api.Task;
import org.gradle.api.Transformer;
import org.gradle.api.internal.AbstractTask;
import org.gradle.api.internal.ConventionTask;
import org.gradle.api.internal.DynamicObjectAware;
import org.gradle.api.internal.GeneratedSubclasses;
import org.gradle.api.internal.HasConvention;
import org.gradle.api.internal.IConventionAware;
import org.gradle.api.internal.tasks.properties.TypeMetadata;
import org.gradle.api.internal.tasks.properties.TypeMetadataStore;
import org.gradle.api.internal.tasks.properties.annotations.AbstractOutputPropertyAnnotationHandler;
import org.gradle.api.internal.tasks.properties.annotations.OverridingPropertyAnnotationHandler;
import org.gradle.api.internal.tasks.properties.annotations.PropertyAnnotationHandler;
import org.gradle.api.internal.tasks.properties.annotations.TypeAnnotationHandler;
import org.gradle.api.plugins.ExtensionAware;
import org.gradle.api.tasks.Optional;
import org.gradle.api.tasks.PathSensitive;
import org.gradle.api.tasks.SkipWhenEmpty;
import org.gradle.cache.internal.CrossBuildInMemoryCache;
import org.gradle.cache.internal.CrossBuildInMemoryCacheFactory;
import org.gradle.internal.reflect.ParameterValidationContext;
import org.gradle.internal.reflect.PropertyExtractor;
import org.gradle.internal.reflect.PropertyMetadata;
import org.gradle.internal.reflect.ValidationProblem;
import org.gradle.internal.scripts.ScriptOrigin;

public class DefaultTypeMetadataStore
implements TypeMetadataStore {
    private static final ImmutableSet<Class<?>> IGNORED_SUPER_CLASSES = ImmutableSet.of(ConventionTask.class, DefaultTask.class, AbstractTask.class, Task.class, Object.class, GroovyObject.class, (Object[])new Class[]{IConventionAware.class, ExtensionAware.class, HasConvention.class, ScriptOrigin.class, DynamicObjectAware.class});
    private static final ImmutableSet<Class<?>> IGNORED_METHODS = ImmutableSet.of(Object.class, GroovyObject.class, ScriptOrigin.class);
    private final ImmutableMap<Class<? extends Annotation>, ? extends PropertyAnnotationHandler> annotationHandlers;
    private final Collection<? extends TypeAnnotationHandler> typeAnnotationHandlers;
    private final CrossBuildInMemoryCache<Class<?>, TypeMetadata> cache;
    private final PropertyExtractor propertyExtractor;
    private Transformer<TypeMetadata, Class<?>> typeMetadataFactory = new Transformer<TypeMetadata, Class<?>>(){

        public TypeMetadata transform(Class<?> type) {
            return DefaultTypeMetadataStore.this.createTypeMetadata(type);
        }
    };

    public DefaultTypeMetadataStore(Collection<? extends PropertyAnnotationHandler> annotationHandlers, Set<Class<? extends Annotation>> otherKnownAnnotations, Collection<? extends TypeAnnotationHandler> typeAnnotationHandlers, CrossBuildInMemoryCacheFactory cacheFactory) {
        this.annotationHandlers = Maps.uniqueIndex(annotationHandlers, (Function)new Function<PropertyAnnotationHandler, Class<? extends Annotation>>(){

            public Class<? extends Annotation> apply(PropertyAnnotationHandler handler) {
                return handler.getAnnotationType();
            }
        });
        this.typeAnnotationHandlers = typeAnnotationHandlers;
        Multimap<Class<? extends Annotation>, Class<? extends Annotation>> annotationOverrides = DefaultTypeMetadataStore.collectAnnotationOverrides(annotationHandlers);
        Set<Class<? extends Annotation>> relevantAnnotationTypes = DefaultTypeMetadataStore.collectRelevantAnnotationTypes(Maps.uniqueIndex(annotationHandlers, (Function)new Function<PropertyAnnotationHandler, Class<? extends Annotation>>(){

            public Class<? extends Annotation> apply(PropertyAnnotationHandler handler) {
                return handler.getAnnotationType();
            }
        }).keySet());
        String displayName = this.calculateDisplayName(annotationHandlers);
        this.propertyExtractor = new PropertyExtractor(displayName, (Set)this.annotationHandlers.keySet(), relevantAnnotationTypes, annotationOverrides, otherKnownAnnotations, IGNORED_SUPER_CLASSES, IGNORED_METHODS);
        this.cache = cacheFactory.newClassCache();
    }

    private String calculateDisplayName(Iterable<? extends PropertyAnnotationHandler> annotationHandlers) {
        for (PropertyAnnotationHandler propertyAnnotationHandler : annotationHandlers) {
            if (!(propertyAnnotationHandler instanceof AbstractOutputPropertyAnnotationHandler)) continue;
            return "an input or output annotation";
        }
        return "an input annotation";
    }

    private static Multimap<Class<? extends Annotation>, Class<? extends Annotation>> collectAnnotationOverrides(Iterable<? extends PropertyAnnotationHandler> allAnnotationHandlers) {
        ImmutableSetMultimap.Builder builder = ImmutableSetMultimap.builder();
        for (PropertyAnnotationHandler propertyAnnotationHandler : allAnnotationHandlers) {
            if (!(propertyAnnotationHandler instanceof OverridingPropertyAnnotationHandler)) continue;
            for (Class overriddenAnnotationType : ((OverridingPropertyAnnotationHandler)propertyAnnotationHandler).getOverriddenAnnotationTypes()) {
                builder.put((Object)overriddenAnnotationType, propertyAnnotationHandler.getAnnotationType());
            }
        }
        return builder.build();
    }

    private static Set<Class<? extends Annotation>> collectRelevantAnnotationTypes(Set<Class<? extends Annotation>> propertyTypeAnnotations) {
        return ImmutableSet.builder().addAll(propertyTypeAnnotations).add(Optional.class).add(SkipWhenEmpty.class).add(PathSensitive.class).build();
    }

    @Override
    public <T> TypeMetadata getTypeMetadata(Class<T> type) {
        return (TypeMetadata)this.cache.get(type, this.typeMetadataFactory);
    }

    private <T> TypeMetadata createTypeMetadata(Class<T> type) {
        Class publicType = GeneratedSubclasses.unpack(type);
        RecordingValidationContext validationContext = new RecordingValidationContext();
        for (TypeAnnotationHandler typeAnnotationHandler : this.typeAnnotationHandlers) {
            if (!publicType.isAnnotationPresent(typeAnnotationHandler.getAnnotationType())) continue;
            typeAnnotationHandler.validateTypeMetadata(publicType, validationContext);
        }
        ImmutableSet properties = this.propertyExtractor.extractPropertyMetadata(publicType, (ParameterValidationContext)validationContext);
        ImmutableSet.Builder builder = ImmutableSet.builderWithExpectedSize((int)properties.size());
        for (PropertyMetadata property : properties) {
            PropertyAnnotationHandler annotationHandler = (PropertyAnnotationHandler)this.annotationHandlers.get((Object)property.getPropertyType());
            annotationHandler.validatePropertyMetadata(property, validationContext);
            if (!annotationHandler.isPropertyRelevant()) continue;
            builder.add((Object)property);
        }
        return new DefaultTypeMetadata((ImmutableSet<PropertyMetadata>)builder.build(), validationContext.getProblems(), this.annotationHandlers);
    }

    private static class DefaultTypeMetadata
    implements TypeMetadata {
        private final ImmutableSet<PropertyMetadata> propertiesMetadata;
        private final ImmutableList<ValidationProblem> validationProblems;
        private final ImmutableMap<Class<? extends Annotation>, ? extends PropertyAnnotationHandler> annotationHandlers;

        DefaultTypeMetadata(ImmutableSet<PropertyMetadata> propertiesMetadata, ImmutableList<ValidationProblem> validationProblems, ImmutableMap<Class<? extends Annotation>, ? extends PropertyAnnotationHandler> annotationHandlers) {
            this.propertiesMetadata = propertiesMetadata;
            this.validationProblems = validationProblems;
            this.annotationHandlers = annotationHandlers;
        }

        @Override
        public void collectValidationFailures(@Nullable String ownerPropertyPath, ParameterValidationContext validationContext) {
            for (ValidationProblem problem : this.validationProblems) {
                problem.collect(ownerPropertyPath, validationContext);
            }
        }

        @Override
        public Set<PropertyMetadata> getPropertiesMetadata() {
            return this.propertiesMetadata;
        }

        @Override
        public boolean hasAnnotatedProperties() {
            return !this.propertiesMetadata.isEmpty();
        }

        @Override
        public PropertyAnnotationHandler getAnnotationHandlerFor(PropertyMetadata propertyMetadata) {
            return (PropertyAnnotationHandler)this.annotationHandlers.get((Object)propertyMetadata.getPropertyType());
        }
    }

    private static class RecordingValidationContext
    implements ParameterValidationContext {
        private ImmutableList.Builder<ValidationProblem> builder = ImmutableList.builder();

        private RecordingValidationContext() {
        }

        ImmutableList<ValidationProblem> getProblems() {
            return this.builder.build();
        }

        public void visitError(@Nullable String ownerPath, final String propertyName, final String message) {
            this.builder.add((Object)new ValidationProblem(){

                public void collect(@Nullable String ownerPropertyPath, ParameterValidationContext validationContext) {
                    validationContext.visitError(ownerPropertyPath, propertyName, message);
                }
            });
        }

        public void visitError(final String message) {
            this.builder.add((Object)new ValidationProblem(){

                public void collect(@Nullable String ownerPropertyPath, ParameterValidationContext validationContext) {
                    validationContext.visitError(message);
                }
            });
        }

        public void visitErrorStrict(final String message) {
            this.builder.add((Object)new ValidationProblem(){

                public void collect(@Nullable String ownerPropertyPath, ParameterValidationContext validationContext) {
                    validationContext.visitErrorStrict(message);
                }
            });
        }
    }
}

