/*
 * Decompiled with CFR 0.152.
 */
package org.gradle.buildinit.plugins.internal;

import org.gradle.api.internal.DocumentationRegistry;
import org.gradle.api.internal.file.FileResolver;
import org.gradle.buildinit.plugins.internal.BuildScriptBuilder;
import org.gradle.buildinit.plugins.internal.BuildScriptBuilderFactory;
import org.gradle.buildinit.plugins.internal.InitSettings;
import org.gradle.buildinit.plugins.internal.JavaProjectInitDescriptor;
import org.gradle.buildinit.plugins.internal.TemplateLibraryVersionProvider;
import org.gradle.buildinit.plugins.internal.TemplateOperation;
import org.gradle.buildinit.plugins.internal.TemplateOperationFactory;

public class JavaApplicationProjectInitDescriptor
extends JavaProjectInitDescriptor {
    public JavaApplicationProjectInitDescriptor(BuildScriptBuilderFactory scriptBuilderFactory, TemplateOperationFactory templateOperationFactory, FileResolver fileResolver, TemplateLibraryVersionProvider libraryVersionProvider, DocumentationRegistry documentationRegistry) {
        super(scriptBuilderFactory, templateOperationFactory, fileResolver, libraryVersionProvider, documentationRegistry);
    }

    @Override
    public String getId() {
        return "java-application";
    }

    @Override
    protected void configureBuildScript(InitSettings settings, BuildScriptBuilder buildScriptBuilder) {
        super.configureBuildScript(settings, buildScriptBuilder);
        buildScriptBuilder.plugin("Apply the application plugin to add support for building an application", "application").conventionPropertyAssignment("Define the main class for the application", "application", "mainClassName", this.withPackage(settings, "App"));
    }

    @Override
    protected TemplateOperation sourceTemplateOperation(InitSettings settings) {
        return this.fromClazzTemplate("javaapp/App.java.template", settings, "main");
    }

    @Override
    protected TemplateOperation testTemplateOperation(InitSettings settings) {
        switch (settings.getTestFramework()) {
            case SPOCK: {
                return this.fromClazzTemplate("groovyapp/AppTest.groovy.template", settings, "test", "groovy");
            }
            case TESTNG: {
                return this.fromClazzTemplate("javaapp/testng/AppTest.java.template", settings, "test", "java");
            }
            case JUNIT: {
                return this.fromClazzTemplate("javaapp/AppTest.java.template", settings, "test");
            }
        }
        throw new IllegalArgumentException();
    }
}

