/*
 * Decompiled with CFR 0.152.
 */
package org.gradle.api.internal.java;

import com.google.common.collect.ImmutableSet;
import java.util.Collections;
import java.util.Set;
import javax.inject.Inject;
import org.gradle.api.artifacts.ConfigurationContainer;
import org.gradle.api.artifacts.PublishArtifact;
import org.gradle.api.attributes.AttributeContainer;
import org.gradle.api.internal.artifacts.dsl.dependencies.PlatformSupport;
import org.gradle.api.internal.attributes.AttributeContainerInternal;
import org.gradle.api.internal.attributes.ImmutableAttributesFactory;
import org.gradle.api.internal.component.SoftwareComponentInternal;
import org.gradle.api.internal.component.UsageContext;
import org.gradle.api.internal.java.usagecontext.ConfigurationUsageContext;
import org.gradle.api.model.ObjectFactory;

public class JavaPlatform
implements SoftwareComponentInternal {
    private final ObjectFactory objectFactory;
    private final ImmutableAttributesFactory attributesFactory;
    private final ConfigurationContainer configurations;
    private final UsageContext api;
    private final UsageContext runtime;

    @Inject
    public JavaPlatform(ObjectFactory objectFactory, ImmutableAttributesFactory attributesFactory, ConfigurationContainer configurations) {
        this.objectFactory = objectFactory;
        this.attributesFactory = attributesFactory;
        this.configurations = configurations;
        this.api = this.createApiUsageContext();
        this.runtime = this.createRuntimeUsageContext();
    }

    public Set<? extends UsageContext> getUsages() {
        return ImmutableSet.of((Object)this.api, (Object)this.runtime);
    }

    public String getName() {
        return "javaPlatform";
    }

    private UsageContext createRuntimeUsageContext() {
        return new JavaPlatformUsageContext("java-runtime", "runtime", "runtimeElements", this.configurations, this.objectFactory, this.attributesFactory);
    }

    private UsageContext createApiUsageContext() {
        return new JavaPlatformUsageContext("java-api", "api", "apiElements", this.configurations, this.objectFactory, this.attributesFactory);
    }

    private static final class JavaPlatformUsageContext
    extends ConfigurationUsageContext {
        private final AttributeContainer attributes;

        private JavaPlatformUsageContext(String usageName, String name, String configurationName, ConfigurationContainer configurations, ObjectFactory objectFactory, ImmutableAttributesFactory attributesFactory) {
            super(usageName, name, configurationName, Collections.<PublishArtifact>emptySet(), configurations, objectFactory, attributesFactory);
            AttributeContainerInternal attributes = (AttributeContainerInternal)super.getAttributes();
            this.attributes = attributesFactory.concat(attributes.asImmutable(), PlatformSupport.COMPONENT_CATEGORY, (Object)"platform");
        }

        @Override
        public AttributeContainer getAttributes() {
            return this.attributes;
        }
    }
}

