/*
 * Decompiled with CFR 0.152.
 */
package org.gradle.api.internal.artifacts.ivyservice.projectmodule;

import java.util.ArrayList;
import java.util.HashSet;
import java.util.Iterator;
import java.util.LinkedHashSet;
import org.gradle.api.artifacts.ModuleVersionIdentifier;
import org.gradle.api.artifacts.ProjectDependency;
import org.gradle.api.component.ComponentWithVariants;
import org.gradle.api.internal.artifacts.DefaultModuleVersionIdentifier;
import org.gradle.api.internal.artifacts.ivyservice.projectmodule.ProjectComponentPublication;
import org.gradle.api.internal.artifacts.ivyservice.projectmodule.ProjectDependencyPublicationResolver;
import org.gradle.api.internal.artifacts.ivyservice.projectmodule.ProjectPublicationRegistry;
import org.gradle.api.internal.project.ProjectInternal;
import org.gradle.execution.ProjectConfigurer;
import org.gradle.internal.text.TreeFormatter;

public class DefaultProjectDependencyPublicationResolver
implements ProjectDependencyPublicationResolver {
    private final ProjectPublicationRegistry publicationRegistry;
    private final ProjectConfigurer projectConfigurer;

    public DefaultProjectDependencyPublicationResolver(ProjectPublicationRegistry publicationRegistry, ProjectConfigurer projectConfigurer) {
        this.publicationRegistry = publicationRegistry;
        this.projectConfigurer = projectConfigurer;
    }

    @Override
    public <T> T resolve(Class<T> coordsType, ProjectDependency dependency) {
        ProjectInternal dependencyProject = (ProjectInternal)dependency.getDependencyProject();
        this.projectConfigurer.configureFully(dependencyProject);
        ArrayList<ProjectComponentPublication> publications = new ArrayList<ProjectComponentPublication>();
        for (ProjectComponentPublication projectComponentPublication : this.publicationRegistry.getPublications(ProjectComponentPublication.class, dependencyProject.getIdentityPath())) {
            if (projectComponentPublication.isLegacy() || projectComponentPublication.getCoordinates(coordsType) == null) continue;
            publications.add(projectComponentPublication);
        }
        if (publications.isEmpty()) {
            if (coordsType.isAssignableFrom(ModuleVersionIdentifier.class)) {
                return coordsType.cast(DefaultModuleVersionIdentifier.newId(dependency.getGroup(), dependencyProject.getName(), dependency.getVersion()));
            }
            throw new UnsupportedOperationException(String.format("Could not find any publications of type %s in %s.", coordsType.getSimpleName(), dependencyProject.getDisplayName()));
        }
        HashSet ignored = new HashSet();
        for (ProjectComponentPublication projectComponentPublication : publications) {
            if (projectComponentPublication.getComponent() == null || !(projectComponentPublication.getComponent() instanceof ComponentWithVariants)) continue;
            ComponentWithVariants parent = (ComponentWithVariants)projectComponentPublication.getComponent();
            ignored.addAll(parent.getVariants());
        }
        LinkedHashSet<ProjectComponentPublication> linkedHashSet = new LinkedHashSet<ProjectComponentPublication>();
        LinkedHashSet<ProjectComponentPublication> linkedHashSet2 = new LinkedHashSet<ProjectComponentPublication>();
        for (ProjectComponentPublication projectComponentPublication : publications) {
            if (projectComponentPublication.isAlias() || projectComponentPublication.getComponent() != null && ignored.contains(projectComponentPublication.getComponent())) continue;
            linkedHashSet.add(projectComponentPublication);
            if (projectComponentPublication.getComponent() == null) continue;
            linkedHashSet2.add(projectComponentPublication);
        }
        if (linkedHashSet2.size() == 1) {
            return ((ProjectComponentPublication)linkedHashSet2.iterator().next()).getCoordinates(coordsType);
        }
        Iterator iterator = linkedHashSet.iterator();
        T t = ((ProjectComponentPublication)iterator.next()).getCoordinates(coordsType);
        while (iterator.hasNext()) {
            T alternative = ((ProjectComponentPublication)iterator.next()).getCoordinates(coordsType);
            if (t.equals(alternative)) continue;
            TreeFormatter formatter = new TreeFormatter();
            formatter.node("Publishing is not able to resolve a dependency on a project with multiple publications that have different coordinates.");
            formatter.node("Found the following publications in " + dependencyProject.getDisplayName());
            formatter.startChildren();
            for (ProjectComponentPublication publication : linkedHashSet) {
                formatter.node(publication.getDisplayName().getCapitalizedDisplayName() + " with coordinates " + publication.getCoordinates(coordsType));
            }
            formatter.endChildren();
            throw new UnsupportedOperationException(formatter.toString());
        }
        return t;
    }
}

