/*
 * Decompiled with CFR 0.152.
 */
package org.gradle.language.swift.plugins;

import java.util.concurrent.Callable;
import javax.inject.Inject;
import org.gradle.api.Action;
import org.gradle.api.Incubating;
import org.gradle.api.Plugin;
import org.gradle.api.Project;
import org.gradle.api.Transformer;
import org.gradle.api.attributes.AttributeCompatibilityRule;
import org.gradle.api.attributes.CompatibilityCheckDetails;
import org.gradle.api.attributes.Usage;
import org.gradle.api.file.Directory;
import org.gradle.api.file.DirectoryProperty;
import org.gradle.api.file.RegularFile;
import org.gradle.api.internal.artifacts.ivyservice.projectmodule.ProjectPublication;
import org.gradle.api.internal.artifacts.ivyservice.projectmodule.ProjectPublicationRegistry;
import org.gradle.api.internal.project.ProjectInternal;
import org.gradle.api.internal.tasks.TaskContainerInternal;
import org.gradle.api.provider.Provider;
import org.gradle.api.provider.ProviderFactory;
import org.gradle.api.tasks.TaskProvider;
import org.gradle.language.internal.DefaultBinaryCollection;
import org.gradle.language.nativeplatform.internal.Names;
import org.gradle.language.plugins.NativeBasePlugin;
import org.gradle.language.swift.ProductionSwiftComponent;
import org.gradle.language.swift.SwiftSharedLibrary;
import org.gradle.language.swift.SwiftStaticLibrary;
import org.gradle.language.swift.SwiftVersion;
import org.gradle.language.swift.internal.DefaultSwiftBinary;
import org.gradle.language.swift.internal.DefaultSwiftComponent;
import org.gradle.language.swift.tasks.SwiftCompile;
import org.gradle.nativeplatform.toolchain.internal.ToolType;
import org.gradle.nativeplatform.toolchain.internal.xcode.MacOSSdkPathLocator;
import org.gradle.nativeplatform.toolchain.plugins.SwiftCompilerPlugin;
import org.gradle.swiftpm.internal.NativeProjectPublication;
import org.gradle.swiftpm.internal.SwiftPmTarget;
import org.gradle.util.VersionNumber;

@Incubating
public class SwiftBasePlugin
implements Plugin<ProjectInternal> {
    private final ProjectPublicationRegistry publicationRegistry;
    private final MacOSSdkPathLocator locator;

    @Inject
    public SwiftBasePlugin(ProjectPublicationRegistry publicationRegistry, MacOSSdkPathLocator locator) {
        this.publicationRegistry = publicationRegistry;
        this.locator = locator;
    }

    public void apply(final ProjectInternal project) {
        project.getPluginManager().apply(NativeBasePlugin.class);
        project.getPluginManager().apply(SwiftCompilerPlugin.class);
        final TaskContainerInternal tasks = project.getTasks();
        final DirectoryProperty buildDirectory = project.getLayout().getBuildDirectory();
        final ProviderFactory providers = project.getProviders();
        project.getDependencies().getAttributesSchema().attribute(Usage.USAGE_ATTRIBUTE).getCompatibilityRules().add(SwiftCppUsageCompatibilityRule.class);
        project.getComponents().withType(DefaultSwiftBinary.class, (Action)new Action<DefaultSwiftBinary>(){

            public void execute(final DefaultSwiftBinary binary) {
                final Names names = binary.getNames();
                TaskProvider compile = tasks.register(names.getCompileTaskName("swift"), SwiftCompile.class, (Action)new Action<SwiftCompile>(){

                    public void execute(SwiftCompile compile) {
                        compile.getModules().from(new Object[]{binary.getCompileModules()});
                        compile.getSource().from(new Object[]{binary.getSwiftSource()});
                        compile.getDebuggable().set((Object)binary.isDebuggable());
                        compile.getOptimized().set((Object)binary.isOptimized());
                        if (binary.isTestable()) {
                            compile.getCompilerArgs().add((Object)"-enable-testing");
                        }
                        if (binary.getTargetPlatform().getOperatingSystemFamily().isMacOs()) {
                            compile.getCompilerArgs().add((Object)"-sdk");
                            compile.getCompilerArgs().add((Object)SwiftBasePlugin.this.locator.find().getAbsolutePath());
                        }
                        compile.getModuleName().set(binary.getModule());
                        compile.getObjectFileDir().set(buildDirectory.dir("obj/" + names.getDirName()));
                        compile.getModuleFile().set(buildDirectory.file(providers.provider((Callable)new Callable<String>(){

                            @Override
                            public String call() {
                                return "modules/" + names.getDirName() + (String)binary.getModule().get() + ".swiftmodule";
                            }
                        })));
                        compile.getSourceCompatibility().set(binary.getSourceCompatibility());
                        compile.getTargetPlatform().set((Object)binary.getTargetPlatform());
                        compile.getToolChain().set((Object)binary.getToolChain());
                        if (binary instanceof SwiftSharedLibrary || binary instanceof SwiftStaticLibrary) {
                            compile.getCompilerArgs().add((Object)"-parse-as-library");
                        }
                    }
                });
                binary.getModuleFile().set(compile.flatMap((Transformer)new Transformer<Provider<? extends RegularFile>, SwiftCompile>(){

                    public Provider<? extends RegularFile> transform(SwiftCompile swiftCompile) {
                        return swiftCompile.getModuleFile();
                    }
                }));
                binary.getCompileTask().set((Provider)compile);
                binary.getObjectsDir().set(compile.flatMap((Transformer)new Transformer<Provider<? extends Directory>, SwiftCompile>(){

                    public Provider<? extends Directory> transform(SwiftCompile swiftCompile) {
                        return swiftCompile.getObjectFileDir();
                    }
                }));
            }
        });
        project.getComponents().withType(DefaultSwiftComponent.class, (Action)new Action<DefaultSwiftComponent>(){

            public void execute(final DefaultSwiftComponent component) {
                ((DefaultBinaryCollection)component.getBinaries()).whenElementKnown(DefaultSwiftBinary.class, new Action<DefaultSwiftBinary>(){

                    public void execute(final DefaultSwiftBinary binary) {
                        Provider swiftLanguageVersionProvider = project.provider((Callable)new Callable<SwiftVersion>(){

                            @Override
                            public SwiftVersion call() throws Exception {
                                component.getSourceCompatibility().finalizeValue();
                                SwiftVersion swiftSourceCompatibility = (SwiftVersion)component.getSourceCompatibility().getOrNull();
                                if (swiftSourceCompatibility == null) {
                                    return SwiftBasePlugin.toSwiftVersion(binary.getPlatformToolProvider().getCompilerMetadata(ToolType.SWIFT_COMPILER).getVersion());
                                }
                                return swiftSourceCompatibility;
                            }
                        });
                        binary.getSourceCompatibility().set(swiftLanguageVersionProvider);
                    }
                });
            }
        });
        project.getComponents().withType(ProductionSwiftComponent.class, (Action)new Action<ProductionSwiftComponent>(){

            public void execute(final ProductionSwiftComponent component) {
                project.afterEvaluate((Action)new Action<Project>(){

                    public void execute(Project project) {
                        DefaultSwiftComponent componentInternal = (DefaultSwiftComponent)((Object)component);
                        ProjectInternal projectInternal = (ProjectInternal)project;
                        SwiftBasePlugin.this.publicationRegistry.registerPublication(projectInternal, (ProjectPublication)new NativeProjectPublication(componentInternal.getDisplayName(), new SwiftPmTarget((String)component.getModule().get())));
                    }
                });
            }
        });
    }

    static SwiftVersion toSwiftVersion(VersionNumber swiftCompilerVersion) {
        if (swiftCompilerVersion.getMajor() == 3) {
            return SwiftVersion.SWIFT3;
        }
        if (swiftCompilerVersion.getMajor() == 4) {
            return SwiftVersion.SWIFT4;
        }
        throw new IllegalArgumentException(String.format("Swift language version is unknown for the specified Swift compiler version (%s)", swiftCompilerVersion.toString()));
    }

    static class SwiftCppUsageCompatibilityRule
    implements AttributeCompatibilityRule<Usage> {
        SwiftCppUsageCompatibilityRule() {
        }

        public void execute(CompatibilityCheckDetails<Usage> details) {
            if ("swift-api".equals(((Usage)details.getConsumerValue()).getName()) && "cplusplus-api".equals(((Usage)details.getProducerValue()).getName())) {
                details.compatible();
            }
        }
    }
}

