/*
 * Decompiled with CFR 0.152.
 */
package org.gradle.api.internal.project;

import com.google.common.collect.Lists;
import com.google.common.collect.Sets;
import groovy.lang.GroovyObject;
import groovy.lang.MissingPropertyException;
import groovy.util.ObservableMap;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.io.File;
import java.util.Enumeration;
import java.util.HashSet;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.apache.tools.ant.ProjectHelper;
import org.apache.tools.ant.PropertyHelper;
import org.apache.tools.ant.Target;
import org.gradle.api.Action;
import org.gradle.api.AntBuilder;
import org.gradle.api.GradleException;
import org.gradle.api.Project;
import org.gradle.api.Task;
import org.gradle.api.Transformer;
import org.gradle.api.UnknownTaskException;
import org.gradle.api.internal.project.ant.AntLoggingAdapter;
import org.gradle.api.internal.project.ant.BasicAntBuilder;
import org.gradle.api.tasks.TaskContainer;
import org.gradle.api.tasks.TaskDependency;
import org.gradle.api.tasks.ant.AntTarget;
import org.gradle.internal.Transformers;

public class DefaultAntBuilder
extends BasicAntBuilder
implements GroovyObject {
    private final Project gradleProject;
    private final AntLoggingAdapter loggingAdapter;

    public DefaultAntBuilder(Project gradleProject, AntLoggingAdapter loggingAdapter) {
        this.gradleProject = gradleProject;
        this.loggingAdapter = loggingAdapter;
    }

    public void propertyMissing(String property, Object newValue) {
        this.doSetProperty(property, newValue);
    }

    private void doSetProperty(String property, Object newValue) {
        PropertyHelper.getPropertyHelper((org.apache.tools.ant.Project)this.getProject()).setUserProperty(null, property, newValue);
    }

    public Object propertyMissing(String name) {
        if (this.getProject().getProperties().containsKey(name)) {
            return this.getProject().getProperties().get(name);
        }
        throw new MissingPropertyException(name, this.getClass());
    }

    @Override
    public Map<String, Object> getProperties() {
        ObservableMap map = new ObservableMap((Map)this.getProject().getProperties());
        map.addPropertyChangeListener(new PropertyChangeListener(){

            @Override
            public void propertyChange(PropertyChangeEvent event) {
                DefaultAntBuilder.this.doSetProperty(event.getPropertyName(), event.getNewValue());
            }
        });
        ObservableMap castMap = map;
        return castMap;
    }

    @Override
    public Map<String, Object> getReferences() {
        ObservableMap map = new ObservableMap((Map)this.getProject().getReferences());
        map.addPropertyChangeListener(new PropertyChangeListener(){

            @Override
            public void propertyChange(PropertyChangeEvent event) {
                DefaultAntBuilder.this.getProject().addReference(event.getPropertyName(), event.getNewValue());
            }
        });
        ObservableMap castMap = map;
        return castMap;
    }

    @Override
    public void importBuild(Object antBuildFile) {
        this.importBuild(antBuildFile, (Transformer<? extends String, ? super String>)Transformers.noOpTransformer());
    }

    @Override
    public void importBuild(Object antBuildFile, Transformer<? extends String, ? super String> taskNamer) {
        File file = this.gradleProject.file(antBuildFile);
        File baseDir = file.getParentFile();
        HashSet existingAntTargets = new HashSet(this.getAntProject().getTargets().keySet());
        File oldBaseDir = this.getAntProject().getBaseDir();
        this.getAntProject().setBaseDir(baseDir);
        try {
            this.getAntProject().setUserProperty("ant.file", file.getAbsolutePath());
            ProjectHelper.configureProject((org.apache.tools.ant.Project)this.getAntProject(), (File)file);
        }
        catch (Exception e) {
            throw new GradleException("Could not import Ant build file '" + String.valueOf(file) + "'.", (Throwable)e);
        }
        finally {
            this.getAntProject().setBaseDir(oldBaseDir);
        }
        this.getAntProject().getTargets().remove("");
        HashSet newAntTargets = new HashSet(this.getAntProject().getTargets().keySet());
        newAntTargets.removeAll(existingAntTargets);
        for (String name : newAntTargets) {
            Target target = (Target)this.getAntProject().getTargets().get(name);
            String taskName = (String)taskNamer.transform((Object)target.getName());
            AntTarget task = (AntTarget)this.gradleProject.getTasks().create(taskName, AntTarget.class);
            DefaultAntBuilder.configureTask(target, task, baseDir, taskNamer);
        }
    }

    private static void configureTask(Target target, AntTarget task, File baseDir, Transformer<? extends String, ? super String> taskNamer) {
        task.setTarget(target);
        task.setBaseDir(baseDir);
        List<String> taskDependencyNames = DefaultAntBuilder.getTaskDependencyNames(target, taskNamer);
        task.dependsOn(new AntTargetsTaskDependency(taskDependencyNames));
        DefaultAntBuilder.addDependencyOrdering(taskDependencyNames, task.getProject().getTasks());
    }

    private static List<String> getTaskDependencyNames(Target target, Transformer<? extends String, ? super String> taskNamer) {
        Enumeration dependencies = target.getDependencies();
        LinkedList taskDependencyNames = Lists.newLinkedList();
        while (dependencies.hasMoreElements()) {
            String targetName = (String)dependencies.nextElement();
            String taskName = (String)taskNamer.transform((Object)targetName);
            taskDependencyNames.add(taskName);
        }
        return taskDependencyNames;
    }

    private static void addDependencyOrdering(List<String> dependencies, TaskContainer tasks) {
        String previous = null;
        for (final String dependency : dependencies) {
            if (previous != null) {
                final String finalPrevious = previous;
                tasks.all((Action)new Action<Task>(){

                    public void execute(Task task) {
                        if (task.getName().equals(dependency)) {
                            task.shouldRunAfter(new Object[]{finalPrevious});
                        }
                    }
                });
            }
            previous = dependency;
        }
    }

    @Override
    public void setLifecycleLogLevel(AntBuilder.AntMessagePriority logLevel) {
        this.loggingAdapter.setLifecycleLogLevel(logLevel);
    }

    @Override
    public AntBuilder.AntMessagePriority getLifecycleLogLevel() {
        return this.loggingAdapter.getLifecycleLogLevel();
    }

    private static class AntTargetsTaskDependency
    implements TaskDependency {
        private final List<String> taskDependencyNames;

        public AntTargetsTaskDependency(List<String> taskDependencyNames) {
            this.taskDependencyNames = taskDependencyNames;
        }

        public Set<? extends Task> getDependencies(Task task) {
            HashSet tasks = Sets.newHashSetWithExpectedSize((int)this.taskDependencyNames.size());
            for (String dependedOnTaskName : this.taskDependencyNames) {
                Task dependency = (Task)task.getProject().getTasks().findByName(dependedOnTaskName);
                if (dependency == null) {
                    throw new UnknownTaskException(String.format("Imported Ant target '%s' depends on target or task '%s' which does not exist", task.getName(), dependedOnTaskName));
                }
                tasks.add(dependency);
            }
            return tasks;
        }
    }
}

