/*
 * Decompiled with CFR 0.152.
 */
package org.gradle.internal.execution.impl.steps;

import com.google.common.collect.ImmutableSortedMap;
import java.util.Optional;
import javax.annotation.Nullable;
import org.gradle.caching.BuildCacheKey;
import org.gradle.caching.internal.CacheableEntity;
import org.gradle.caching.internal.command.BuildCacheCommandFactory;
import org.gradle.caching.internal.command.BuildCacheLoadListener;
import org.gradle.caching.internal.controller.BuildCacheController;
import org.gradle.caching.internal.origin.OriginMetadata;
import org.gradle.caching.internal.packaging.UnrecoverableUnpackingException;
import org.gradle.internal.execution.ExecutionOutcome;
import org.gradle.internal.execution.OutputChangeListener;
import org.gradle.internal.execution.UnitOfWork;
import org.gradle.internal.execution.impl.steps.CachingContext;
import org.gradle.internal.execution.impl.steps.CurrentSnapshotResult;
import org.gradle.internal.execution.impl.steps.Step;
import org.gradle.internal.fingerprint.CurrentFileCollectionFingerprint;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class CacheStep<C extends CachingContext>
implements Step<C, CurrentSnapshotResult> {
    private static final Logger LOGGER = LoggerFactory.getLogger(CacheStep.class);
    private final BuildCacheController buildCache;
    private final OutputChangeListener outputChangeListener;
    private final BuildCacheCommandFactory commandFactory;
    private final Step<? super C, ? extends CurrentSnapshotResult> delegate;

    public CacheStep(BuildCacheController buildCache, OutputChangeListener outputChangeListener, BuildCacheCommandFactory commandFactory, Step<? super C, ? extends CurrentSnapshotResult> delegate) {
        this.buildCache = buildCache;
        this.outputChangeListener = outputChangeListener;
        this.commandFactory = commandFactory;
        this.delegate = delegate;
    }

    @Override
    public CurrentSnapshotResult execute(C context) {
        return context.getCacheHandler().load(cacheKey -> this.load(context.getWork(), (BuildCacheKey)cacheKey)).map(loadResult -> new CurrentSnapshotResult((BuildCacheCommandFactory.LoadMetadata)loadResult){
            final /* synthetic */ BuildCacheCommandFactory.LoadMetadata val$loadResult;
            {
                this.val$loadResult = loadMetadata;
            }

            @Override
            public ExecutionOutcome getOutcome() {
                return ExecutionOutcome.FROM_CACHE;
            }

            @Override
            public OriginMetadata getOriginMetadata() {
                return this.val$loadResult.getOriginMetadata();
            }

            @Override
            public ImmutableSortedMap<String, CurrentFileCollectionFingerprint> getFinalOutputs() {
                return this.val$loadResult.getResultingSnapshots();
            }

            @Override
            @Nullable
            public Throwable getFailure() {
                return null;
            }
        }).orElseGet(() -> {
            CurrentSnapshotResult executionResult = this.executeWithoutCache(context);
            if (executionResult.getFailure() == null) {
                context.getCacheHandler().store(cacheKey -> this.store(context.getWork(), (BuildCacheKey)cacheKey, executionResult));
            } else {
                LOGGER.debug("Not storing result of {} in cache because the execution failed", (Object)context.getWork().getDisplayName());
            }
            return executionResult;
        });
    }

    @Nullable
    private BuildCacheCommandFactory.LoadMetadata load(final UnitOfWork work, BuildCacheKey cacheKey) {
        try {
            return (BuildCacheCommandFactory.LoadMetadata)this.buildCache.load(this.commandFactory.createLoad(cacheKey, (CacheableEntity)work, (Iterable)work.getLocalState(), new BuildCacheLoadListener(){

                public void beforeLoad() {
                    Optional<? extends Iterable<String>> changingOutputs = work.getChangingOutputs();
                    changingOutputs.ifPresent(affectedPaths -> CacheStep.this.outputChangeListener.beforeOutputChange((Iterable<String>)affectedPaths));
                    if (!changingOutputs.isPresent()) {
                        CacheStep.this.outputChangeListener.beforeOutputChange();
                    }
                }

                public void afterLoadFailedAndWasCleanedUp(Throwable error) {
                    work.outputsRemovedAfterFailureToLoadFromCache();
                }
            }));
        }
        catch (UnrecoverableUnpackingException e) {
            throw e;
        }
        catch (Exception e) {
            LOGGER.warn("Failed to load cache entry for {}, falling back to executing task", (Object)work.getDisplayName(), (Object)e);
            return null;
        }
    }

    private void store(UnitOfWork work, BuildCacheKey cacheKey, CurrentSnapshotResult result) {
        try {
            this.buildCache.store(this.commandFactory.createStore(cacheKey, (CacheableEntity)work, result.getFinalOutputs(), result.getOriginMetadata().getExecutionTime()));
        }
        catch (Exception e) {
            LOGGER.warn("Failed to store cache entry {}", (Object)cacheKey.getDisplayName(), (Object)e);
        }
    }

    private CurrentSnapshotResult executeWithoutCache(C context) {
        return this.delegate.execute(context);
    }
}

