/*
 * Decompiled with CFR 0.152.
 */
package org.gradle.plugins.ear;

import groovy.lang.Closure;
import groovy.lang.DelegatesTo;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.util.concurrent.Callable;
import javax.annotation.Nullable;
import javax.inject.Inject;
import org.gradle.api.Action;
import org.gradle.api.file.CopySpec;
import org.gradle.api.file.DuplicatesStrategy;
import org.gradle.api.file.FileCopyDetails;
import org.gradle.api.file.RelativePath;
import org.gradle.api.internal.file.collections.FileTreeAdapter;
import org.gradle.api.internal.file.collections.GeneratedSingletonFileTree;
import org.gradle.api.internal.file.collections.MinimalFileTree;
import org.gradle.api.internal.file.copy.CopySpecInternal;
import org.gradle.api.model.ObjectFactory;
import org.gradle.api.tasks.Input;
import org.gradle.api.tasks.Internal;
import org.gradle.api.tasks.Optional;
import org.gradle.api.tasks.bundling.Jar;
import org.gradle.plugins.ear.descriptor.DeploymentDescriptor;
import org.gradle.plugins.ear.descriptor.internal.DefaultDeploymentDescriptor;
import org.gradle.plugins.ear.descriptor.internal.DefaultEarModule;
import org.gradle.plugins.ear.descriptor.internal.DefaultEarWebModule;
import org.gradle.util.ConfigureUtil;
import org.gradle.util.DeprecationLogger;
import org.gradle.util.GUtil;

public class Ear
extends Jar {
    public static final String EAR_EXTENSION = "ear";
    private String libDirName;
    private DeploymentDescriptor deploymentDescriptor;
    private CopySpec lib;

    public Ear() {
        this.getArchiveExtension().set((Object)EAR_EXTENSION);
        this.setMetadataCharset("UTF-8");
        this.lib = this.getRootSpec().addChildBeforeSpec(this.getMainSpec()).into((Object)new Callable<String>(){

            @Override
            public String call() {
                return (String)GUtil.elvis((Object)Ear.this.getLibDirName(), (Object)"lib");
            }
        });
        this.getMainSpec().appendCachingSafeCopyAction((Action)new Action<FileCopyDetails>(){

            public void execute(FileCopyDetails details) {
                this.checkIfShouldGenerateDeploymentDescriptor(details);
                this.recordTopLevelModules(details);
            }

            private void recordTopLevelModules(FileCopyDetails details) {
                DeploymentDescriptor deploymentDescriptor = Ear.this.getDeploymentDescriptor();
                if (deploymentDescriptor != null && details.getPath().lastIndexOf("/") <= 0) {
                    DefaultEarModule module = details.getPath().toLowerCase().endsWith(".war") ? new DefaultEarWebModule(details.getPath(), details.getPath().substring(0, details.getPath().lastIndexOf("."))) : new DefaultEarModule(details.getPath());
                    if (!deploymentDescriptor.getModules().contains(module)) {
                        deploymentDescriptor.getModules().add(module);
                    }
                }
            }

            private void checkIfShouldGenerateDeploymentDescriptor(FileCopyDetails details) {
                String descriptorPath;
                DeploymentDescriptor deploymentDescriptor = Ear.this.getDeploymentDescriptor();
                String string = descriptorPath = deploymentDescriptor != null ? "META-INF/" + deploymentDescriptor.getFileName() : null;
                if (details.getPath().equalsIgnoreCase(descriptorPath)) {
                    Ear.this.setDeploymentDescriptor(null);
                    details.setDuplicatesStrategy(DuplicatesStrategy.EXCLUDE);
                }
            }
        });
        CopySpecInternal metaInf = (CopySpecInternal)this.getMainSpec().addChild().into((Object)"META-INF");
        final CopySpecInternal descriptorChild = metaInf.addChild();
        descriptorChild.from(new Object[]{new Callable<FileTreeAdapter>(){

            @Override
            public FileTreeAdapter call() {
                final DeploymentDescriptor descriptor = Ear.this.getDeploymentDescriptor();
                if (descriptor != null) {
                    RelativePath relativePath;
                    if (descriptor.getLibraryDirectory() == null) {
                        descriptor.setLibraryDirectory(Ear.this.getLibDirName());
                    }
                    if ((relativePath = RelativePath.parse((boolean)true, (String)descriptor.getFileName())).getSegments().length > 1) {
                        DeprecationLogger.nagUserOfDeprecated((String)"File paths in deployment descriptor file name", (String)"Use simple file name instead.");
                        descriptorChild.into((Object)relativePath.getParent().getPathString());
                    }
                    GeneratedSingletonFileTree descriptorSource = new GeneratedSingletonFileTree(Ear.this.getTemporaryDirFactory(), relativePath.getLastName(), (Action)new Action<OutputStream>(){

                        public void execute(OutputStream outputStream) {
                            descriptor.writeTo(new OutputStreamWriter(outputStream));
                        }
                    });
                    return new FileTreeAdapter((MinimalFileTree)descriptorSource);
                }
                return null;
            }
        }});
    }

    @Inject
    protected ObjectFactory getObjectFactory() {
        throw new UnsupportedOperationException();
    }

    public Ear deploymentDescriptor(@DelegatesTo(value=DeploymentDescriptor.class, strategy=1) Closure configureClosure) {
        ConfigureUtil.configure((Closure)configureClosure, (Object)this.forceDeploymentDescriptor());
        return this;
    }

    public Ear deploymentDescriptor(Action<? super DeploymentDescriptor> configureAction) {
        configureAction.execute((Object)this.forceDeploymentDescriptor());
        return this;
    }

    private DeploymentDescriptor forceDeploymentDescriptor() {
        if (this.deploymentDescriptor == null) {
            this.deploymentDescriptor = (DeploymentDescriptor)this.getObjectFactory().newInstance(DefaultDeploymentDescriptor.class, new Object[]{this.getFileResolver(), this.getObjectFactory()});
        }
        return this.deploymentDescriptor;
    }

    @Internal
    public CopySpec getLib() {
        return ((CopySpecInternal)this.lib).addChild();
    }

    public CopySpec lib(@DelegatesTo(value=CopySpec.class, strategy=1) Closure configureClosure) {
        return (CopySpec)ConfigureUtil.configure((Closure)configureClosure, (Object)this.getLib());
    }

    public CopySpec lib(Action<? super CopySpec> configureAction) {
        CopySpec copySpec = this.getLib();
        configureAction.execute((Object)copySpec);
        return copySpec;
    }

    @Nullable
    @Optional
    @Input
    public String getLibDirName() {
        return this.libDirName;
    }

    public void setLibDirName(@Nullable String libDirName) {
        this.libDirName = libDirName;
    }

    @Internal
    public DeploymentDescriptor getDeploymentDescriptor() {
        return this.deploymentDescriptor;
    }

    public void setDeploymentDescriptor(DeploymentDescriptor deploymentDescriptor) {
        this.deploymentDescriptor = deploymentDescriptor;
    }
}

