/*
 * Decompiled with CFR 0.152.
 */
package org.gradle.api.internal.tasks.execution;

import java.time.Duration;
import org.gradle.api.InvalidUserDataException;
import org.gradle.api.internal.TaskInternal;
import org.gradle.api.internal.tasks.TaskExecuter;
import org.gradle.api.internal.tasks.TaskExecutionContext;
import org.gradle.api.internal.tasks.TaskStateInternal;
import org.gradle.api.internal.tasks.timeout.Timeout;
import org.gradle.api.internal.tasks.timeout.TimeoutHandler;
import org.gradle.api.provider.Property;

public class TimeoutTaskExecuter
implements TaskExecuter {
    private final TaskExecuter delegate;
    private final TimeoutHandler timeoutHandler;

    public TimeoutTaskExecuter(TaskExecuter delegate, TimeoutHandler timeoutHandler) {
        this.delegate = delegate;
        this.timeoutHandler = timeoutHandler;
    }

    @Override
    public void execute(TaskInternal task, TaskStateInternal state, TaskExecutionContext context) {
        Property timeoutProperty = task.getTimeout();
        if (timeoutProperty.isPresent()) {
            Duration timeout = (Duration)timeoutProperty.get();
            if (timeout.isNegative()) {
                throw new InvalidUserDataException("Timeout of " + task + " must be positive, but was " + timeout.toString().substring(2));
            }
            this.executeWithTimeout(task, state, context, timeout);
        } else {
            this.delegate.execute(task, state, context);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void executeWithTimeout(TaskInternal task, TaskStateInternal state, TaskExecutionContext context, Duration timeout) {
        Timeout taskTimeout = this.timeoutHandler.start(Thread.currentThread(), timeout);
        try {
            this.delegate.execute(task, state, context);
        }
        finally {
            taskTimeout.stop();
            if (taskTimeout.timedOut()) {
                state.setAborted(task + " exceeded its timeout");
                Thread.interrupted();
            }
        }
    }
}

