/*
 * Decompiled with CFR 0.152.
 */
package org.gradle.api.internal;

import org.gradle.api.internal.ClassGenerator;
import org.gradle.api.internal.ClassGeneratorBackedInstantiator;
import org.gradle.api.internal.DependencyInjectingInstantiator;
import org.gradle.api.internal.InstantiatorFactory;
import org.gradle.cache.internal.CrossBuildInMemoryCache;
import org.gradle.cache.internal.CrossBuildInMemoryCacheFactory;
import org.gradle.internal.reflect.DirectInstantiator;
import org.gradle.internal.reflect.Instantiator;
import org.gradle.internal.service.DefaultServiceRegistry;
import org.gradle.internal.service.ServiceRegistry;

public class DefaultInstantiatorFactory
implements InstantiatorFactory {
    private final CrossBuildInMemoryCache<Class<?>, DependencyInjectingInstantiator.CachedConstructor> decoratedConstructorCache;
    private final CrossBuildInMemoryCache<Class<?>, DependencyInjectingInstantiator.CachedConstructor> undecoratedConstructorCache;
    private final ServiceRegistry noServices = new DefaultServiceRegistry();
    private final ClassGenerator classGenerator;
    private final Instantiator decoratingInstantiator;

    public DefaultInstantiatorFactory(ClassGenerator classGenerator, CrossBuildInMemoryCacheFactory cacheFactory) {
        this.classGenerator = classGenerator;
        this.decoratedConstructorCache = cacheFactory.newClassCache();
        this.undecoratedConstructorCache = cacheFactory.newClassCache();
        this.decoratingInstantiator = new ClassGeneratorBackedInstantiator(classGenerator, DirectInstantiator.INSTANCE);
    }

    @Override
    public Instantiator inject(ServiceRegistry registry) {
        return new DependencyInjectingInstantiator(registry, this.undecoratedConstructorCache);
    }

    @Override
    public Instantiator inject() {
        return new DependencyInjectingInstantiator(this.noServices, this.undecoratedConstructorCache);
    }

    @Override
    public Instantiator decorate() {
        return this.decoratingInstantiator;
    }

    @Override
    public Instantiator injectAndDecorate(ServiceRegistry registry) {
        return new DependencyInjectingInstantiator(this.classGenerator, registry, this.decoratedConstructorCache);
    }
}

