/*
 * Decompiled with CFR 0.152.
 */
package org.gradle.composite.internal;

import com.google.common.collect.ImmutableList;
import com.google.common.collect.Maps;
import java.util.Map;
import org.gradle.api.artifacts.component.BuildIdentifier;
import org.gradle.composite.internal.DefaultIncludedBuildController;
import org.gradle.composite.internal.IncludedBuildController;
import org.gradle.composite.internal.IncludedBuildControllers;
import org.gradle.internal.build.BuildStateRegistry;
import org.gradle.internal.build.IncludedBuildState;
import org.gradle.internal.concurrent.CompositeStoppable;
import org.gradle.internal.concurrent.ExecutorFactory;
import org.gradle.internal.concurrent.ManagedExecutor;
import org.gradle.internal.concurrent.Stoppable;
import org.gradle.internal.operations.BuildOperationRef;
import org.gradle.internal.operations.CurrentBuildOperationRef;

class DefaultIncludedBuildControllers
implements Stoppable,
IncludedBuildControllers {
    private final Map<BuildIdentifier, IncludedBuildController> buildControllers = Maps.newHashMap();
    private final ManagedExecutor executorService;
    private final BuildStateRegistry buildRegistry;
    private BuildOperationRef rootBuildOperation;

    DefaultIncludedBuildControllers(ExecutorFactory executorFactory, BuildStateRegistry buildRegistry) {
        this.buildRegistry = buildRegistry;
        this.executorService = executorFactory.create("included builds");
    }

    public void rootBuildOperationStarted() {
        this.rootBuildOperation = CurrentBuildOperationRef.instance().get();
    }

    public IncludedBuildController getBuildController(BuildIdentifier buildId) {
        IncludedBuildController buildController = this.buildControllers.get(buildId);
        if (buildController != null) {
            return buildController;
        }
        IncludedBuildState build = this.buildRegistry.getIncludedBuild(buildId);
        DefaultIncludedBuildController newBuildController = new DefaultIncludedBuildController(build);
        this.buildControllers.put(buildId, newBuildController);
        this.executorService.submit((Runnable)new BuildOpRunnable(newBuildController, this.rootBuildOperation));
        return newBuildController;
    }

    public void startTaskExecution() {
        for (IncludedBuildController buildController : this.buildControllers.values()) {
            buildController.startTaskExecution();
        }
    }

    public void populateTaskGraphs() {
        boolean tasksDiscovered = true;
        while (tasksDiscovered) {
            tasksDiscovered = false;
            for (IncludedBuildController buildController : ImmutableList.copyOf(this.buildControllers.values())) {
                if (!buildController.populateTaskGraph()) continue;
                tasksDiscovered = true;
            }
        }
    }

    public void stopTaskExecution() {
        for (IncludedBuildController buildController : this.buildControllers.values()) {
            buildController.stopTaskExecution();
        }
        this.buildControllers.clear();
        for (IncludedBuildState includedBuild : this.buildRegistry.getIncludedBuilds()) {
            includedBuild.finishBuild();
        }
    }

    public void stop() {
        CompositeStoppable.stoppable(this.buildControllers.values()).stop();
        this.executorService.stop();
    }

    private static class BuildOpRunnable
    implements Runnable {
        private final DefaultIncludedBuildController newBuildController;
        private final BuildOperationRef rootBuildOperation;

        BuildOpRunnable(DefaultIncludedBuildController newBuildController, BuildOperationRef rootBuildOperation) {
            this.newBuildController = newBuildController;
            this.rootBuildOperation = rootBuildOperation;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void run() {
            CurrentBuildOperationRef.instance().set(this.rootBuildOperation);
            try {
                this.newBuildController.run();
            }
            finally {
                CurrentBuildOperationRef.instance().set(null);
            }
        }
    }
}

