/*
 * Decompiled with CFR 0.152.
 */
package org.gradle.api.internal.file;

import java.io.File;
import javax.annotation.Nullable;
import org.gradle.api.Task;
import org.gradle.api.file.ConfigurableFileCollection;
import org.gradle.api.file.Directory;
import org.gradle.api.file.DirectoryProperty;
import org.gradle.api.file.DirectoryVar;
import org.gradle.api.file.FileCollection;
import org.gradle.api.file.FileSystemLocation;
import org.gradle.api.file.FileTree;
import org.gradle.api.file.ProjectLayout;
import org.gradle.api.file.RegularFile;
import org.gradle.api.file.RegularFileProperty;
import org.gradle.api.file.RegularFileVar;
import org.gradle.api.internal.file.CachingTaskInputFileCollection;
import org.gradle.api.internal.file.CalculatedTaskInputFileCollection;
import org.gradle.api.internal.file.FileResolver;
import org.gradle.api.internal.file.TaskFileVarFactory;
import org.gradle.api.internal.file.collections.DefaultConfigurableFileCollection;
import org.gradle.api.internal.file.collections.ImmutableFileCollection;
import org.gradle.api.internal.file.collections.MinimalFileSet;
import org.gradle.api.internal.provider.AbstractCombiningProvider;
import org.gradle.api.internal.provider.AbstractMappingProvider;
import org.gradle.api.internal.provider.AbstractProvider;
import org.gradle.api.internal.provider.DefaultPropertyState;
import org.gradle.api.internal.tasks.AbstractTaskDependency;
import org.gradle.api.internal.tasks.TaskDependencyContainer;
import org.gradle.api.internal.tasks.TaskDependencyResolveContext;
import org.gradle.api.internal.tasks.TaskResolver;
import org.gradle.api.provider.Provider;
import org.gradle.internal.file.PathToFileResolver;
import org.gradle.util.DeprecationLogger;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class DefaultProjectLayout
implements ProjectLayout,
TaskFileVarFactory {
    private final FixedDirectory projectDir;
    private final DefaultDirectoryVar buildDir;
    private final TaskResolver taskResolver;
    private final FileResolver fileResolver;

    public DefaultProjectLayout(File projectDir, FileResolver resolver, TaskResolver taskResolver) {
        this.taskResolver = taskResolver;
        this.fileResolver = resolver;
        this.projectDir = new FixedDirectory(projectDir, resolver);
        this.buildDir = new DefaultDirectoryVar(resolver, "build");
    }

    public Directory getProjectDirectory() {
        return this.projectDir;
    }

    public DirectoryProperty getBuildDirectory() {
        return this.buildDir;
    }

    public DirectoryVar newDirectoryVar() {
        DeprecationLogger.nagUserOfReplacedMethod((String)"ProjectLayout.newDirectoryVar()", (String)"ProjectLayout.directoryProperty()");
        return this.directoryProperty();
    }

    public DirectoryVar directoryProperty() {
        return new DefaultDirectoryVar(this.projectDir.fileResolver);
    }

    public DirectoryVar directoryProperty(Provider<? extends Directory> initialProvider) {
        DirectoryVar result = this.directoryProperty();
        result.set(initialProvider);
        return result;
    }

    public RegularFileVar newFileVar() {
        DeprecationLogger.nagUserOfReplacedMethod((String)"ProjectLayout.newFileVar()", (String)"ProjectLayout.fileProperty()");
        return this.fileProperty();
    }

    public RegularFileVar fileProperty() {
        return new DefaultRegularFileVar(this.projectDir.fileResolver);
    }

    public RegularFileVar fileProperty(Provider<? extends RegularFile> initialProvider) {
        RegularFileVar result = this.fileProperty();
        result.set(initialProvider);
        return result;
    }

    @Override
    public DirectoryProperty newOutputDirectory(Task producer) {
        return new BuildableDirectoryVar(this.projectDir.fileResolver, producer);
    }

    @Override
    public RegularFileProperty newOutputFile(Task producer) {
        return new BuildableRegularFileVar(this.projectDir.fileResolver, producer);
    }

    @Override
    public RegularFileProperty newInputFile(Task consumer) {
        final DefaultRegularFileVar fileVar = new DefaultRegularFileVar(this.projectDir.fileResolver);
        consumer.dependsOn(new Object[]{new AbstractTaskDependency(){

            public void visitDependencies(TaskDependencyResolveContext context) {
                fileVar.visitDependencies(context);
            }
        }});
        return fileVar;
    }

    @Override
    public DirectoryProperty newInputDirectory(Task consumer) {
        final DefaultDirectoryVar directoryVar = new DefaultDirectoryVar(this.projectDir.fileResolver);
        consumer.dependsOn(new Object[]{new AbstractTaskDependency(){

            public void visitDependencies(TaskDependencyResolveContext context) {
                directoryVar.visitDependencies(context);
            }
        }});
        return directoryVar;
    }

    @Override
    public ConfigurableFileCollection newInputFileCollection(Task consumer) {
        return new CachingTaskInputFileCollection(consumer.getPath(), this.projectDir.fileResolver, this.taskResolver);
    }

    @Override
    public FileCollection newCalculatedInputFileCollection(Task consumer, MinimalFileSet calculatedFiles, FileCollection ... inputs) {
        return new CalculatedTaskInputFileCollection(consumer.getPath(), calculatedFiles, inputs);
    }

    public Provider<RegularFile> file(Provider<File> provider) {
        return new AbstractMappingProvider<RegularFile, File>(RegularFile.class, provider){

            @Override
            protected RegularFile map(File file) {
                return new FixedFile(DefaultProjectLayout.this.projectDir.fileResolver.resolve(file));
            }
        };
    }

    public FileCollection files(Object ... paths) {
        return ImmutableFileCollection.usingResolver(this.fileResolver, paths);
    }

    public ConfigurableFileCollection configurableFiles(Object ... files) {
        return new DefaultConfigurableFileCollection((PathToFileResolver)this.fileResolver, this.taskResolver, files);
    }

    public void setBuildDirectory(Object value) {
        this.buildDir.resolveAndSet(value);
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private static class ToFileProvider
    extends AbstractMappingProvider<File, FileSystemLocation> {
        ToFileProvider(Provider<? extends FileSystemLocation> provider) {
            super(File.class, provider);
        }

        @Override
        protected File map(FileSystemLocation provider) {
            return provider.getAsFile();
        }
    }

    private static class BuildableDirectoryVar
    extends DefaultDirectoryVar {
        private final Task producer;

        BuildableDirectoryVar(FileResolver resolver, Task producer) {
            super(resolver);
            this.producer = producer;
        }

        public void visitDependencies(TaskDependencyResolveContext context) {
            context.add(this.producer);
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private static class DefaultDirectoryVar
    extends DefaultPropertyState<Directory>
    implements DirectoryVar,
    TaskDependencyContainer {
        private final FileResolver resolver;

        DefaultDirectoryVar(FileResolver resolver) {
            super(Directory.class);
            this.resolver = resolver;
        }

        DefaultDirectoryVar(FileResolver resolver, Object value) {
            super(Directory.class);
            this.resolver = resolver;
            this.resolveAndSet(value);
        }

        @Override
        public void setFromAnyValue(Object object) {
            if (object instanceof File) {
                File file = (File)object;
                this.set(file);
            } else {
                super.setFromAnyValue(object);
            }
        }

        @Override
        public void visitDependencies(TaskDependencyResolveContext context) {
            if (this.getProvider() instanceof TaskDependencyContainer) {
                context.add(this.getProvider());
            }
        }

        public FileTree getAsFileTree() {
            return this.resolver.resolveFilesAsTree(this);
        }

        public Provider<File> getAsFile() {
            return new ToFileProvider(this);
        }

        void resolveAndSet(Object value) {
            File resolved = this.resolver.resolve(value);
            this.set(new FixedDirectory(resolved, this.resolver.newResolver(resolved)));
        }

        @Override
        public void set(File dir) {
            File resolved = this.resolver.resolve(dir);
            this.set(new FixedDirectory(resolved, this.resolver.newResolver(resolved)));
        }

        public Provider<Directory> dir(final String path) {
            return new AbstractMappingProvider<Directory, Directory>(Directory.class, (Provider)this){

                @Override
                protected Directory map(Directory dir) {
                    return dir.dir(path);
                }
            };
        }

        public Provider<Directory> dir(Provider<? extends CharSequence> path) {
            return new AbstractCombiningProvider<Directory, Directory, CharSequence>(Directory.class, (Provider)this, path){

                @Override
                protected Directory map(Directory b, CharSequence v) {
                    return b.dir(v.toString());
                }
            };
        }

        public Provider<RegularFile> file(final String path) {
            return new AbstractMappingProvider<RegularFile, Directory>(RegularFile.class, (Provider)this){

                @Override
                protected RegularFile map(Directory dir) {
                    return dir.file(path);
                }
            };
        }

        public Provider<RegularFile> file(Provider<? extends CharSequence> path) {
            return new AbstractCombiningProvider<RegularFile, Directory, CharSequence>(RegularFile.class, (Provider)this, path){

                @Override
                protected RegularFile map(Directory b, CharSequence v) {
                    return b.file(v.toString());
                }
            };
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private static class ResolvingDirectory
    extends AbstractProvider<Directory>
    implements TaskDependencyContainer {
        private final FileResolver resolver;
        private final Provider<?> valueProvider;

        ResolvingDirectory(FileResolver resolver, Provider<?> valueProvider) {
            this.resolver = resolver;
            this.valueProvider = valueProvider;
        }

        @Override
        @Nullable
        public Class<Directory> getType() {
            return Directory.class;
        }

        @Override
        public void visitDependencies(TaskDependencyResolveContext context) {
        }

        @Override
        public boolean isPresent() {
            return this.valueProvider.isPresent();
        }

        public Directory getOrNull() {
            if (!this.isPresent()) {
                return null;
            }
            File dir = this.resolver.resolve(this.valueProvider);
            return new FixedDirectory(dir, this.resolver.newResolver(dir));
        }
    }

    private static class BuildableRegularFileVar
    extends DefaultRegularFileVar {
        private final Task producer;

        BuildableRegularFileVar(PathToFileResolver fileResolver, Task producer) {
            super(fileResolver);
            this.producer = producer;
        }

        public void visitDependencies(TaskDependencyResolveContext context) {
            context.add(this.producer);
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private static class DefaultRegularFileVar
    extends DefaultPropertyState<RegularFile>
    implements RegularFileVar,
    TaskDependencyContainer {
        private final PathToFileResolver fileResolver;

        DefaultRegularFileVar(PathToFileResolver fileResolver) {
            super(RegularFile.class);
            this.fileResolver = fileResolver;
        }

        @Override
        public void visitDependencies(TaskDependencyResolveContext context) {
            if (this.getProvider() instanceof TaskDependencyContainer) {
                context.add(this.getProvider());
            }
        }

        @Override
        public void setFromAnyValue(Object object) {
            if (object instanceof File) {
                this.set((File)object);
            } else {
                super.setFromAnyValue(object);
            }
        }

        public Provider<File> getAsFile() {
            return new ToFileProvider(this);
        }

        @Override
        public void set(File file) {
            this.set(new FixedFile(this.fileResolver.resolve((Object)file)));
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private static class ResolvingFile
    extends AbstractMappingProvider<RegularFile, CharSequence>
    implements TaskDependencyContainer {
        private final PathToFileResolver resolver;

        ResolvingFile(PathToFileResolver resolver, Provider<? extends CharSequence> path) {
            super(RegularFile.class, path);
            this.resolver = resolver;
        }

        @Override
        public void visitDependencies(TaskDependencyResolveContext context) {
        }

        @Override
        protected RegularFile map(CharSequence path) {
            return new FixedFile(this.resolver.resolve((Object)path));
        }
    }

    private static class FixedFile
    implements RegularFile,
    FileSystemLocation {
        private final File file;

        FixedFile(File file) {
            this.file = file;
        }

        public String toString() {
            return this.file.toString();
        }

        public File getAsFile() {
            return this.file;
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private static class FixedDirectory
    implements Directory,
    FileSystemLocation {
        private final File value;
        private final FileResolver fileResolver;

        FixedDirectory(File value, FileResolver fileResolver) {
            this.value = value;
            this.fileResolver = fileResolver;
        }

        public String toString() {
            return this.value.toString();
        }

        public File getAsFile() {
            return this.value;
        }

        public Directory dir(String path) {
            File newDir = this.fileResolver.resolve(path);
            return new FixedDirectory(newDir, this.fileResolver.newResolver(newDir));
        }

        public FileTree getAsFileTree() {
            return this.fileResolver.resolveFilesAsTree(this);
        }

        public Provider<Directory> dir(Provider<? extends CharSequence> path) {
            return new ResolvingDirectory(this.fileResolver, path);
        }

        public RegularFile file(String path) {
            return new FixedFile(this.fileResolver.resolve(path));
        }

        public Provider<RegularFile> file(Provider<? extends CharSequence> path) {
            return new ResolvingFile(this.fileResolver, path);
        }
    }
}

