/*
 * Decompiled with CFR 0.152.
 */
package org.gradle.api.internal.collections;

import java.util.Iterator;
import java.util.List;
import java.util.ListIterator;
import org.gradle.api.internal.collections.CollectionFilter;
import org.gradle.api.internal.collections.ElementSource;
import org.gradle.api.internal.collections.FilteredCollection;
import org.gradle.api.internal.collections.IndexedElementSource;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class FilteredList<T, S extends T>
extends FilteredCollection<T, S>
implements IndexedElementSource<S> {
    public FilteredList(ElementSource<T> collection, CollectionFilter<S> filter) {
        super(collection, filter);
    }

    @Override
    public void add(int index, S element) {
        throw new UnsupportedOperationException(String.format("Cannot add '%s' to '%s' as it is a filtered collection", element, this));
    }

    @Override
    public S get(int index) {
        int nextIndex = 0;
        for (Object t : this.collection) {
            Object s = this.filter.filter(t);
            if (s == null) continue;
            if (nextIndex == index) {
                return (S)s;
            }
            ++nextIndex;
        }
        throw new IndexOutOfBoundsException();
    }

    @Override
    public S set(int index, S element) {
        throw new UnsupportedOperationException(String.format("Cannot set '%s' in '%s' as it is a filtered collection", element, this));
    }

    @Override
    public S remove(int index) {
        throw new UnsupportedOperationException(String.format("Cannot remove element from '%s' as it is a filtered collection", this));
    }

    @Override
    public int indexOf(Object o) {
        int nextIndex = 0;
        for (Object t : this.collection) {
            Object s = this.filter.filter(t);
            if (s == null) continue;
            if (s.equals(o)) {
                return nextIndex;
            }
            ++nextIndex;
        }
        return -1;
    }

    @Override
    public int lastIndexOf(Object o) {
        int nextIndex = 0;
        int lastMatch = -1;
        for (Object t : this.collection) {
            Object s = this.filter.filter(t);
            if (s == null) continue;
            if (s.equals(o)) {
                lastMatch = nextIndex;
            }
            ++nextIndex;
        }
        return lastMatch;
    }

    @Override
    public ListIterator<S> listIterator() {
        return new FilteredListIterator(this.iterator());
    }

    @Override
    public ListIterator<S> listIterator(int index) {
        ListIterator<S> iterator = this.listIterator();
        for (int i = 0; i < index; ++i) {
            iterator.next();
        }
        return iterator;
    }

    @Override
    public List<S> subList(int fromIndex, int toIndex) {
        throw new UnsupportedOperationException("Not implemented yet.");
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private static class FilteredListIterator<T>
    implements ListIterator<T> {
        private final Iterator<T> iterator;
        private int nextIndex;

        FilteredListIterator(Iterator<T> iterator) {
            this.iterator = iterator;
        }

        @Override
        public boolean hasNext() {
            return this.iterator.hasNext();
        }

        @Override
        public boolean hasPrevious() {
            throw new UnsupportedOperationException("Not implemented yet.");
        }

        @Override
        public T next() {
            ++this.nextIndex;
            return this.iterator.next();
        }

        @Override
        public T previous() {
            throw new UnsupportedOperationException("Not implemented yet.");
        }

        @Override
        public int nextIndex() {
            return this.nextIndex;
        }

        @Override
        public int previousIndex() {
            return this.nextIndex - 1;
        }

        @Override
        public void add(T t) {
            throw new UnsupportedOperationException();
        }

        @Override
        public void remove() {
            throw new UnsupportedOperationException();
        }

        @Override
        public void set(T t) {
            throw new UnsupportedOperationException();
        }
    }
}

