/*
 * Decompiled with CFR 0.152.
 */
package org.gradle.model.internal.manage.binding;

import java.lang.reflect.Constructor;
import java.lang.reflect.Field;
import java.lang.reflect.Method;
import org.gradle.model.internal.inspect.FormattingValidationProblemCollector;
import org.gradle.model.internal.manage.binding.StructBindingValidationProblemCollector;
import org.gradle.model.internal.manage.schema.StructSchema;
import org.gradle.model.internal.method.WeaklyTypeReferencingMethod;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class StructBindingExtractionContext<T>
implements StructBindingValidationProblemCollector {
    private final StructSchema<T> publicSchema;
    private final Iterable<StructSchema<?>> implementedSchemas;
    private final StructSchema<?> delegateSchema;
    final FormattingValidationProblemCollector problems;

    public StructBindingExtractionContext(StructSchema<T> publicSchema, Iterable<StructSchema<?>> implementedSchemas, StructSchema<?> delegateSchema) {
        this.publicSchema = publicSchema;
        this.implementedSchemas = implementedSchemas;
        this.delegateSchema = delegateSchema;
        this.problems = new FormattingValidationProblemCollector("managed type", publicSchema.getType());
    }

    public StructSchema<T> getPublicSchema() {
        return this.publicSchema;
    }

    public Iterable<StructSchema<?>> getImplementedSchemas() {
        return this.implementedSchemas;
    }

    public StructSchema<?> getDelegateSchema() {
        return this.delegateSchema;
    }

    @Override
    public boolean hasProblems() {
        return this.problems.hasProblems();
    }

    @Override
    public void add(String problem) {
        this.problems.add(problem);
    }

    @Override
    public void add(Field field, String problem) {
        this.problems.add(field, problem);
    }

    @Override
    public void add(WeaklyTypeReferencingMethod<?, ?> method, String problem) {
        this.add(method.getMethod(), problem);
    }

    @Override
    public void add(WeaklyTypeReferencingMethod<?, ?> method, String role, String problem) {
        this.add(method.getMethod(), role, problem);
    }

    @Override
    public void add(Method method, String role, String problem) {
        this.problems.add(method, role, problem);
    }

    @Override
    public void add(Method method, String problem) {
        this.add(method, null, problem);
    }

    @Override
    public void add(Constructor<?> constructor, String problem) {
        this.problems.add(constructor, problem);
    }

    @Override
    public void add(String property, String problem) {
        this.problems.add("Property '" + property + "' is not valid: " + problem);
    }
}

