/*
 * Decompiled with CFR 0.152.
 */
package org.gradle.plugins.ide.internal.tooling;

import com.google.common.collect.Lists;
import com.google.common.collect.Maps;
import java.io.File;
import java.util.ArrayList;
import java.util.LinkedHashMap;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.apache.commons.lang.StringUtils;
import org.gradle.api.Project;
import org.gradle.api.Task;
import org.gradle.api.initialization.IncludedBuild;
import org.gradle.api.specs.Spec;
import org.gradle.internal.build.IncludedBuildState;
import org.gradle.internal.service.ServiceRegistry;
import org.gradle.plugins.ide.eclipse.EclipsePlugin;
import org.gradle.plugins.ide.eclipse.model.AbstractClasspathEntry;
import org.gradle.plugins.ide.eclipse.model.AbstractLibrary;
import org.gradle.plugins.ide.eclipse.model.AccessRule;
import org.gradle.plugins.ide.eclipse.model.BuildCommand;
import org.gradle.plugins.ide.eclipse.model.Classpath;
import org.gradle.plugins.ide.eclipse.model.ClasspathEntry;
import org.gradle.plugins.ide.eclipse.model.Container;
import org.gradle.plugins.ide.eclipse.model.EclipseClasspath;
import org.gradle.plugins.ide.eclipse.model.EclipseJdt;
import org.gradle.plugins.ide.eclipse.model.EclipseModel;
import org.gradle.plugins.ide.eclipse.model.EclipseProject;
import org.gradle.plugins.ide.eclipse.model.Library;
import org.gradle.plugins.ide.eclipse.model.Link;
import org.gradle.plugins.ide.eclipse.model.Output;
import org.gradle.plugins.ide.eclipse.model.ProjectDependency;
import org.gradle.plugins.ide.eclipse.model.SourceFolder;
import org.gradle.plugins.ide.internal.tooling.GradleProjectBuilder;
import org.gradle.plugins.ide.internal.tooling.TasksFactory;
import org.gradle.plugins.ide.internal.tooling.eclipse.DefaultAccessRule;
import org.gradle.plugins.ide.internal.tooling.eclipse.DefaultClasspathAttribute;
import org.gradle.plugins.ide.internal.tooling.eclipse.DefaultEclipseBuildCommand;
import org.gradle.plugins.ide.internal.tooling.eclipse.DefaultEclipseClasspathContainer;
import org.gradle.plugins.ide.internal.tooling.eclipse.DefaultEclipseExternalDependency;
import org.gradle.plugins.ide.internal.tooling.eclipse.DefaultEclipseJavaSourceSettings;
import org.gradle.plugins.ide.internal.tooling.eclipse.DefaultEclipseLinkedResource;
import org.gradle.plugins.ide.internal.tooling.eclipse.DefaultEclipseOutputLocation;
import org.gradle.plugins.ide.internal.tooling.eclipse.DefaultEclipseProject;
import org.gradle.plugins.ide.internal.tooling.eclipse.DefaultEclipseProjectDependency;
import org.gradle.plugins.ide.internal.tooling.eclipse.DefaultEclipseProjectNature;
import org.gradle.plugins.ide.internal.tooling.eclipse.DefaultEclipseSourceDirectory;
import org.gradle.plugins.ide.internal.tooling.eclipse.DefaultEclipseTask;
import org.gradle.plugins.ide.internal.tooling.java.DefaultInstalledJdk;
import org.gradle.tooling.internal.gradle.DefaultGradleProject;
import org.gradle.tooling.provider.model.ToolingModelBuilder;
import org.gradle.util.CollectionUtils;
import org.gradle.util.GUtil;

public class EclipseModelBuilder
implements ToolingModelBuilder {
    private final GradleProjectBuilder gradleProjectBuilder;
    private boolean projectDependenciesOnly;
    private DefaultEclipseProject result;
    private List<DefaultEclipseProject> eclipseProjects;
    private TasksFactory tasksFactory;
    private DefaultGradleProject<?> rootGradleProject;
    private Project currentProject;

    public EclipseModelBuilder(GradleProjectBuilder gradleProjectBuilder, ServiceRegistry services) {
        this.gradleProjectBuilder = gradleProjectBuilder;
    }

    public boolean canBuild(String modelName) {
        return modelName.equals("org.gradle.tooling.model.eclipse.EclipseProject") || modelName.equals("org.gradle.tooling.model.eclipse.HierarchicalEclipseProject");
    }

    public DefaultEclipseProject buildAll(String modelName, Project project) {
        boolean includeTasks = modelName.equals("org.gradle.tooling.model.eclipse.EclipseProject");
        this.tasksFactory = new TasksFactory(includeTasks);
        this.projectDependenciesOnly = modelName.equals("org.gradle.tooling.model.eclipse.HierarchicalEclipseProject");
        this.currentProject = project;
        this.eclipseProjects = Lists.newArrayList();
        Project root = project.getRootProject();
        this.rootGradleProject = this.gradleProjectBuilder.buildAll(project);
        this.tasksFactory.collectTasks(root);
        this.applyEclipsePlugin(root);
        this.buildHierarchy(root);
        this.populate(root);
        return this.result;
    }

    private void applyEclipsePlugin(Project root) {
        Set allProjects = root.getAllprojects();
        for (Project p : allProjects) {
            p.getPluginManager().apply(EclipsePlugin.class);
        }
        for (IncludedBuild includedBuild : root.getGradle().getIncludedBuilds()) {
            IncludedBuildState includedBuildInternal = (IncludedBuildState)includedBuild;
            this.applyEclipsePlugin((Project)includedBuildInternal.getConfiguredBuild().getRootProject());
        }
    }

    private DefaultEclipseProject buildHierarchy(Project project) {
        ArrayList<DefaultEclipseProject> children = new ArrayList<DefaultEclipseProject>();
        for (Project child : project.getChildProjects().values()) {
            children.add(this.buildHierarchy(child));
        }
        EclipseModel eclipseModel = (EclipseModel)project.getExtensions().getByType(EclipseModel.class);
        EclipseProject internalProject = eclipseModel.getProject();
        String name = internalProject.getName();
        String description = (String)GUtil.elvis((Object)internalProject.getComment(), null);
        DefaultEclipseProject eclipseProject = new DefaultEclipseProject(name, project.getPath(), description, project.getProjectDir(), children).setGradleProject(this.rootGradleProject.findByPath(project.getPath()));
        for (DefaultEclipseProject child : children) {
            child.setParent(eclipseProject);
        }
        this.addProject(project, eclipseProject);
        return eclipseProject;
    }

    private void addProject(Project project, DefaultEclipseProject eclipseProject) {
        if (project == this.currentProject) {
            this.result = eclipseProject;
        }
        this.eclipseProjects.add(eclipseProject);
    }

    private void populate(Project project) {
        List<ClasspathEntry> classpathEntries;
        EclipseModel eclipseModel = (EclipseModel)project.getExtensions().getByType(EclipseModel.class);
        EclipseClasspath eclipseClasspath = eclipseModel.getClasspath();
        eclipseClasspath.setProjectDependenciesOnly(this.projectDependenciesOnly);
        if (eclipseClasspath.getFile() == null) {
            classpathEntries = eclipseClasspath.resolveDependencies();
        } else {
            Classpath classpath = new Classpath(eclipseClasspath.getFileReferenceFactory());
            eclipseClasspath.mergeXmlClasspath(classpath);
            classpathEntries = classpath.getEntries();
        }
        LinkedList<DefaultEclipseExternalDependency> externalDependencies = new LinkedList<DefaultEclipseExternalDependency>();
        LinkedList<DefaultEclipseProjectDependency> projectDependencies = new LinkedList<DefaultEclipseProjectDependency>();
        LinkedList<DefaultEclipseSourceDirectory> sourceDirectories = new LinkedList<DefaultEclipseSourceDirectory>();
        LinkedList<DefaultEclipseClasspathContainer> classpathContainers = new LinkedList<DefaultEclipseClasspathContainer>();
        DefaultEclipseOutputLocation outputLocation = null;
        for (ClasspathEntry entry : classpathEntries) {
            String path;
            if (entry instanceof Library) {
                AbstractLibrary library = (AbstractLibrary)entry;
                File file = library.getLibrary().getFile();
                File source = library.getSourcePath() == null ? null : library.getSourcePath().getFile();
                File javadoc = library.getJavadocPath() == null ? null : library.getJavadocPath().getFile();
                DefaultEclipseExternalDependency dependency = new DefaultEclipseExternalDependency(file, javadoc, source, library.getModuleVersion(), library.isExported(), EclipseModelBuilder.createAttributes(library), EclipseModelBuilder.createAccessRules(library));
                externalDependencies.add(dependency);
                continue;
            }
            if (entry instanceof ProjectDependency) {
                ProjectDependency projectDependency = (ProjectDependency)entry;
                path = StringUtils.removeStart((String)projectDependency.getPath(), (String)"/");
                DefaultEclipseProjectDependency dependency = new DefaultEclipseProjectDependency(path, projectDependency.isExported(), EclipseModelBuilder.createAttributes(projectDependency), EclipseModelBuilder.createAccessRules(projectDependency));
                dependency.setTargetProject(this.findEclipseProjectByName(path));
                projectDependencies.add(dependency);
                continue;
            }
            if (entry instanceof SourceFolder) {
                SourceFolder sourceFolder = (SourceFolder)entry;
                path = sourceFolder.getPath();
                List<String> excludes = sourceFolder.getExcludes();
                List<String> includes = sourceFolder.getIncludes();
                String output = sourceFolder.getOutput();
                sourceDirectories.add(new DefaultEclipseSourceDirectory(path, sourceFolder.getDir(), excludes, includes, output, EclipseModelBuilder.createAttributes(sourceFolder), EclipseModelBuilder.createAccessRules(sourceFolder)));
                continue;
            }
            if (entry instanceof Container) {
                Container container = (Container)entry;
                classpathContainers.add(new DefaultEclipseClasspathContainer(container.getPath(), container.isExported(), EclipseModelBuilder.createAttributes(container), EclipseModelBuilder.createAccessRules(container)));
                continue;
            }
            if (!(entry instanceof Output)) continue;
            outputLocation = new DefaultEclipseOutputLocation(((Output)entry).getPath());
        }
        DefaultEclipseProject eclipseProject = this.findEclipseProject(project);
        eclipseProject.setClasspath(externalDependencies);
        eclipseProject.setProjectDependencies(projectDependencies);
        eclipseProject.setSourceDirectories(sourceDirectories);
        LinkedList<DefaultEclipseLinkedResource> linkedResources = new LinkedList<DefaultEclipseLinkedResource>();
        for (Link r : eclipseModel.getProject().getLinkedResources()) {
            linkedResources.add(new DefaultEclipseLinkedResource(r.getName(), r.getType(), r.getLocation(), r.getLocationUri()));
        }
        eclipseProject.setLinkedResources(linkedResources);
        ArrayList<DefaultEclipseTask> tasks = new ArrayList<DefaultEclipseTask>();
        for (Task t : this.tasksFactory.getTasks(project)) {
            tasks.add(new DefaultEclipseTask(eclipseProject, t.getPath(), t.getName(), t.getDescription()));
        }
        eclipseProject.setTasks(tasks);
        ArrayList<DefaultEclipseProjectNature> natures = new ArrayList<DefaultEclipseProjectNature>();
        for (String n : eclipseModel.getProject().getNatures()) {
            natures.add(new DefaultEclipseProjectNature(n));
        }
        eclipseProject.setProjectNatures(natures);
        ArrayList<DefaultEclipseBuildCommand> buildCommands = new ArrayList<DefaultEclipseBuildCommand>();
        for (BuildCommand b : eclipseModel.getProject().getBuildCommands()) {
            LinkedHashMap arguments = Maps.newLinkedHashMap();
            for (Map.Entry<String, String> entry : b.getArguments().entrySet()) {
                arguments.put(EclipseModelBuilder.convertGString(entry.getKey()), EclipseModelBuilder.convertGString(entry.getValue()));
            }
            buildCommands.add(new DefaultEclipseBuildCommand(b.getName(), arguments));
        }
        eclipseProject.setBuildCommands(buildCommands);
        EclipseJdt jdt = eclipseModel.getJdt();
        if (jdt != null) {
            eclipseProject.setJavaSourceSettings(new DefaultEclipseJavaSourceSettings().setSourceLanguageLevel(jdt.getSourceCompatibility()).setTargetBytecodeVersion(jdt.getTargetCompatibility()).setJdk(DefaultInstalledJdk.current()));
        }
        eclipseProject.setClasspathContainers(classpathContainers);
        eclipseProject.setOutputLocation(outputLocation != null ? outputLocation : new DefaultEclipseOutputLocation("bin"));
        for (Project childProject : project.getChildProjects().values()) {
            this.populate(childProject);
        }
    }

    private DefaultEclipseProject findEclipseProject(final Project project) {
        return (DefaultEclipseProject)CollectionUtils.findFirst(this.eclipseProjects, (Spec)new Spec<DefaultEclipseProject>(){

            public boolean isSatisfiedBy(DefaultEclipseProject element) {
                return element.getGradleProject().getPath().equals(project.getPath());
            }
        });
    }

    private DefaultEclipseProject findEclipseProjectByName(final String eclipseProjectName) {
        return (DefaultEclipseProject)CollectionUtils.findFirst(this.eclipseProjects, (Spec)new Spec<DefaultEclipseProject>(){

            public boolean isSatisfiedBy(DefaultEclipseProject element) {
                return element.getName().equals(eclipseProjectName);
            }
        });
    }

    private static List<DefaultClasspathAttribute> createAttributes(AbstractClasspathEntry classpathEntry) {
        ArrayList result = Lists.newArrayList();
        Map<String, Object> attributes = classpathEntry.getEntryAttributes();
        for (Map.Entry<String, Object> entry : attributes.entrySet()) {
            Object value = entry.getValue();
            result.add(new DefaultClasspathAttribute(EclipseModelBuilder.convertGString(entry.getKey()), value == null ? "" : value.toString()));
        }
        return result;
    }

    private static List<DefaultAccessRule> createAccessRules(AbstractClasspathEntry classpathEntry) {
        ArrayList result = Lists.newArrayList();
        for (AccessRule accessRule : classpathEntry.getAccessRules()) {
            result.add(EclipseModelBuilder.createAccessRule(accessRule));
        }
        return result;
    }

    private static DefaultAccessRule createAccessRule(AccessRule accessRule) {
        String kind = accessRule.getKind();
        int kindCode = kind.equals("accessible") || kind.equals("0") ? 0 : (kind.equals("nonaccessible") || kind.equals("1") ? 1 : (kind.equals("discouraged") || kind.equals("2") ? 2 : 0));
        return new DefaultAccessRule(kindCode, accessRule.getPattern());
    }

    private static String convertGString(CharSequence original) {
        return original.toString();
    }
}

