/*
 * Decompiled with CFR 0.152.
 */
package org.gradle.api.internal.classpath;

import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.LinkedHashMap;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Map;
import java.util.Properties;
import java.util.Set;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import java.util.zip.ZipEntry;
import java.util.zip.ZipFile;
import javax.annotation.Nullable;
import org.gradle.api.UncheckedIOException;
import org.gradle.api.internal.classpath.EffectiveClassPath;
import org.gradle.api.internal.classpath.Module;
import org.gradle.api.internal.classpath.ModuleRegistry;
import org.gradle.api.internal.classpath.UnknownModuleException;
import org.gradle.internal.classpath.ClassPath;
import org.gradle.internal.classpath.DefaultClassPath;
import org.gradle.internal.installation.GradleInstallation;
import org.gradle.util.GUtil;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class DefaultModuleRegistry
implements ModuleRegistry {
    private final GradleInstallation gradleInstallation;
    private final Map<String, Module> modules = new HashMap<String, Module>();
    private final Map<String, Module> externalModules = new HashMap<String, Module>();
    private final List<File> classpath = new ArrayList<File>();
    private final Map<String, File> classpathJars = new LinkedHashMap<String, File>();
    private static final String[] NO_PROJECTS = new String[0];

    public DefaultModuleRegistry(@Nullable GradleInstallation gradleInstallation) {
        this(ClassPath.EMPTY, gradleInstallation);
    }

    public DefaultModuleRegistry(ClassPath additionalModuleClassPath, @Nullable GradleInstallation gradleInstallation) {
        this(DefaultModuleRegistry.class.getClassLoader(), additionalModuleClassPath, gradleInstallation);
    }

    private DefaultModuleRegistry(ClassLoader classLoader, ClassPath additionalModuleClassPath, @Nullable GradleInstallation gradleInstallation) {
        this.gradleInstallation = gradleInstallation;
        for (File classpathFile : new EffectiveClassPath(classLoader).plus(additionalModuleClassPath).getAsFiles()) {
            this.classpath.add(classpathFile);
            if (!classpathFile.isFile() || this.classpathJars.containsKey(classpathFile.getName())) continue;
            this.classpathJars.put(classpathFile.getName(), classpathFile);
        }
    }

    @Override
    public ClassPath getAdditionalClassPath() {
        return this.gradleInstallation == null ? DefaultClassPath.of(this.classpath) : ClassPath.EMPTY;
    }

    @Override
    public Module getExternalModule(String name) {
        Module module = this.externalModules.get(name);
        if (module == null) {
            module = this.loadExternalModule(name);
            this.externalModules.put(name, module);
        }
        return module;
    }

    private Module loadExternalModule(String name) {
        File externalJar = this.findJar(name);
        if (externalJar == null) {
            throw new UnknownModuleException(String.format("Cannot locate JAR for module '%s' in distribution directory '%s'.", name, this.gradleInstallation.getGradleHome()));
        }
        return new DefaultModule(name, Collections.singleton(externalJar), Collections.<File>emptySet());
    }

    @Override
    public Module getModule(String name) {
        Module module = this.modules.get(name);
        if (module == null) {
            module = this.loadModule(name);
            this.modules.put(name, module);
        }
        return module;
    }

    @Override
    @Nullable
    public Module findModule(String name) {
        Module module = this.modules.get(name);
        if (module == null && (module = this.loadOptionalModule(name)) != null) {
            this.modules.put(name, module);
        }
        return module;
    }

    private Module loadModule(String moduleName) {
        Module module = this.loadOptionalModule(moduleName);
        if (module != null) {
            return module;
        }
        if (this.gradleInstallation == null) {
            throw new UnknownModuleException(String.format("Cannot locate manifest for module '%s' in classpath: %s.", moduleName, this.classpath));
        }
        throw new UnknownModuleException(String.format("Cannot locate JAR for module '%s' in distribution directory '%s'.", moduleName, this.gradleInstallation.getGradleHome()));
    }

    private Module loadOptionalModule(String moduleName) {
        File jarFile = this.findJar(moduleName);
        if (jarFile != null) {
            LinkedHashSet<File> implementationClasspath = new LinkedHashSet<File>();
            implementationClasspath.add(jarFile);
            Properties properties = this.loadModuleProperties(moduleName, jarFile);
            return this.module(moduleName, properties, implementationClasspath);
        }
        String resourceName = moduleName + "-classpath.properties";
        LinkedHashSet<File> implementationClasspath = new LinkedHashSet<File>();
        this.findImplementationClasspath(moduleName, implementationClasspath);
        for (File file : implementationClasspath) {
            File propertiesFile;
            if (!file.isDirectory() || !(propertiesFile = new File(file, resourceName)).isFile()) continue;
            Properties properties = GUtil.loadProperties((File)propertiesFile);
            return this.module(moduleName, properties, implementationClasspath);
        }
        return null;
    }

    private Module module(String moduleName, Properties properties, Set<File> implementationClasspath) {
        String[] runtimeJarNames = this.split(properties.getProperty("runtime"));
        Set<File> runtimeClasspath = this.findDependencyJars(moduleName, runtimeJarNames);
        String[] projects = this.split(properties.getProperty("projects"));
        String[] optionalProjects = this.split(properties.getProperty("optional"));
        return new DefaultModule(moduleName, implementationClasspath, runtimeClasspath, projects, optionalProjects);
    }

    private Set<File> findDependencyJars(String moduleName, String[] jarNames) {
        LinkedHashSet<File> runtimeClasspath = new LinkedHashSet<File>();
        for (String jarName : jarNames) {
            runtimeClasspath.add(this.findDependencyJar(moduleName, jarName));
        }
        return runtimeClasspath;
    }

    private Set<Module> getModules(String[] projectNames) {
        LinkedHashSet<Module> modules = new LinkedHashSet<Module>();
        for (String project : projectNames) {
            modules.add(this.getModule(project));
        }
        return modules;
    }

    private String[] split(String value) {
        if (value == null) {
            return new String[0];
        }
        if ((value = value.trim()).length() == 0) {
            return new String[0];
        }
        return value.split(",");
    }

    private void findImplementationClasspath(String name, Collection<File> implementationClasspath) {
        ArrayList<String> suffixes = new ArrayList<String>();
        Matcher matcher = Pattern.compile("gradle-(.+)").matcher(name);
        matcher.matches();
        String projectDirName = matcher.group(1);
        String projectName = this.toCamelCase(projectDirName);
        suffixes.add(("/out/production/" + projectName).replace('/', File.separatorChar));
        suffixes.add(("/" + projectDirName + "/bin").replace('/', File.separatorChar));
        suffixes.add(("/" + projectDirName + "/src/main/resources").replace('/', File.separatorChar));
        suffixes.add(("/" + projectDirName + "/build/classes/main").replace('/', File.separatorChar));
        suffixes.add(("/" + projectDirName + "/build/resources/main").replace('/', File.separatorChar));
        suffixes.add(("/" + projectDirName + "/build/generated-resources/main").replace('/', File.separatorChar));
        suffixes.add(("/" + projectDirName + "/build/generated-resources/test").replace('/', File.separatorChar));
        for (File file : this.classpath) {
            if (!file.isDirectory()) continue;
            for (String suffix : suffixes) {
                if (!file.getAbsolutePath().endsWith(suffix)) continue;
                implementationClasspath.add(file);
            }
        }
    }

    private String toCamelCase(String name) {
        StringBuffer result = new StringBuffer();
        Matcher matcher = Pattern.compile("-([^-])").matcher(name);
        while (matcher.find()) {
            matcher.appendReplacement(result, "");
            result.append(matcher.group(1).toUpperCase());
        }
        matcher.appendTail(result);
        return result.toString();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private Properties loadModuleProperties(String name, File jarFile) {
        Properties properties;
        ZipFile zipFile = new ZipFile(jarFile);
        try {
            String entryName = name + "-classpath.properties";
            ZipEntry entry = zipFile.getEntry(entryName);
            if (entry == null) {
                throw new IllegalStateException("Did not find " + entryName + " in " + jarFile.getAbsolutePath());
            }
            properties = GUtil.loadProperties((InputStream)zipFile.getInputStream(entry));
        }
        catch (Throwable throwable) {
            try {
                zipFile.close();
                throw throwable;
            }
            catch (IOException e) {
                throw new UncheckedIOException(String.format("Could not load properties for module '%s' from %s", name, jarFile), (Throwable)e);
            }
        }
        zipFile.close();
        return properties;
    }

    private File findJar(String name) {
        Pattern pattern = Pattern.compile(Pattern.quote(name) + "-\\d.+\\.jar");
        if (this.gradleInstallation != null) {
            for (File libDir : this.gradleInstallation.getLibDirs()) {
                for (File file : libDir.listFiles()) {
                    if (!pattern.matcher(file.getName()).matches()) continue;
                    return file;
                }
            }
        }
        for (File file : this.classpath) {
            if (!pattern.matcher(file.getName()).matches()) continue;
            return file;
        }
        return null;
    }

    private File findDependencyJar(String module, String name) {
        File jarFile = this.classpathJars.get(name);
        if (jarFile != null) {
            return jarFile;
        }
        if (this.gradleInstallation == null) {
            throw new IllegalArgumentException(String.format("Cannot find JAR '%s' required by module '%s' using classpath.", name, module));
        }
        for (File libDir : this.gradleInstallation.getLibDirs()) {
            jarFile = new File(libDir, name);
            if (!jarFile.isFile()) continue;
            return jarFile;
        }
        throw new IllegalArgumentException(String.format("Cannot find JAR '%s' required by module '%s' using classpath or distribution directory '%s'", name, module, this.gradleInstallation.getGradleHome()));
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private class DefaultModule
    implements Module {
        private final String name;
        private final String[] projects;
        private final String[] optionalProjects;
        private final ClassPath implementationClasspath;
        private final ClassPath runtimeClasspath;
        private final ClassPath classpath;

        public DefaultModule(String name, Set<File> implementationClasspath, Set<File> runtimeClasspath, String[] projects, String[] optionalProjects) {
            this.name = name;
            this.projects = projects;
            this.optionalProjects = optionalProjects;
            this.implementationClasspath = DefaultClassPath.of(implementationClasspath);
            this.runtimeClasspath = DefaultClassPath.of(runtimeClasspath);
            LinkedHashSet<File> classpath = new LinkedHashSet<File>();
            classpath.addAll(implementationClasspath);
            classpath.addAll(runtimeClasspath);
            this.classpath = DefaultClassPath.of(classpath);
        }

        public DefaultModule(String name, Set<File> singleton, Set<File> files) {
            this(name, singleton, files, NO_PROJECTS, NO_PROJECTS);
        }

        public String toString() {
            return "module '" + this.name + "'";
        }

        @Override
        public Set<Module> getRequiredModules() {
            return DefaultModuleRegistry.this.getModules(this.projects);
        }

        @Override
        public ClassPath getImplementationClasspath() {
            return this.implementationClasspath;
        }

        @Override
        public ClassPath getRuntimeClasspath() {
            return this.runtimeClasspath;
        }

        @Override
        public ClassPath getClasspath() {
            return this.classpath;
        }

        @Override
        public Set<Module> getAllRequiredModules() {
            LinkedHashSet<Module> modules = new LinkedHashSet<Module>();
            this.collectRequiredModules(modules);
            return modules;
        }

        private void collectRequiredModules(Set<Module> modules) {
            if (!modules.add(this)) {
                return;
            }
            for (Module module : this.getRequiredModules()) {
                this.collectDependenciesOf(module, modules);
            }
            for (String optionalProject : this.optionalProjects) {
                Module module = this.findModule(optionalProject);
                if (module == null) continue;
                this.collectDependenciesOf(module, modules);
            }
        }

        private void collectDependenciesOf(Module module, Set<Module> modules) {
            ((DefaultModule)module).collectRequiredModules(modules);
        }

        private Module findModule(String optionalProject) {
            try {
                return DefaultModuleRegistry.this.getModule(optionalProject);
            }
            catch (UnknownModuleException ex) {
                return null;
            }
        }
    }
}

