/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.kotlin.com.intellij.psi.scope.util;

import java.util.ArrayList;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.kotlin.com.intellij.openapi.diagnostic.Logger;
import org.jetbrains.kotlin.com.intellij.openapi.progress.ProgressIndicatorProvider;
import org.jetbrains.kotlin.com.intellij.openapi.util.Comparing;
import org.jetbrains.kotlin.com.intellij.pom.java.LanguageLevel;
import org.jetbrains.kotlin.com.intellij.psi.JavaPsiFacade;
import org.jetbrains.kotlin.com.intellij.psi.JavaResolveResult;
import org.jetbrains.kotlin.com.intellij.psi.JavaTokenType;
import org.jetbrains.kotlin.com.intellij.psi.PsiAnonymousClass;
import org.jetbrains.kotlin.com.intellij.psi.PsiArrayType;
import org.jetbrains.kotlin.com.intellij.psi.PsiCallExpression;
import org.jetbrains.kotlin.com.intellij.psi.PsiCapturedWildcardType;
import org.jetbrains.kotlin.com.intellij.psi.PsiClass;
import org.jetbrains.kotlin.com.intellij.psi.PsiClassType;
import org.jetbrains.kotlin.com.intellij.psi.PsiDisjunctionType;
import org.jetbrains.kotlin.com.intellij.psi.PsiElement;
import org.jetbrains.kotlin.com.intellij.psi.PsiElementFactory;
import org.jetbrains.kotlin.com.intellij.psi.PsiEnumConstant;
import org.jetbrains.kotlin.com.intellij.psi.PsiEnumConstantInitializer;
import org.jetbrains.kotlin.com.intellij.psi.PsiExpression;
import org.jetbrains.kotlin.com.intellij.psi.PsiIdentifier;
import org.jetbrains.kotlin.com.intellij.psi.PsiIntersectionType;
import org.jetbrains.kotlin.com.intellij.psi.PsiInvalidElementAccessException;
import org.jetbrains.kotlin.com.intellij.psi.PsiJavaCodeReferenceElement;
import org.jetbrains.kotlin.com.intellij.psi.PsiKeyword;
import org.jetbrains.kotlin.com.intellij.psi.PsiManager;
import org.jetbrains.kotlin.com.intellij.psi.PsiMethod;
import org.jetbrains.kotlin.com.intellij.psi.PsiMethodCallExpression;
import org.jetbrains.kotlin.com.intellij.psi.PsiModifierList;
import org.jetbrains.kotlin.com.intellij.psi.PsiModifierListOwner;
import org.jetbrains.kotlin.com.intellij.psi.PsiNewExpression;
import org.jetbrains.kotlin.com.intellij.psi.PsiParameter;
import org.jetbrains.kotlin.com.intellij.psi.PsiReferenceExpression;
import org.jetbrains.kotlin.com.intellij.psi.PsiSubstitutor;
import org.jetbrains.kotlin.com.intellij.psi.PsiSuperExpression;
import org.jetbrains.kotlin.com.intellij.psi.PsiType;
import org.jetbrains.kotlin.com.intellij.psi.PsiTypeParameter;
import org.jetbrains.kotlin.com.intellij.psi.PsiVariable;
import org.jetbrains.kotlin.com.intellij.psi.ResolveState;
import org.jetbrains.kotlin.com.intellij.psi.impl.PsiClassImplUtil;
import org.jetbrains.kotlin.com.intellij.psi.impl.source.resolve.JavaResolveUtil;
import org.jetbrains.kotlin.com.intellij.psi.impl.source.resolve.graphInference.InferenceSession;
import org.jetbrains.kotlin.com.intellij.psi.infos.ClassCandidateInfo;
import org.jetbrains.kotlin.com.intellij.psi.scope.JavaScopeProcessorEvent;
import org.jetbrains.kotlin.com.intellij.psi.scope.MethodProcessorSetupFailedException;
import org.jetbrains.kotlin.com.intellij.psi.scope.PsiScopeProcessor;
import org.jetbrains.kotlin.com.intellij.psi.scope.processor.MethodsProcessor;
import org.jetbrains.kotlin.com.intellij.psi.search.GlobalSearchScope;
import org.jetbrains.kotlin.com.intellij.psi.util.PsiUtil;
import org.jetbrains.kotlin.com.intellij.psi.util.TypeConversionUtil;
import org.jetbrains.kotlin.com.intellij.util.IncorrectOperationException;

public class PsiScopesUtil {
    private static final Logger LOG = Logger.getInstance("#com.intellij.psi.scope.util.PsiScopesUtil");

    private PsiScopesUtil() {
    }

    public static boolean treeWalkUp(@NotNull PsiScopeProcessor processor, @NotNull PsiElement entrance, @Nullable PsiElement maxScope) {
        if (processor == null) {
            PsiScopesUtil.$$$reportNull$$$0(0);
        }
        if (entrance == null) {
            PsiScopesUtil.$$$reportNull$$$0(1);
        }
        return PsiScopesUtil.treeWalkUp(processor, entrance, maxScope, ResolveState.initial());
    }

    public static boolean treeWalkUp(@NotNull PsiScopeProcessor processor, @NotNull PsiElement entrance, @Nullable PsiElement maxScope, @NotNull ResolveState state2) {
        if (processor == null) {
            PsiScopesUtil.$$$reportNull$$$0(2);
        }
        if (entrance == null) {
            PsiScopesUtil.$$$reportNull$$$0(3);
        }
        if (state2 == null) {
            PsiScopesUtil.$$$reportNull$$$0(4);
        }
        if (!entrance.isValid()) {
            LOG.error(new PsiInvalidElementAccessException(entrance));
        }
        PsiElement prevParent = entrance;
        PsiElement scope = entrance;
        while (scope != null) {
            PsiModifierList modifierList;
            ProgressIndicatorProvider.checkCanceled();
            if (scope instanceof PsiClass) {
                processor.handleEvent(JavaScopeProcessorEvent.SET_CURRENT_FILE_CONTEXT, scope);
            }
            if (!scope.processDeclarations(processor, state2, prevParent, entrance)) {
                return false;
            }
            if (scope instanceof PsiModifierListOwner && !(scope instanceof PsiParameter) && (modifierList = ((PsiModifierListOwner)scope).getModifierList()) != null && modifierList.hasModifierProperty("static")) {
                processor.handleEvent(JavaScopeProcessorEvent.START_STATIC, null);
            }
            if (scope == maxScope) break;
            prevParent = scope;
            scope = prevParent.getContext();
            processor.handleEvent(JavaScopeProcessorEvent.CHANGE_LEVEL, null);
        }
        return true;
    }

    public static boolean walkChildrenScopes(@NotNull PsiElement thisElement, @NotNull PsiScopeProcessor processor, @NotNull ResolveState state2, PsiElement lastParent, PsiElement place) {
        if (thisElement == null) {
            PsiScopesUtil.$$$reportNull$$$0(5);
        }
        if (processor == null) {
            PsiScopesUtil.$$$reportNull$$$0(6);
        }
        if (state2 == null) {
            PsiScopesUtil.$$$reportNull$$$0(7);
        }
        PsiElement child = null;
        if (lastParent != null && lastParent.getParent() == thisElement && (child = lastParent.getPrevSibling()) == null) {
            return true;
        }
        if (child == null) {
            child = thisElement.getLastChild();
        }
        while (child != null) {
            if (!child.processDeclarations(processor, state2, null, place)) {
                return false;
            }
            child = child.getPrevSibling();
        }
        return true;
    }

    public static void processTypeDeclarations(PsiType type2, PsiElement place, PsiScopeProcessor processor) {
        if (type2 instanceof PsiArrayType) {
            LanguageLevel languageLevel = PsiUtil.getLanguageLevel(place);
            PsiClass arrayClass = JavaPsiFacade.getInstance(place.getProject()).getElementFactory().getArrayClass(languageLevel);
            PsiTypeParameter[] arrayTypeParameters = arrayClass.getTypeParameters();
            PsiSubstitutor substitutor2 = PsiSubstitutor.EMPTY;
            if (arrayTypeParameters.length > 0) {
                substitutor2 = substitutor2.put(arrayTypeParameters[0], ((PsiArrayType)type2).getComponentType());
            }
            arrayClass.processDeclarations(processor, ResolveState.initial().put(PsiSubstitutor.KEY, substitutor2), arrayClass, place);
        } else if (type2 instanceof PsiIntersectionType) {
            for (PsiType psiType : ((PsiIntersectionType)type2).getConjuncts()) {
                PsiScopesUtil.processTypeDeclarations(psiType, place, processor);
            }
        } else if (type2 instanceof PsiDisjunctionType) {
            PsiType lub = ((PsiDisjunctionType)type2).getLeastUpperBound();
            PsiScopesUtil.processTypeDeclarations(lub, place, processor);
        } else if (type2 instanceof PsiCapturedWildcardType) {
            PsiType classType = PsiScopesUtil.convertToTypeParameter((PsiCapturedWildcardType)type2, place);
            if (classType != null) {
                PsiScopesUtil.processTypeDeclarations(classType, place, processor);
            }
        } else {
            PsiClassType.ClassResolveResult result2 = PsiUtil.resolveGenericsClassInType(type2);
            PsiClass clazz = (PsiClass)result2.getElement();
            if (clazz != null) {
                clazz.processDeclarations(processor, ResolveState.initial().put(PsiSubstitutor.KEY, result2.getSubstitutor()), clazz, place);
            }
        }
    }

    public static boolean resolveAndWalk(@NotNull PsiScopeProcessor processor, @NotNull PsiJavaCodeReferenceElement ref, @Nullable PsiElement maxScope) {
        if (processor == null) {
            PsiScopesUtil.$$$reportNull$$$0(8);
        }
        if (ref == null) {
            PsiScopesUtil.$$$reportNull$$$0(9);
        }
        return PsiScopesUtil.resolveAndWalk(processor, ref, maxScope, false);
    }

    public static boolean resolveAndWalk(@NotNull PsiScopeProcessor processor, @NotNull PsiJavaCodeReferenceElement ref, @Nullable PsiElement maxScope, boolean incompleteCode) {
        if (processor == null) {
            PsiScopesUtil.$$$reportNull$$$0(10);
        }
        if (ref == null) {
            PsiScopesUtil.$$$reportNull$$$0(11);
        }
        PsiElement qualifier = ref.getQualifier();
        PsiElement classNameElement = ref.getReferenceNameElement();
        if (classNameElement == null) {
            return true;
        }
        if (qualifier != null) {
            PsiElement target = null;
            PsiSubstitutor substitutor2 = PsiSubstitutor.EMPTY;
            if (qualifier instanceof PsiExpression || qualifier instanceof PsiJavaCodeReferenceElement) {
                PsiType type2 = null;
                if (qualifier instanceof PsiExpression) {
                    type2 = ((PsiExpression)qualifier).getType();
                    if (type2 != null) assert (type2.isValid()) : type2.getClass() + "; " + qualifier;
                    PsiScopesUtil.processTypeDeclarations(type2, ref, processor);
                }
                if (type2 == null && qualifier instanceof PsiJavaCodeReferenceElement) {
                    PsiJavaCodeReferenceElement referenceElement = (PsiJavaCodeReferenceElement)qualifier;
                    JavaResolveResult result2 = referenceElement.advancedResolve(incompleteCode);
                    target = result2.getElement();
                    substitutor2 = result2.getSubstitutor();
                    if (target instanceof PsiVariable) {
                        type2 = substitutor2.substitute(((PsiVariable)target).getType());
                        if (type2 instanceof PsiClassType) {
                            PsiClassType.ClassResolveResult typeResult = ((PsiClassType)type2).resolveGenerics();
                            target = typeResult.getElement();
                            substitutor2 = substitutor2.putAll(typeResult.getSubstitutor());
                        } else {
                            target = null;
                        }
                    } else if (target instanceof PsiMethod) {
                        type2 = substitutor2.substitute(((PsiMethod)target).getReturnType());
                        if (type2 instanceof PsiClassType) {
                            PsiClassType.ClassResolveResult typeResult = ((PsiClassType)type2).resolveGenerics();
                            target = typeResult.getElement();
                            substitutor2 = substitutor2.putAll(typeResult.getSubstitutor());
                        } else {
                            target = null;
                        }
                        PsiType[] types = referenceElement.getTypeParameters();
                        if (target instanceof PsiClass) {
                            substitutor2 = substitutor2.putAll((PsiClass)target, types);
                        }
                    } else if (target instanceof PsiClass) {
                        processor.handleEvent(JavaScopeProcessorEvent.START_STATIC, null);
                    }
                }
            }
            if (target != null) {
                return target.processDeclarations(processor, ResolveState.initial().put(PsiSubstitutor.KEY, substitutor2), target, ref);
            }
        } else {
            return PsiScopesUtil.treeWalkUp(processor, ref, maxScope);
        }
        return true;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public static void setupAndRunProcessor(@NotNull MethodsProcessor processor, @NotNull PsiCallExpression call2, boolean dummyImplicitConstructor) throws MethodProcessorSetupFailedException {
        if (processor == null) {
            PsiScopesUtil.$$$reportNull$$$0(12);
        }
        if (call2 == null) {
            PsiScopesUtil.$$$reportNull$$$0(13);
        }
        if (call2 instanceof PsiMethodCallExpression) {
            PsiMethodCallExpression methodCall = (PsiMethodCallExpression)call2;
            PsiReferenceExpression ref = methodCall.getMethodExpression();
            processor.setArgumentList(methodCall.getArgumentList());
            processor.obtainTypeArguments(methodCall);
            if (!ref.isQualified() || ref.getReferenceNameElement() instanceof PsiKeyword) {
                PsiElement referenceNameElement = ref.getReferenceNameElement();
                if (referenceNameElement == null) {
                    return;
                }
                if (referenceNameElement instanceof PsiKeyword) {
                    PsiKeyword keyword = (PsiKeyword)referenceNameElement;
                    if (keyword.getTokenType() == JavaTokenType.THIS_KEYWORD) {
                        PsiClass aClass2 = JavaResolveUtil.getContextClass(methodCall);
                        if (aClass2 == null) {
                            throw new MethodProcessorSetupFailedException("Can't resolve class for this expression");
                        }
                        processor.setIsConstructor(true);
                        processor.setAccessClass(aClass2);
                        aClass2.processDeclarations(processor, ResolveState.initial(), null, call2);
                        if (!dummyImplicitConstructor) return;
                        PsiScopesUtil.processDummyConstructor(processor, aClass2);
                        return;
                    } else if (keyword.getTokenType() == JavaTokenType.SUPER_KEYWORD) {
                        PsiClass aClass3 = JavaResolveUtil.getContextClass(methodCall);
                        if (aClass3 == null) {
                            throw new MethodProcessorSetupFailedException("Can't resolve class for super expression");
                        }
                        PsiClass superClass = aClass3.getSuperClass();
                        if (superClass == null) return;
                        PsiSubstitutor substitutor2 = PsiSubstitutor.EMPTY;
                        PsiClass runSuper = superClass;
                        ArrayList<PsiSubstitutor> contextSubstitutors = new ArrayList<PsiSubstitutor>();
                        do {
                            if (runSuper != null) {
                                PsiSubstitutor superSubstitutor = TypeConversionUtil.getSuperClassSubstitutor(runSuper, aClass3, PsiSubstitutor.EMPTY);
                                contextSubstitutors.add(superSubstitutor);
                            }
                            if (aClass3.hasModifierProperty("static")) break;
                            if ((aClass3 = JavaResolveUtil.getContextClass(aClass3)) == null) continue;
                            runSuper = aClass3.getSuperClass();
                        } while (aClass3 != null);
                        for (int i = contextSubstitutors.size() - 1; i >= 0; --i) {
                            PsiSubstitutor contextSubstitutor = (PsiSubstitutor)contextSubstitutors.get(i);
                            substitutor2 = substitutor2.putAll(contextSubstitutor);
                        }
                        processor.setIsConstructor(true);
                        processor.setAccessClass(null);
                        PsiMethod[] constructors2 = superClass.getConstructors();
                        ResolveState state2 = ResolveState.initial().put(PsiSubstitutor.KEY, substitutor2);
                        for (PsiMethod constructor : constructors2) {
                            if (processor.execute(constructor, state2)) continue;
                            return;
                        }
                        if (!dummyImplicitConstructor) return;
                        PsiScopesUtil.processDummyConstructor(processor, superClass);
                        return;
                    } else {
                        LOG.error("Unknown name element " + referenceNameElement + " in reference " + ref.getText() + "(" + ref + ")");
                    }
                    return;
                } else if (referenceNameElement instanceof PsiIdentifier) {
                    processor.setIsConstructor(false);
                    processor.setName(referenceNameElement.getText());
                    processor.setAccessClass(null);
                    PsiScopesUtil.resolveAndWalk(processor, ref, null);
                    return;
                } else {
                    LOG.error("Unknown name element " + referenceNameElement + " in reference " + ref.getText() + "(" + ref + ")");
                }
                return;
            } else {
                PsiElement referenceName = methodCall.getMethodExpression().getReferenceNameElement();
                PsiManager manager = call2.getManager();
                PsiElement qualifier = ref.getQualifier();
                if (referenceName == null) {
                    throw new MethodProcessorSetupFailedException("Can't resolve method name for this expression");
                }
                if (referenceName instanceof PsiIdentifier && qualifier instanceof PsiExpression) {
                    PsiType type2 = ((PsiExpression)qualifier).getType();
                    if (type2 != null && qualifier instanceof PsiReferenceExpression) {
                        PsiAnonymousClass anonymousClass;
                        PsiExpression initializer2;
                        PsiElement resolve2 = ((PsiReferenceExpression)qualifier).resolve();
                        if (resolve2 instanceof PsiEnumConstant) {
                            PsiEnumConstantInitializer initializingClass2 = ((PsiEnumConstant)resolve2).getInitializingClass();
                            if (PsiScopesUtil.hasDesiredMethod(methodCall, type2, initializingClass2)) {
                                PsiScopesUtil.processQualifierResult(new ClassCandidateInfo(initializingClass2, PsiSubstitutor.EMPTY), processor, methodCall);
                                return;
                            }
                        } else if (resolve2 instanceof PsiVariable && ((PsiVariable)resolve2).hasModifierProperty("final") && ((PsiVariable)resolve2).hasInitializer() && (initializer2 = ((PsiVariable)resolve2).getInitializer()) instanceof PsiNewExpression && PsiScopesUtil.hasDesiredMethod(methodCall, type2, anonymousClass = ((PsiNewExpression)initializer2).getAnonymousClass())) {
                            type2 = initializer2.getType();
                        }
                    }
                    if (type2 == null) {
                        if (!(qualifier instanceof PsiJavaCodeReferenceElement)) throw new MethodProcessorSetupFailedException("Cant determine qualifier type!");
                        JavaResolveResult result2 = ((PsiJavaCodeReferenceElement)qualifier).advancedResolve(false);
                        if (!(result2.getElement() instanceof PsiClass)) return;
                        processor.handleEvent(JavaScopeProcessorEvent.START_STATIC, null);
                        PsiScopesUtil.processQualifierResult(result2, processor, methodCall);
                        return;
                    } else if (type2 instanceof PsiDisjunctionType) {
                        PsiScopesUtil.processQualifierType(((PsiDisjunctionType)type2).getLeastUpperBound(), processor, manager, methodCall);
                        return;
                    } else if (type2 instanceof PsiCapturedWildcardType) {
                        PsiType psiType = PsiScopesUtil.convertToTypeParameter((PsiCapturedWildcardType)type2, methodCall);
                        if (psiType == null) return;
                        PsiScopesUtil.processQualifierType(psiType, processor, manager, methodCall);
                        return;
                    } else {
                        PsiScopesUtil.processQualifierType(type2, processor, manager, methodCall);
                    }
                    return;
                } else {
                    LOG.error("ref: " + ref + " (" + ref.getClass() + "), ref.getReferenceNameElement()=" + ref.getReferenceNameElement() + "; methodCall.getMethodExpression().getReferenceNameElement()=" + methodCall.getMethodExpression().getReferenceNameElement() + "; qualifier=" + qualifier);
                }
            }
            return;
        } else {
            LOG.assertTrue(call2 instanceof PsiNewExpression);
            PsiNewExpression newExpr = (PsiNewExpression)call2;
            PsiJavaCodeReferenceElement classRef = newExpr.getClassOrAnonymousClassReference();
            if (classRef == null) {
                throw new MethodProcessorSetupFailedException("Cant get reference to class in new expression");
            }
            JavaResolveResult result3 = classRef.advancedResolve(false);
            PsiClass aClass4 = (PsiClass)result3.getElement();
            if (aClass4 == null) {
                throw new MethodProcessorSetupFailedException("Cant resolve class in new expression");
            }
            processor.setIsConstructor(true);
            processor.setAccessClass(aClass4);
            processor.setArgumentList(newExpr.getArgumentList());
            processor.obtainTypeArguments(newExpr);
            aClass4.processDeclarations(processor, ResolveState.initial().put(PsiSubstitutor.KEY, result3.getSubstitutor()), null, call2);
            if (!dummyImplicitConstructor) return;
            PsiScopesUtil.processDummyConstructor(processor, aClass4);
        }
    }

    private static PsiType convertToTypeParameter(PsiCapturedWildcardType type2, PsiElement methodCall) {
        GlobalSearchScope placeResolveScope = methodCall.getResolveScope();
        PsiType upperBound = PsiClassImplUtil.correctType(type2.getUpperBound(), placeResolveScope);
        while (upperBound instanceof PsiCapturedWildcardType) {
            upperBound = PsiClassImplUtil.correctType(((PsiCapturedWildcardType)upperBound).getUpperBound(), placeResolveScope);
        }
        if (upperBound instanceof PsiArrayType) {
            return upperBound;
        }
        if (upperBound != null) {
            return InferenceSession.createTypeParameterTypeWithUpperBound(upperBound, methodCall);
        }
        return null;
    }

    private static boolean hasDesiredMethod(PsiMethodCallExpression methodCall, PsiType type2, PsiAnonymousClass anonymousClass) {
        PsiClass baseClass;
        PsiMethod[] refMethods;
        if (anonymousClass != null && type2.equals(anonymousClass.getBaseClassType()) && (refMethods = anonymousClass.findMethodsByName(methodCall.getMethodExpression().getReferenceName(), false)).length > 0 && (baseClass = PsiUtil.resolveClassInType(type2)) != null && !PsiScopesUtil.hasCovariantOverridingOrNotPublic(baseClass, refMethods)) {
            for (PsiMethod method : refMethods) {
                if (method.findSuperMethods(baseClass).length <= 0) continue;
                return true;
            }
        }
        return false;
    }

    private static boolean hasCovariantOverridingOrNotPublic(PsiClass baseClass, PsiMethod[] refMethods) {
        for (PsiMethod method : refMethods) {
            PsiType methodReturnType = method.getReturnType();
            for (PsiMethod superMethod : method.findSuperMethods(baseClass)) {
                if (!Comparing.equal(methodReturnType, superMethod.getReturnType())) {
                    return true;
                }
                if (superMethod.hasModifierProperty("public")) continue;
                return true;
            }
        }
        return false;
    }

    private static boolean processQualifierType(@NotNull PsiType type2, MethodsProcessor processor, PsiManager manager, PsiMethodCallExpression call2) throws MethodProcessorSetupFailedException {
        if (type2 == null) {
            PsiScopesUtil.$$$reportNull$$$0(14);
        }
        LOG.assertTrue(type2.isValid());
        if (type2 instanceof PsiClassType) {
            PsiClassType.ClassResolveResult qualifierResult = ((PsiClassType)type2).resolveGenerics();
            return PsiScopesUtil.processQualifierResult(qualifierResult, processor, call2);
        }
        if (type2 instanceof PsiArrayType) {
            LanguageLevel languageLevel = PsiUtil.getLanguageLevel(call2);
            PsiElementFactory factory2 = JavaPsiFacade.getInstance(manager.getProject()).getElementFactory();
            PsiClassType.ClassResolveResult qualifierResult = factory2.getArrayClassType(((PsiArrayType)type2).getComponentType(), languageLevel).resolveGenerics();
            return PsiScopesUtil.processQualifierResult(qualifierResult, processor, call2);
        }
        if (type2 instanceof PsiIntersectionType) {
            for (PsiType conjunct : ((PsiIntersectionType)type2).getConjuncts()) {
                if (PsiScopesUtil.processQualifierType(conjunct, processor, manager, call2)) continue;
                return false;
            }
        }
        return true;
    }

    private static boolean processQualifierResult(@NotNull JavaResolveResult qualifierResult, @NotNull MethodsProcessor processor, @NotNull PsiMethodCallExpression methodCall) throws MethodProcessorSetupFailedException {
        PsiElement resolve2;
        if (qualifierResult == null) {
            PsiScopesUtil.$$$reportNull$$$0(15);
        }
        if (processor == null) {
            PsiScopesUtil.$$$reportNull$$$0(16);
        }
        if (methodCall == null) {
            PsiScopesUtil.$$$reportNull$$$0(17);
        }
        if ((resolve2 = qualifierResult.getElement()) == null) {
            throw new MethodProcessorSetupFailedException("Cant determine qualifier class!");
        }
        if (resolve2 instanceof PsiTypeParameter) {
            processor.setAccessClass((PsiClass)resolve2);
        } else if (resolve2 instanceof PsiClass) {
            PsiExpression qualifier = methodCall.getMethodExpression().getQualifierExpression();
            if (!(qualifier instanceof PsiSuperExpression)) {
                processor.setAccessClass((PsiClass)PsiUtil.getAccessObjectClass(qualifier).getElement());
            } else if (((PsiSuperExpression)qualifier).getQualifier() != null && PsiUtil.isLanguageLevel8OrHigher(qualifier) && "java.lang.Cloneable".equals(((PsiClass)resolve2).getQualifiedName()) && ((PsiClass)resolve2).isInterface()) {
                processor.setAccessClass((PsiClass)resolve2);
            }
        }
        processor.setIsConstructor(false);
        processor.setName(methodCall.getMethodExpression().getReferenceName());
        ResolveState state2 = ResolveState.initial().put(PsiSubstitutor.KEY, qualifierResult.getSubstitutor());
        return resolve2.processDeclarations(processor, state2, methodCall, methodCall);
    }

    private static void processDummyConstructor(MethodsProcessor processor, PsiClass aClass2) {
        if (aClass2 instanceof PsiAnonymousClass) {
            return;
        }
        try {
            PsiMethod[] constructors2 = aClass2.getConstructors();
            if (constructors2.length != 0) {
                return;
            }
            PsiElementFactory factory2 = JavaPsiFacade.getInstance(aClass2.getProject()).getElementFactory();
            PsiMethod dummyConstructor = factory2.createConstructor();
            PsiIdentifier nameIdentifier = aClass2.getNameIdentifier();
            if (nameIdentifier != null) {
                dummyConstructor.getNameIdentifier().replace(nameIdentifier);
            }
            processor.forceAddResult(dummyConstructor);
        }
        catch (IncorrectOperationException e) {
            LOG.error(e);
        }
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[3];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "processor";
                break;
            }
            case 1: 
            case 3: {
                objectArray2 = objectArray3;
                objectArray3[0] = "entrance";
                break;
            }
            case 4: 
            case 7: {
                objectArray2 = objectArray3;
                objectArray3[0] = "state";
                break;
            }
            case 5: {
                objectArray2 = objectArray3;
                objectArray3[0] = "thisElement";
                break;
            }
            case 9: 
            case 11: {
                objectArray2 = objectArray3;
                objectArray3[0] = "ref";
                break;
            }
            case 13: {
                objectArray2 = objectArray3;
                objectArray3[0] = "call";
                break;
            }
            case 14: {
                objectArray2 = objectArray3;
                objectArray3[0] = "type";
                break;
            }
            case 15: {
                objectArray2 = objectArray3;
                objectArray3[0] = "qualifierResult";
                break;
            }
            case 17: {
                objectArray2 = objectArray3;
                objectArray3[0] = "methodCall";
                break;
            }
        }
        objectArray2[1] = "org/jetbrains/kotlin/com/intellij/psi/scope/util/PsiScopesUtil";
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[2] = "treeWalkUp";
                break;
            }
            case 5: 
            case 6: 
            case 7: {
                objectArray = objectArray2;
                objectArray2[2] = "walkChildrenScopes";
                break;
            }
            case 8: 
            case 9: 
            case 10: 
            case 11: {
                objectArray = objectArray2;
                objectArray2[2] = "resolveAndWalk";
                break;
            }
            case 12: 
            case 13: {
                objectArray = objectArray2;
                objectArray2[2] = "setupAndRunProcessor";
                break;
            }
            case 14: {
                objectArray = objectArray2;
                objectArray2[2] = "processQualifierType";
                break;
            }
            case 15: 
            case 16: 
            case 17: {
                objectArray = objectArray2;
                objectArray2[2] = "processQualifierResult";
                break;
            }
        }
        throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
    }
}

