/*
 * Decompiled with CFR 0.152.
 */
package org.gradle.api.internal.artifacts.dependencies;

import com.google.common.base.Strings;
import com.google.common.collect.Lists;
import java.util.Collections;
import java.util.List;
import javax.annotation.Nullable;
import org.gradle.api.InvalidUserDataException;
import org.gradle.api.artifacts.VersionConstraint;
import org.gradle.api.internal.artifacts.ImmutableVersionConstraint;
import org.gradle.api.internal.artifacts.VersionConstraintInternal;
import org.gradle.api.internal.artifacts.dependencies.AbstractVersionConstraint;
import org.gradle.api.internal.artifacts.dependencies.DefaultImmutableVersionConstraint;
import org.gradle.api.internal.artifacts.ivyservice.ivyresolve.strategy.DefaultVersionComparator;
import org.gradle.api.internal.artifacts.ivyservice.ivyresolve.strategy.DefaultVersionSelectorScheme;
import org.gradle.api.internal.artifacts.ivyservice.ivyresolve.strategy.VersionSelector;

public class DefaultMutableVersionConstraint
extends AbstractVersionConstraint
implements VersionConstraintInternal {
    private String prefer;
    private String branch;
    private final List<String> rejects = Lists.newArrayListWithExpectedSize((int)1);

    public DefaultMutableVersionConstraint(VersionConstraint versionConstraint) {
        this(versionConstraint.getPreferredVersion(), versionConstraint.getRejectedVersions());
    }

    public DefaultMutableVersionConstraint(String version, boolean strict) {
        this.prefer = Strings.nullToEmpty((String)version);
        if (strict) {
            this.doStrict();
        }
    }

    public DefaultMutableVersionConstraint(String version, List<String> rejects) {
        this.prefer = Strings.nullToEmpty((String)version);
        this.rejects.addAll(rejects);
    }

    private void doStrict() {
        DefaultVersionSelectorScheme versionSelectorScheme = new DefaultVersionSelectorScheme(new DefaultVersionComparator());
        VersionSelector preferredSelector = versionSelectorScheme.parseSelector(this.prefer);
        VersionSelector rejectedSelector = versionSelectorScheme.complementForRejection(preferredSelector);
        this.rejects.clear();
        this.rejects.add(rejectedSelector.getSelector());
    }

    public DefaultMutableVersionConstraint(String version) {
        this(version, false);
    }

    @Override
    public ImmutableVersionConstraint asImmutable() {
        String v = this.prefer == null ? "" : this.prefer;
        return new DefaultImmutableVersionConstraint(v, this.rejects, this.branch);
    }

    @Nullable
    public String getBranch() {
        return this.branch;
    }

    public void setBranch(String branch) {
        this.branch = branch;
    }

    public String getPreferredVersion() {
        return this.prefer;
    }

    public void prefer(String version) {
        this.prefer = Strings.nullToEmpty((String)version);
        this.rejects.clear();
    }

    public void strictly(String version) {
        this.prefer(version);
        this.doStrict();
    }

    public void reject(String ... versions) {
        if (versions.length == 0) {
            throw new InvalidUserDataException("The 'reject' clause requires at least one rejected version");
        }
        Collections.addAll(this.rejects, versions);
    }

    public void rejectAll() {
        this.prefer = "";
        this.rejects.clear();
        this.rejects.add("+");
    }

    public List<String> getRejectedVersions() {
        return this.rejects;
    }
}

