/*
 * Decompiled with CFR 0.152.
 */
package org.gradle.api.internal.tasks.testing.junit;

import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import org.gradle.api.internal.tasks.testing.TestCompleteEvent;
import org.gradle.api.internal.tasks.testing.TestDescriptorInternal;
import org.gradle.api.internal.tasks.testing.TestResultProcessor;
import org.gradle.api.internal.tasks.testing.TestStartEvent;
import org.gradle.api.tasks.testing.TestResult;
import org.gradle.internal.concurrent.ThreadSafe;
import org.gradle.internal.time.Clock;

public class GenericJUnitTestEventAdapter<T> {
    private final TestResultProcessor resultProcessor;
    private final Clock clock;
    private final Object lock = new Object();
    private final Map<T, TestDescriptorInternal> executing = new HashMap<T, TestDescriptorInternal>();
    private final Set<T> assumptionFailed = new HashSet<T>();

    public GenericJUnitTestEventAdapter(TestResultProcessor resultProcessor, Clock clock) {
        assert (resultProcessor instanceof ThreadSafe);
        this.resultProcessor = resultProcessor;
        this.clock = clock;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void testStarted(T identifier, TestDescriptorInternal descriptor) {
        Object object = this.lock;
        synchronized (object) {
            TestDescriptorInternal oldTest = this.executing.put(identifier, descriptor);
            assert (oldTest == null) : String.format("Unexpected start event for %s", identifier);
        }
        this.resultProcessor.started(descriptor, this.startEvent());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void testFailure(T identifier, TestDescriptorInternal descriptor, Throwable exception) {
        TestDescriptorInternal testInternal;
        Object object = this.lock;
        synchronized (object) {
            testInternal = this.executing.get(identifier);
        }
        boolean needEndEvent = false;
        if (testInternal == null) {
            needEndEvent = true;
            testInternal = descriptor;
            this.resultProcessor.started(testInternal, this.startEvent());
        }
        this.resultProcessor.failure(testInternal.getId(), exception);
        if (needEndEvent) {
            this.resultProcessor.completed(testInternal.getId(), new TestCompleteEvent(this.clock.getCurrentTime()));
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void testAssumptionFailure(T identifier) {
        Object object = this.lock;
        synchronized (object) {
            this.assumptionFailed.add(identifier);
        }
    }

    public void testIgnored(TestDescriptorInternal descriptor) {
        this.resultProcessor.started(descriptor, this.startEvent());
        this.resultProcessor.completed(descriptor.getId(), new TestCompleteEvent(this.clock.getCurrentTime(), TestResult.ResultType.SKIPPED));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void testFinished(T identifier) {
        TestResult.ResultType resultType;
        TestDescriptorInternal testInternal;
        long endTime = this.clock.getCurrentTime();
        Object object = this.lock;
        synchronized (object) {
            testInternal = this.executing.remove(identifier);
            if (testInternal == null && this.executing.size() == 1) {
                testInternal = this.executing.values().iterator().next();
                this.executing.clear();
            }
            assert (testInternal != null) : String.format("Unexpected end event for %s", identifier);
            resultType = this.assumptionFailed.remove(identifier) ? TestResult.ResultType.SKIPPED : null;
        }
        this.resultProcessor.completed(testInternal.getId(), new TestCompleteEvent(endTime, resultType));
    }

    private TestStartEvent startEvent() {
        return new TestStartEvent(this.clock.getCurrentTime());
    }
}

