/*
 * Decompiled with CFR 0.152.
 */
package org.gradle.composite.internal;

import org.gradle.api.Action;
import org.gradle.api.initialization.IncludedBuild;
import org.gradle.api.internal.artifacts.ImmutableModuleIdentifierFactory;
import org.gradle.api.internal.artifacts.ivyservice.dependencysubstitution.DefaultDependencySubstitutions;
import org.gradle.api.internal.artifacts.ivyservice.dependencysubstitution.DependencySubstitutionsInternal;
import org.gradle.api.internal.composite.CompositeBuildContext;
import org.gradle.composite.internal.IncludedBuildInternal;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class IncludedBuildDependencySubstitutionsBuilder {
    private static final Logger LOGGER = LoggerFactory.getLogger(IncludedBuildDependencySubstitutionsBuilder.class);
    private final CompositeBuildContext context;
    private final ImmutableModuleIdentifierFactory moduleIdentifierFactory;

    public IncludedBuildDependencySubstitutionsBuilder(CompositeBuildContext context, ImmutableModuleIdentifierFactory moduleIdentifierFactory) {
        this.context = context;
        this.moduleIdentifierFactory = moduleIdentifierFactory;
    }

    public void build(IncludedBuildInternal build) {
        DependencySubstitutionsInternal substitutions = this.resolveDependencySubstitutions(build);
        if (!substitutions.hasRules()) {
            LOGGER.info("[composite-build] Configuring build: " + build.getModel().getProjectDir());
            this.context.addAvailableModules(build.getAvailableModules());
        } else {
            this.context.registerSubstitution(substitutions.getRuleAction());
        }
    }

    private DependencySubstitutionsInternal resolveDependencySubstitutions(IncludedBuildInternal build) {
        DefaultDependencySubstitutions dependencySubstitutions = DefaultDependencySubstitutions.forIncludedBuild((IncludedBuild)build.getModel(), (ImmutableModuleIdentifierFactory)this.moduleIdentifierFactory);
        for (Action action : build.getRegisteredDependencySubstitutions()) {
            action.execute((Object)dependencySubstitutions);
        }
        return dependencySubstitutions;
    }
}

