/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.kotlin.com.intellij.psi.impl.source;

import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.kotlin.com.intellij.lang.ASTNode;
import org.jetbrains.kotlin.com.intellij.psi.JavaElementVisitor;
import org.jetbrains.kotlin.com.intellij.psi.PsiClass;
import org.jetbrains.kotlin.com.intellij.psi.PsiElement;
import org.jetbrains.kotlin.com.intellij.psi.PsiElementVisitor;
import org.jetbrains.kotlin.com.intellij.psi.PsiImportStaticReferenceElement;
import org.jetbrains.kotlin.com.intellij.psi.PsiImportStaticStatement;
import org.jetbrains.kotlin.com.intellij.psi.PsiJavaCodeReferenceElement;
import org.jetbrains.kotlin.com.intellij.psi.impl.java.stubs.JavaStubElementTypes;
import org.jetbrains.kotlin.com.intellij.psi.impl.java.stubs.PsiImportStatementStub;
import org.jetbrains.kotlin.com.intellij.psi.impl.source.PsiImportStatementBaseImpl;
import org.jetbrains.kotlin.com.intellij.psi.stubs.IStubElementType;
import org.jetbrains.kotlin.com.intellij.util.ArrayFactory;

public class PsiImportStaticStatementImpl
extends PsiImportStatementBaseImpl
implements PsiImportStaticStatement {
    public static final PsiImportStaticStatementImpl[] EMPTY_ARRAY = new PsiImportStaticStatementImpl[0];
    public static final ArrayFactory<PsiImportStaticStatementImpl> ARRAY_FACTORY = count -> count == 0 ? EMPTY_ARRAY : new PsiImportStaticStatementImpl[count];

    public PsiImportStaticStatementImpl(PsiImportStatementStub stub) {
        super(stub, (IStubElementType)JavaStubElementTypes.IMPORT_STATIC_STATEMENT);
    }

    public PsiImportStaticStatementImpl(ASTNode node) {
        super(node);
    }

    @Override
    public PsiClass resolveTargetClass() {
        PsiJavaCodeReferenceElement classReference = this.getClassReference();
        if (classReference == null) {
            return null;
        }
        PsiElement result2 = classReference.resolve();
        if (result2 instanceof PsiClass) {
            return (PsiClass)result2;
        }
        return null;
    }

    @Override
    public String getReferenceName() {
        if (this.isOnDemand()) {
            return null;
        }
        PsiImportStaticReferenceElement memberReference = this.getMemberReference();
        if (memberReference != null) {
            return memberReference.getReferenceName();
        }
        return null;
    }

    @Nullable
    private PsiImportStaticReferenceElement getMemberReference() {
        if (this.isOnDemand()) {
            return null;
        }
        return (PsiImportStaticReferenceElement)this.getImportReference();
    }

    @Nullable
    public PsiJavaCodeReferenceElement getClassReference() {
        if (this.isOnDemand()) {
            return this.getImportReference();
        }
        PsiImportStaticReferenceElement memberReference = this.getMemberReference();
        if (memberReference != null) {
            return memberReference.getClassReference();
        }
        return null;
    }

    @Override
    public void accept(@NotNull PsiElementVisitor visitor2) {
        if (visitor2 == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "visitor", "org/jetbrains/kotlin/com/intellij/psi/impl/source/PsiImportStaticStatementImpl", "accept"));
        }
        if (visitor2 instanceof JavaElementVisitor) {
            ((JavaElementVisitor)visitor2).visitImportStaticStatement(this);
        } else {
            visitor2.visitElement(this);
        }
    }

    @Override
    public String toString() {
        return "PsiImportStaticStatement";
    }
}

