/*
 * Decompiled with CFR 0.152.
 */
package org.gradle.internal.buildevents;

import java.util.HashMap;
import java.util.Map;
import org.gradle.api.Project;
import org.gradle.api.ProjectEvaluationListener;
import org.gradle.api.ProjectState;
import org.gradle.internal.logging.progress.ProgressLogger;
import org.gradle.internal.logging.progress.ProgressLoggerFactory;

public class ProjectEvaluationLogger
implements ProjectEvaluationListener {
    private final Map<String, ProgressLogger> currentProjects = new HashMap<String, ProgressLogger>();
    private final ProgressLoggerFactory progressLoggerFactory;

    public ProjectEvaluationLogger(ProgressLoggerFactory progressLoggerFactory) {
        this.progressLoggerFactory = progressLoggerFactory;
    }

    public void beforeEvaluate(Project project) {
        String projectPath = project.getPath().equals(":") ? "root project" : project.getPath();
        ProgressLogger currentTask = this.progressLoggerFactory.newOperation(ProjectEvaluationLogger.class).start("Configuring ".concat(projectPath), projectPath);
        this.currentProjects.put(project.getPath(), currentTask);
    }

    public void afterEvaluate(Project project, ProjectState state) {
        ProgressLogger logger = this.currentProjects.remove(project.getPath());
        if (logger != null) {
            logger.completed();
        }
    }
}

