/*
 * Decompiled with CFR 0.152.
 */
package org.gradle.internal.component.external.model;

import com.google.common.collect.Lists;
import java.io.File;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.LinkedHashMap;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.gradle.api.Transformer;
import org.gradle.api.artifacts.PublishArtifact;
import org.gradle.api.artifacts.VersionConstraint;
import org.gradle.api.artifacts.component.ComponentSelector;
import org.gradle.api.artifacts.component.ModuleComponentIdentifier;
import org.gradle.api.artifacts.component.ModuleComponentSelector;
import org.gradle.api.internal.artifacts.configurations.OutgoingVariant;
import org.gradle.api.internal.artifacts.dependencies.DefaultImmutableVersionConstraint;
import org.gradle.api.internal.attributes.ImmutableAttributes;
import org.gradle.internal.component.external.descriptor.Configuration;
import org.gradle.internal.component.external.model.BuildableIvyModulePublishMetadata;
import org.gradle.internal.component.external.model.DefaultIvyModuleArtifactPublishMetadata;
import org.gradle.internal.component.external.model.DefaultModuleComponentSelector;
import org.gradle.internal.component.external.model.IvyModuleArtifactPublishMetadata;
import org.gradle.internal.component.external.model.IvyModulePublishMetadata;
import org.gradle.internal.component.external.model.ModuleComponentArtifactIdentifier;
import org.gradle.internal.component.local.model.BuildableLocalComponentMetadata;
import org.gradle.internal.component.local.model.LocalFileDependencyMetadata;
import org.gradle.internal.component.model.DefaultIvyArtifactName;
import org.gradle.internal.component.model.Exclude;
import org.gradle.internal.component.model.IvyArtifactName;
import org.gradle.internal.component.model.LocalOriginDependencyMetadata;
import org.gradle.util.CollectionUtils;

public class DefaultIvyModulePublishMetadata
implements BuildableIvyModulePublishMetadata,
BuildableLocalComponentMetadata {
    private static final Transformer<String, String> VERSION_TRANSFORMER = new IvyVersionTransformer();
    private final ModuleComponentIdentifier id;
    private final String status;
    private final Map<ModuleComponentArtifactIdentifier, IvyModuleArtifactPublishMetadata> artifactsById = new LinkedHashMap<ModuleComponentArtifactIdentifier, IvyModuleArtifactPublishMetadata>();
    private final Map<String, Configuration> configurations = new LinkedHashMap<String, Configuration>();
    private final Set<LocalOriginDependencyMetadata> dependencies = new LinkedHashSet<LocalOriginDependencyMetadata>();
    private final List<Exclude> excludes = new ArrayList<Exclude>();

    public DefaultIvyModulePublishMetadata(ModuleComponentIdentifier id, String status) {
        this.id = id;
        this.status = status;
    }

    public DefaultIvyModulePublishMetadata(IvyModulePublishMetadata metadata) {
        this.id = metadata.getId();
        this.status = metadata.getStatus();
    }

    @Override
    public ModuleComponentIdentifier getId() {
        return this.id;
    }

    @Override
    public String getStatus() {
        return this.status;
    }

    @Override
    public Map<String, Configuration> getConfigurations() {
        return this.configurations;
    }

    @Override
    public Collection<LocalOriginDependencyMetadata> getDependencies() {
        return this.dependencies;
    }

    @Override
    public Collection<Exclude> getExcludes() {
        return this.excludes;
    }

    @Override
    public void addConfiguration(String name, String description, Set<String> extendsFrom, Set<String> hierarchy, boolean visible, boolean transitive, ImmutableAttributes attributes, boolean canBeConsumed, boolean canBeResolved) {
        ArrayList sortedExtends = Lists.newArrayList(extendsFrom);
        Collections.sort(sortedExtends);
        Configuration configuration = new Configuration(name, transitive, visible, sortedExtends);
        this.configurations.put(name, configuration);
    }

    @Override
    public void addExclude(Exclude exclude) {
        this.excludes.add(exclude);
    }

    @Override
    public void addDependency(LocalOriginDependencyMetadata dependency) {
        this.dependencies.add(DefaultIvyModulePublishMetadata.normalizeVersionForIvy(dependency));
    }

    private static LocalOriginDependencyMetadata normalizeVersionForIvy(LocalOriginDependencyMetadata dependency) {
        if (dependency.getSelector() instanceof ModuleComponentSelector) {
            ModuleComponentSelector selector = (ModuleComponentSelector)dependency.getSelector();
            VersionConstraint versionConstraint = selector.getVersionConstraint();
            DefaultImmutableVersionConstraint transformedConstraint = new DefaultImmutableVersionConstraint((String)VERSION_TRANSFORMER.transform((Object)versionConstraint.getPreferredVersion()), CollectionUtils.collect((List)versionConstraint.getRejectedVersions(), VERSION_TRANSFORMER));
            ModuleComponentSelector newSelector = DefaultModuleComponentSelector.newSelector(selector.getGroup(), selector.getModule(), transformedConstraint);
            return dependency.withTarget((ComponentSelector)newSelector);
        }
        return dependency;
    }

    @Override
    public void addArtifacts(String configuration, Iterable<? extends PublishArtifact> artifacts) {
        for (PublishArtifact publishArtifact : artifacts) {
            DefaultIvyArtifactName ivyName = DefaultIvyArtifactName.forPublishArtifact(publishArtifact);
            DefaultIvyModuleArtifactPublishMetadata ivyArtifact = this.getOrCreate(ivyName);
            ivyArtifact.setFile(publishArtifact.getFile());
            ivyArtifact.addConfiguration(configuration);
        }
    }

    @Override
    public void addVariant(String configuration, OutgoingVariant variant) {
    }

    @Override
    public void addArtifact(IvyArtifactName artifact, File file) {
        DefaultIvyModuleArtifactPublishMetadata publishMetadata = new DefaultIvyModuleArtifactPublishMetadata(this.id, artifact);
        publishMetadata.setFile(file);
        this.artifactsById.put(publishMetadata.getId(), publishMetadata);
    }

    public void addArtifact(IvyModuleArtifactPublishMetadata artifact) {
        this.artifactsById.put(artifact.getId(), artifact);
    }

    private DefaultIvyModuleArtifactPublishMetadata getOrCreate(IvyArtifactName ivyName) {
        for (IvyModuleArtifactPublishMetadata artifactPublishMetadata : this.artifactsById.values()) {
            if (!artifactPublishMetadata.getArtifactName().equals(ivyName)) continue;
            return (DefaultIvyModuleArtifactPublishMetadata)artifactPublishMetadata;
        }
        DefaultIvyModuleArtifactPublishMetadata artifact = new DefaultIvyModuleArtifactPublishMetadata(this.id, ivyName);
        this.artifactsById.put(artifact.getId(), artifact);
        return artifact;
    }

    @Override
    public Collection<IvyModuleArtifactPublishMetadata> getArtifacts() {
        return this.artifactsById.values();
    }

    @Override
    public void addFiles(String configuration, LocalFileDependencyMetadata files) {
    }

    private static class IvyVersionTransformer
    implements Transformer<String, String> {
        private IvyVersionTransformer() {
        }

        public String transform(String version) {
            if (version != null && version.startsWith("[") && version.endsWith("]") && version.indexOf(44) == -1) {
                return version.substring(1, version.length() - 1);
            }
            return version;
        }
    }
}

