/*
 * Decompiled with CFR 0.152.
 */
package org.gradle.internal.component.external.model;

import com.google.common.collect.ImmutableList;
import com.google.common.collect.ImmutableMap;
import java.util.Collections;
import java.util.List;
import java.util.Set;
import javax.annotation.Nullable;
import org.gradle.api.artifacts.ModuleVersionIdentifier;
import org.gradle.api.artifacts.component.ModuleComponentIdentifier;
import org.gradle.api.internal.attributes.AttributesSchemaInternal;
import org.gradle.api.internal.attributes.EmptySchema;
import org.gradle.internal.component.external.model.DefaultModuleComponentArtifactMetadata;
import org.gradle.internal.component.external.model.ModuleComponentArtifactMetadata;
import org.gradle.internal.component.external.model.ModuleComponentResolveMetadata;
import org.gradle.internal.component.external.model.ModuleDependencyMetadata;
import org.gradle.internal.component.external.model.MutableModuleComponentResolveMetadata;
import org.gradle.internal.component.model.ConfigurationMetadata;
import org.gradle.internal.component.model.DefaultIvyArtifactName;
import org.gradle.internal.component.model.ModuleSource;
import org.gradle.internal.hash.HashValue;

abstract class AbstractModuleComponentResolveMetadata
implements ModuleComponentResolveMetadata {
    private final ModuleVersionIdentifier moduleVersionIdentifier;
    private final ModuleComponentIdentifier componentIdentifier;
    private final boolean changing;
    private final boolean missing;
    private final String status;
    private final List<String> statusScheme;
    @Nullable
    private final ModuleSource moduleSource;
    private final ImmutableMap<String, ? extends ConfigurationMetadata> configurations;
    @Nullable
    private final ImmutableList<? extends ModuleComponentArtifactMetadata> artifactOverrides;
    private final List<? extends ModuleDependencyMetadata> dependencies;
    private final HashValue contentHash;

    protected AbstractModuleComponentResolveMetadata(MutableModuleComponentResolveMetadata metadata) {
        this.componentIdentifier = metadata.getComponentId();
        this.moduleVersionIdentifier = metadata.getId();
        this.changing = metadata.isChanging();
        this.missing = metadata.isMissing();
        this.status = metadata.getStatus();
        this.statusScheme = metadata.getStatusScheme();
        this.moduleSource = metadata.getSource();
        this.dependencies = metadata.getDependencies();
        this.artifactOverrides = metadata.getArtifactOverrides();
        this.configurations = metadata.getConfigurations();
        this.contentHash = metadata.getContentHash();
    }

    protected AbstractModuleComponentResolveMetadata(AbstractModuleComponentResolveMetadata metadata, @Nullable ModuleSource source) {
        this.componentIdentifier = metadata.getComponentId();
        this.moduleVersionIdentifier = metadata.getId();
        this.changing = metadata.isChanging();
        this.missing = metadata.isMissing();
        this.status = metadata.getStatus();
        this.statusScheme = metadata.getStatusScheme();
        this.moduleSource = source;
        this.dependencies = metadata.getDependencies();
        this.artifactOverrides = metadata.getArtifactOverrides();
        this.configurations = metadata.getConfigurations();
        this.contentHash = metadata.getContentHash();
    }

    @Override
    @Nullable
    public AttributesSchemaInternal getAttributesSchema() {
        return EmptySchema.INSTANCE;
    }

    @Override
    public HashValue getContentHash() {
        return this.contentHash;
    }

    @Override
    public boolean isChanging() {
        return this.changing;
    }

    @Override
    public boolean isMissing() {
        return this.missing;
    }

    @Override
    public String getStatus() {
        return this.status;
    }

    @Override
    public List<String> getStatusScheme() {
        return this.statusScheme;
    }

    @Override
    public ModuleComponentIdentifier getComponentId() {
        return this.componentIdentifier;
    }

    @Override
    public ModuleVersionIdentifier getId() {
        return this.moduleVersionIdentifier;
    }

    @Override
    public ModuleSource getSource() {
        return this.moduleSource;
    }

    @Override
    public Set<String> getConfigurationNames() {
        return this.configurations.keySet();
    }

    @Override
    public List<? extends ConfigurationMetadata> getVariantsForGraphTraversal() {
        return Collections.emptyList();
    }

    public String toString() {
        return this.componentIdentifier.getDisplayName();
    }

    @Override
    public ModuleComponentArtifactMetadata artifact(String type, @Nullable String extension, @Nullable String classifier) {
        DefaultIvyArtifactName ivyArtifactName = new DefaultIvyArtifactName(this.getId().getName(), type, extension, classifier);
        return new DefaultModuleComponentArtifactMetadata(this.getComponentId(), ivyArtifactName);
    }

    @Override
    @Nullable
    public ImmutableList<? extends ModuleComponentArtifactMetadata> getArtifactOverrides() {
        return this.artifactOverrides;
    }

    @Override
    public List<? extends ModuleDependencyMetadata> getDependencies() {
        return this.dependencies;
    }

    @Override
    public ImmutableMap<String, ? extends ConfigurationMetadata> getConfigurations() {
        return this.configurations;
    }

    @Override
    public ConfigurationMetadata getConfiguration(String name) {
        return (ConfigurationMetadata)this.configurations.get((Object)name);
    }
}

