/*
 * Decompiled with CFR 0.152.
 */
package org.gradle.api.internal.artifacts.repositories.resolver;

import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import javax.xml.parsers.ParserConfigurationException;
import org.apache.ivy.util.ContextualSAXHandler;
import org.apache.ivy.util.XMLHelper;
import org.gradle.api.Action;
import org.gradle.api.internal.artifacts.repositories.resolver.MavenMetadata;
import org.gradle.api.resources.MissingResourceException;
import org.gradle.api.resources.ResourceException;
import org.gradle.internal.ErroringAction;
import org.gradle.internal.hash.Hashing;
import org.gradle.internal.resource.ExternalResource;
import org.gradle.internal.resource.ExternalResourceName;
import org.gradle.internal.resource.local.FileStore;
import org.gradle.internal.resource.local.LocallyAvailableExternalResource;
import org.gradle.internal.resource.local.LocallyAvailableResource;
import org.gradle.internal.resource.transfer.CacheAwareExternalResourceAccessor;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.xml.sax.SAXException;
import org.xml.sax.helpers.DefaultHandler;

class MavenMetadataLoader {
    private static final Logger LOGGER = LoggerFactory.getLogger(MavenMetadataLoader.class);
    private final CacheAwareExternalResourceAccessor cacheAwareExternalResourceAccessor;
    private final FileStore<String> resourcesFileStore;

    public MavenMetadataLoader(CacheAwareExternalResourceAccessor cacheAwareExternalResourceAccessor, FileStore<String> resourcesFileStore) {
        this.cacheAwareExternalResourceAccessor = cacheAwareExternalResourceAccessor;
        this.resourcesFileStore = resourcesFileStore;
    }

    public MavenMetadata load(ExternalResourceName metadataLocation) throws ResourceException {
        MavenMetadata metadata = new MavenMetadata();
        try {
            this.parseMavenMetadataInfo(metadataLocation, metadata);
        }
        catch (MissingResourceException e) {
            throw e;
        }
        catch (Exception e) {
            throw new ResourceException(metadataLocation.getUri(), String.format("Unable to load Maven meta-data from %s.", metadataLocation), (Throwable)e);
        }
        return metadata;
    }

    private void parseMavenMetadataInfo(final ExternalResourceName metadataLocation, MavenMetadata metadata) throws IOException {
        LocallyAvailableExternalResource resource = this.cacheAwareExternalResourceAccessor.getResource(metadataLocation, new CacheAwareExternalResourceAccessor.ResourceFileStore(){

            @Override
            public LocallyAvailableResource moveIntoCache(File downloadedResource) {
                String key = Hashing.sha1().hashString((CharSequence)metadataLocation.toString()).toString();
                return MavenMetadataLoader.this.resourcesFileStore.move((Object)key, downloadedResource);
            }
        }, null);
        if (resource == null) {
            throw new MissingResourceException(metadataLocation.getUri(), String.format("Maven meta-data not available at %s", metadataLocation));
        }
        this.parseMavenMetadataInto((ExternalResource)resource, metadata);
    }

    private void parseMavenMetadataInto(ExternalResource metadataResource, final MavenMetadata mavenMetadata) {
        LOGGER.debug("parsing maven-metadata: {}", (Object)metadataResource);
        metadataResource.withContent((Action)new ErroringAction<InputStream>(){

            public void doExecute(InputStream inputStream) throws ParserConfigurationException, SAXException, IOException {
                XMLHelper.parse((InputStream)inputStream, null, (DefaultHandler)new ContextualSAXHandler(){

                    public void endElement(String uri, String localName, String qName) throws SAXException {
                        if ("metadata/versioning/snapshot/timestamp".equals(this.getContext())) {
                            mavenMetadata.timestamp = this.getText();
                        }
                        if ("metadata/versioning/snapshot/buildNumber".equals(this.getContext())) {
                            mavenMetadata.buildNumber = this.getText();
                        }
                        if ("metadata/versioning/versions/version".equals(this.getContext())) {
                            mavenMetadata.versions.add(this.getText().trim());
                        }
                        super.endElement(uri, localName, qName);
                    }
                }, null);
            }
        });
    }
}

