/*
 * Decompiled with CFR 0.152.
 */
package org.gradle.api.internal.artifacts.ivyservice.ivyresolve.parser;

import com.google.common.collect.ArrayListMultimap;
import com.google.common.collect.Lists;
import com.google.common.collect.Maps;
import com.google.common.collect.Multimap;
import com.google.common.collect.Sets;
import java.lang.reflect.Field;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import org.apache.ivy.core.module.descriptor.Configuration;
import org.apache.ivy.core.module.descriptor.DefaultDependencyDescriptor;
import org.apache.ivy.core.module.descriptor.DependencyArtifactDescriptor;
import org.apache.ivy.core.module.descriptor.DependencyDescriptor;
import org.apache.ivy.core.module.descriptor.ExcludeRule;
import org.apache.ivy.core.module.descriptor.ModuleDescriptor;
import org.apache.ivy.core.module.id.ArtifactId;
import org.apache.ivy.core.module.id.ModuleRevisionId;
import org.gradle.api.artifacts.ModuleVersionSelector;
import org.gradle.api.internal.artifacts.DefaultModuleVersionSelector;
import org.gradle.api.internal.artifacts.ImmutableModuleIdentifierFactory;
import org.gradle.api.internal.artifacts.ivyservice.NamespaceId;
import org.gradle.internal.Cast;
import org.gradle.internal.UncheckedException;
import org.gradle.internal.component.external.descriptor.Artifact;
import org.gradle.internal.component.external.descriptor.DefaultExclude;
import org.gradle.internal.component.external.model.IvyDependencyMetadata;
import org.gradle.internal.component.model.DefaultIvyArtifactName;
import org.gradle.internal.component.model.Exclude;

public class IvyModuleDescriptorConverter {
    private static final String CLASSIFIER = "classifier";
    private static final Field DEPENDENCY_CONFIG_FIELD;
    private final ImmutableModuleIdentifierFactory moduleIdentifierFactory;

    public IvyModuleDescriptorConverter(ImmutableModuleIdentifierFactory moduleIdentifierFactory) {
        this.moduleIdentifierFactory = moduleIdentifierFactory;
    }

    public Map<NamespaceId, String> extractExtraAttributes(ModuleDescriptor ivyDescriptor) {
        return (Map)Cast.uncheckedCast((Object)ivyDescriptor.getExtraInfo());
    }

    public List<Exclude> extractExcludes(ModuleDescriptor ivyDescriptor) {
        ArrayList result = Lists.newArrayListWithCapacity((int)ivyDescriptor.getAllExcludeRules().length);
        for (ExcludeRule excludeRule : ivyDescriptor.getAllExcludeRules()) {
            result.add(this.forIvyExclude(excludeRule));
        }
        return result;
    }

    public List<IvyDependencyMetadata> extractDependencies(ModuleDescriptor ivyDescriptor) {
        ArrayList result = Lists.newArrayListWithCapacity((int)ivyDescriptor.getDependencies().length);
        for (DependencyDescriptor dependencyDescriptor : ivyDescriptor.getDependencies()) {
            this.addDependency(result, dependencyDescriptor);
        }
        return result;
    }

    public List<org.gradle.internal.component.external.descriptor.Configuration> extractConfigurations(ModuleDescriptor ivyDescriptor) {
        ArrayList result = Lists.newArrayListWithCapacity((int)ivyDescriptor.getConfigurations().length);
        for (Configuration ivyConfiguration : ivyDescriptor.getConfigurations()) {
            IvyModuleDescriptorConverter.addConfiguration(result, ivyConfiguration);
        }
        return result;
    }

    private static void addConfiguration(List<org.gradle.internal.component.external.descriptor.Configuration> result, Configuration configuration) {
        String name = configuration.getName();
        boolean transitive = configuration.isTransitive();
        boolean visible = configuration.getVisibility() == Configuration.Visibility.PUBLIC;
        ArrayList extendsFrom = Lists.newArrayList((Object[])configuration.getExtends());
        result.add(new org.gradle.internal.component.external.descriptor.Configuration(name, transitive, visible, extendsFrom));
    }

    private void addDependency(List<IvyDependencyMetadata> result, DependencyDescriptor dependencyDescriptor) {
        ModuleRevisionId revisionId = dependencyDescriptor.getDependencyRevisionId();
        ModuleVersionSelector requested = DefaultModuleVersionSelector.newSelector(revisionId.getOrganisation(), revisionId.getName(), revisionId.getRevision());
        ArrayListMultimap configMappings = ArrayListMultimap.create();
        for (Map.Entry<String, List<String>> entry : IvyModuleDescriptorConverter.readConfigMappings(dependencyDescriptor).entrySet()) {
            configMappings.putAll((Object)entry.getKey(), (Iterable)entry.getValue());
        }
        ArrayList artifacts = Lists.newArrayList();
        for (DependencyArtifactDescriptor ivyArtifact : dependencyDescriptor.getAllDependencyArtifacts()) {
            DefaultIvyArtifactName ivyArtifactName = new DefaultIvyArtifactName(ivyArtifact.getName(), ivyArtifact.getType(), ivyArtifact.getExt(), (String)ivyArtifact.getExtraAttributes().get(CLASSIFIER));
            artifacts.add(new Artifact(ivyArtifactName, Sets.newHashSet((Object[])ivyArtifact.getConfigurations())));
        }
        ArrayList excludes = Lists.newArrayList();
        for (ExcludeRule excludeRule : dependencyDescriptor.getAllExcludeRules()) {
            excludes.add(this.forIvyExclude(excludeRule));
        }
        result.add(new IvyDependencyMetadata(requested, dependencyDescriptor.getDynamicConstraintDependencyRevisionId().getRevision(), false, dependencyDescriptor.isChanging(), dependencyDescriptor.isTransitive(), (Multimap<String, String>)configMappings, artifacts, excludes));
    }

    private Exclude forIvyExclude(ExcludeRule excludeRule) {
        ArtifactId id = excludeRule.getId();
        return new DefaultExclude(this.moduleIdentifierFactory.module(id.getModuleId().getOrganisation(), id.getModuleId().getName()), id.getName(), id.getType(), id.getExt(), excludeRule.getConfigurations(), excludeRule.getMatcher().getName());
    }

    private static Map<String, List<String>> readConfigMappings(DependencyDescriptor dependencyDescriptor) {
        if (dependencyDescriptor instanceof DefaultDependencyDescriptor) {
            try {
                return (Map)DEPENDENCY_CONFIG_FIELD.get(dependencyDescriptor);
            }
            catch (IllegalAccessException e) {
                throw UncheckedException.throwAsUncheckedException((Throwable)e);
            }
        }
        String[] modConfs = dependencyDescriptor.getModuleConfigurations();
        LinkedHashMap results = Maps.newLinkedHashMap();
        for (String modConf : modConfs) {
            results.put(modConf, Arrays.asList(dependencyDescriptor.getDependencyConfigurations(modConfs)));
        }
        return results;
    }

    static {
        try {
            DEPENDENCY_CONFIG_FIELD = DefaultDependencyDescriptor.class.getDeclaredField("confs");
            DEPENDENCY_CONFIG_FIELD.setAccessible(true);
        }
        catch (NoSuchFieldException e) {
            throw UncheckedException.throwAsUncheckedException((Throwable)e);
        }
    }
}

