/*
 * Decompiled with CFR 0.152.
 */
package org.gradle.api.internal.artifacts.ivyservice.ivyresolve;

import com.google.common.collect.Sets;
import java.io.IOException;
import java.util.Set;
import org.apache.commons.lang.exception.ExceptionUtils;
import org.gradle.api.UncheckedIOException;
import org.gradle.api.internal.artifacts.ivyservice.ivyresolve.RepositoryBlacklister;

public class ConnectionFailureRepositoryBlacklister
implements RepositoryBlacklister {
    private final Set<String> blacklistedRepositories = Sets.newConcurrentHashSet();

    @Override
    public boolean isBlacklisted(String repositoryId) {
        return this.blacklistedRepositories.contains(repositoryId);
    }

    @Override
    public boolean blacklistRepository(String repositoryId, Throwable throwable) {
        boolean blacklisted = this.isBlacklisted(repositoryId);
        if (blacklisted) {
            return true;
        }
        if (this.isRootCauseIOException(throwable)) {
            this.blacklistedRepositories.add(repositoryId);
            return true;
        }
        return false;
    }

    @Override
    public Set<String> getBlacklistedRepositories() {
        return this.blacklistedRepositories;
    }

    private boolean isRootCauseIOException(Throwable throwable) {
        Throwable rootCause = ExceptionUtils.getRootCause((Throwable)throwable);
        return rootCause instanceof IOException || rootCause instanceof UncheckedIOException;
    }
}

