/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.kotlin.com.intellij.util.containers;

import java.util.Iterator;
import java.util.List;
import java.util.NoSuchElementException;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.kotlin.com.intellij.openapi.util.Condition;
import org.jetbrains.kotlin.com.intellij.openapi.util.text.StringUtil;
import org.jetbrains.kotlin.com.intellij.util.Function;
import org.jetbrains.kotlin.com.intellij.util.containers.JBIterable;

public abstract class JBIterator<E>
implements Iterator<E> {
    private Object myCurrent = Do.INIT;
    private Object myNext = Do.INIT;
    private Op myFirstOp;
    private Op myLastOp = this.myFirstOp = new NextOp();
    private static final Function.Mono CURSOR_NEXT = new Function.Mono<JBIterator<?>>(){

        @Override
        public JBIterator<?> fun(JBIterator<?> iterator2) {
            return (JBIterator)((JBIterator)iterator2).addOp(false, iterator2.new CursorOp());
        }
    };

    @NotNull
    public static <E> JBIterator<E> from(@NotNull Iterator<E> it) {
        if (it == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "it", "org/jetbrains/kotlin/com/intellij/util/containers/JBIterator", "from"));
        }
        JBIterator<E> jBIterator = it instanceof JBIterator ? (JBIterator<E>)it : JBIterator.wrap(it);
        if (jBIterator == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/kotlin/com/intellij/util/containers/JBIterator", "from"));
        }
        return jBIterator;
    }

    @NotNull
    static <E> JBIterator<E> wrap(final @NotNull Iterator<E> it) {
        if (it == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "it", "org/jetbrains/kotlin/com/intellij/util/containers/JBIterator", "wrap"));
        }
        JBIterator jBIterator = new JBIterator<E>(){

            @Override
            protected E nextImpl() {
                return it.hasNext() ? it.next() : this.stop();
            }
        };
        if (jBIterator == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/kotlin/com/intellij/util/containers/JBIterator", "wrap"));
        }
        return jBIterator;
    }

    protected abstract E nextImpl();

    protected void currentChanged() {
    }

    @Nullable
    protected final E stop() {
        this.myNext = Do.STOP;
        return null;
    }

    @Nullable
    protected final E skip() {
        this.myNext = Do.SKIP;
        return null;
    }

    @Override
    public final boolean hasNext() {
        this.peekNext();
        return this.myNext != Do.STOP;
    }

    @Override
    public final E next() {
        this.advance();
        return this.current();
    }

    public final boolean advance() {
        this.myCurrent = Do.INIT;
        this.peekNext();
        if (this.myNext == Do.STOP) {
            return false;
        }
        this.myCurrent = this.myNext;
        this.myNext = Do.INIT;
        if (this.myFirstOp instanceof CursorOp) {
            ((CursorOp)this.myFirstOp).advance(this.myCurrent);
        }
        this.currentChanged();
        return true;
    }

    public final E current() {
        if (this.myCurrent == Do.INIT) {
            throw new NoSuchElementException();
        }
        return (E)this.myCurrent;
    }

    private void peekNext() {
        if (this.myNext != Do.INIT) {
            return;
        }
        Object o = Do.INIT;
        Op op = this.myFirstOp;
        while (op != null) {
            o = op.apply(op.impl == null ? this.nextImpl() : o);
            if (this.myNext == Do.STOP) {
                return;
            }
            if (this.myNext == Do.SKIP) {
                this.myNext = Do.INIT;
                o = this.myNext;
                if (op.impl == null) {
                    Op op2 = this.myFirstOp;
                    while (op2.impl instanceof CountDown) {
                        ++((CountDown)op2.impl).cur;
                        op2 = op2.nextOp;
                    }
                }
                op = null;
            }
            op = op == null ? this.myFirstOp : op.nextOp;
        }
        this.myNext = o;
    }

    @NotNull
    public final <T> JBIterator<T> transform(@NotNull Function<? super E, T> function2) {
        if (function2 == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "function", "org/jetbrains/kotlin/com/intellij/util/containers/JBIterator", "transform"));
        }
        JBIterator jBIterator = (JBIterator)this.addOp(true, new TransformOp<E, T>(function2));
        if (jBIterator == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/kotlin/com/intellij/util/containers/JBIterator", "transform"));
        }
        return jBIterator;
    }

    @NotNull
    public final JBIterator<E> filter(@NotNull Condition<? super E> condition) {
        if (condition == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "condition", "org/jetbrains/kotlin/com/intellij/util/containers/JBIterator", "filter"));
        }
        JBIterator jBIterator = (JBIterator)this.addOp(true, new FilterOp<E>(condition));
        if (jBIterator == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/kotlin/com/intellij/util/containers/JBIterator", "filter"));
        }
        return jBIterator;
    }

    @NotNull
    public final JBIterator<E> take(int count) {
        JBIterator jBIterator = (JBIterator)this.addOp(!(this.myLastOp instanceof NextOp), new WhileOp(new CountDown(count)));
        if (jBIterator == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/kotlin/com/intellij/util/containers/JBIterator", "take"));
        }
        return jBIterator;
    }

    @NotNull
    public final JBIterator<E> takeWhile(@NotNull Condition<? super E> condition) {
        if (condition == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "condition", "org/jetbrains/kotlin/com/intellij/util/containers/JBIterator", "takeWhile"));
        }
        JBIterator jBIterator = (JBIterator)this.addOp(true, new WhileOp<E>(condition));
        if (jBIterator == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/kotlin/com/intellij/util/containers/JBIterator", "takeWhile"));
        }
        return jBIterator;
    }

    @NotNull
    public final JBIterator<E> skip(int count) {
        JBIterator jBIterator = this.skipWhile(new CountDown(count));
        if (jBIterator == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/kotlin/com/intellij/util/containers/JBIterator", "skip"));
        }
        return jBIterator;
    }

    @NotNull
    public final JBIterator<E> skipWhile(@NotNull Condition<? super E> condition) {
        if (condition == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "condition", "org/jetbrains/kotlin/com/intellij/util/containers/JBIterator", "skipWhile"));
        }
        JBIterator jBIterator = (JBIterator)this.addOp(true, new SkipOp<E>(condition));
        if (jBIterator == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/kotlin/com/intellij/util/containers/JBIterator", "skipWhile"));
        }
        return jBIterator;
    }

    @NotNull
    private <T> T addOp(boolean last, @NotNull Op op) {
        if (op == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "op", "org/jetbrains/kotlin/com/intellij/util/containers/JBIterator", "addOp"));
        }
        if (op.impl == null) {
            this.myFirstOp = this.myLastOp = op;
        } else if (last) {
            this.myLastOp = this.myLastOp.nextOp = op;
        } else {
            op.nextOp = this.myFirstOp;
            this.myFirstOp = op;
        }
        JBIterator jBIterator = this;
        if (jBIterator == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/kotlin/com/intellij/util/containers/JBIterator", "addOp"));
        }
        return (T)jBIterator;
    }

    @Override
    public final void remove() {
        throw new UnsupportedOperationException();
    }

    public String toString() {
        List<Op> ops = this.operationsImpl().toList();
        return "{cur=" + this.myCurrent + "; next=" + this.myNext + (ops.size() < 2 ? "" : "; ops=" + ops) + "}";
    }

    @NotNull
    private JBIterable<Op> operationsImpl() {
        JBIterable<Op> jBIterable = JBIterable.generate(this.myFirstOp, new Function<Op, Op>(){

            @Override
            public Op fun(Op op) {
                return op.nextOp;
            }
        });
        if (jBIterable == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/kotlin/com/intellij/util/containers/JBIterator", "operationsImpl"));
        }
        return jBIterable;
    }

    @NotNull
    static String toShortString(@NotNull Object o) {
        if (o == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "o", "org/jetbrains/kotlin/com/intellij/util/containers/JBIterator", "toShortString"));
        }
        String name = o.getClass().getName();
        int idx = name.lastIndexOf(36);
        if (idx > 0 && idx < name.length() && StringUtil.isJavaIdentifierStart(name.charAt(idx + 1))) {
            String string = name.substring(idx + 1);
            if (string == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/kotlin/com/intellij/util/containers/JBIterator", "toShortString"));
            }
            return string;
        }
        String string = name.substring(name.lastIndexOf(46) + 1);
        if (string == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/kotlin/com/intellij/util/containers/JBIterator", "toShortString"));
        }
        return string;
    }

    private class CursorOp
    extends Op<Void> {
        boolean advanced;

        CursorOp() {
            super(null);
        }

        @Override
        Object apply(Object o) {
            JBIterator it = (JBIterator)o;
            this.advanced = this.nextOp != null;
            return (this.advanced ? it.advance() : it.hasNext()) ? it : JBIterator.this.stop();
        }

        void advance(Object o) {
            if (this.advanced || !(o instanceof JBIterator)) {
                return;
            }
            ((JBIterator)o).advance();
            this.advanced = true;
        }
    }

    private static class NextOp
    extends Op<Void> {
        NextOp() {
            super(null);
        }

        @Override
        Object apply(Object o) {
            return o;
        }
    }

    private class SkipOp<E>
    extends Op<Condition<? super E>> {
        boolean active;

        SkipOp(Condition<? super E> condition) {
            super(condition);
            this.active = true;
        }

        @Override
        Object apply(Object o) {
            if (this.active && ((Condition)this.impl).value(o)) {
                return JBIterator.this.skip();
            }
            this.active = false;
            return o;
        }
    }

    private class WhileOp<E>
    extends Op<Condition<? super E>> {
        WhileOp(Condition<? super E> condition) {
            super(condition);
        }

        @Override
        Object apply(Object o) {
            return ((Condition)this.impl).value(o) ? o : JBIterator.this.stop();
        }
    }

    private class FilterOp<E>
    extends Op<Condition<? super E>> {
        FilterOp(Condition<? super E> condition) {
            super(condition);
        }

        @Override
        Object apply(Object o) {
            return ((Condition)this.impl).value(o) ? o : JBIterator.this.skip();
        }
    }

    private static class TransformOp<E, T>
    extends Op<Function<? super E, T>> {
        TransformOp(Function<? super E, T> function2) {
            super(function2);
        }

        @Override
        Object apply(Object o) {
            return ((Function)this.impl).fun(o);
        }
    }

    private static class CountDown<A>
    implements Condition<A> {
        int cur;

        public CountDown(int count) {
            this.cur = count;
        }

        @Override
        public boolean value(A a) {
            return this.cur > 0 && this.cur-- != 0;
        }
    }

    private static class Op<T> {
        final T impl;
        Op nextOp;

        public Op(T impl) {
            this.impl = impl;
        }

        Object apply(Object o) {
            throw new UnsupportedOperationException();
        }

        public String toString() {
            return JBIterator.toShortString(this.impl == null ? this : this.impl);
        }
    }

    private static enum Do {
        INIT,
        STOP,
        SKIP;

    }
}

