/*
 * Decompiled with CFR 0.152.
 */
package org.gradle.language.swift.plugins;

import com.google.common.collect.Lists;
import javax.inject.Inject;
import org.gradle.api.Incubating;
import org.gradle.api.Plugin;
import org.gradle.api.artifacts.ConfigurationContainer;
import org.gradle.api.internal.file.FileOperations;
import org.gradle.api.internal.project.ProjectInternal;
import org.gradle.api.internal.tasks.TaskContainerInternal;
import org.gradle.api.provider.Property;
import org.gradle.language.swift.SwiftApplication;
import org.gradle.language.swift.internal.DefaultSwiftApplication;
import org.gradle.language.swift.plugins.SwiftBasePlugin;
import org.gradle.language.swift.tasks.SwiftCompile;
import org.gradle.nativeplatform.tasks.InstallExecutable;
import org.gradle.util.GUtil;

@Incubating
public class SwiftExecutablePlugin
implements Plugin<ProjectInternal> {
    private final FileOperations fileOperations;

    @Inject
    public SwiftExecutablePlugin(FileOperations fileOperations) {
        this.fileOperations = fileOperations;
    }

    public void apply(ProjectInternal project) {
        project.getPluginManager().apply(SwiftBasePlugin.class);
        ConfigurationContainer configurations = project.getConfigurations();
        TaskContainerInternal tasks = project.getTasks();
        SwiftApplication application = (SwiftApplication)project.getExtensions().create(SwiftApplication.class, "executable", DefaultSwiftApplication.class, new Object[]{"main", project.getObjects(), this.fileOperations, configurations});
        project.getComponents().add((Object)application);
        project.getComponents().add((Object)application.getDebugExecutable());
        project.getComponents().add((Object)application.getReleaseExecutable());
        Property<String> module = application.getModule();
        module.set((Object)GUtil.toCamelCase((CharSequence)project.getName()));
        SwiftCompile compile = (SwiftCompile)tasks.getByName("compileDebugSwift");
        compile.getCompilerArgs().set((Object)Lists.newArrayList((Object[])new String[]{"-enable-testing"}));
        InstallExecutable install = (InstallExecutable)tasks.getByName("installDebug");
        tasks.getByName("assemble").dependsOn(new Object[]{install});
    }
}

