/*
 * Decompiled with CFR 0.152.
 */
package org.gradle.api.internal.artifacts.ivyservice.resolveengine.graph.builder;

import com.google.common.collect.Lists;
import java.util.List;
import org.gradle.api.artifacts.ModuleIdentifier;
import org.gradle.api.internal.artifacts.ivyservice.resolveengine.graph.builder.DependencyState;
import org.gradle.api.internal.artifacts.ivyservice.resolveengine.graph.builder.NodeState;
import org.gradle.api.internal.artifacts.ivyservice.resolveengine.graph.builder.PendingDependencies;
import org.gradle.api.internal.artifacts.ivyservice.resolveengine.graph.builder.PendingDependenciesHandler;
import org.gradle.api.internal.artifacts.ivyservice.resolveengine.graph.builder.PendingDependenciesState;

class DefaultPendingDependenciesHandler
implements PendingDependenciesHandler {
    private final PendingDependenciesState pendingDependencies = new PendingDependenciesState();

    DefaultPendingDependenciesHandler() {
    }

    @Override
    public PendingDependenciesHandler.Visitor start() {
        return new DefaultVisitor();
    }

    public class DefaultVisitor
    implements PendingDependenciesHandler.Visitor {
        private List<PendingDependencies> noLongerPending;

        @Override
        public boolean maybeAddAsPendingDependency(NodeState node, DependencyState dependencyState) {
            ModuleIdentifier key = dependencyState.getModuleIdentifier();
            boolean isOptionalDependency = dependencyState.getDependency().isPending();
            if (!isOptionalDependency) {
                PendingDependencies priorPendingDependencies = DefaultPendingDependenciesHandler.this.pendingDependencies.notPending(key);
                if (priorPendingDependencies != null && priorPendingDependencies.isPending()) {
                    if (this.noLongerPending == null) {
                        this.noLongerPending = Lists.newLinkedList();
                    }
                    this.noLongerPending.add(priorPendingDependencies);
                }
                return false;
            }
            PendingDependencies pendingDependencies = DefaultPendingDependenciesHandler.this.pendingDependencies.getPendingDependencies(key);
            boolean pending = pendingDependencies.isPending();
            if (!pending) {
                return false;
            }
            pendingDependencies.addNode(node);
            return true;
        }

        @Override
        public void complete() {
            if (this.noLongerPending != null) {
                for (PendingDependencies pendingDependencies : this.noLongerPending) {
                    pendingDependencies.turnIntoHardDependencies();
                }
                this.noLongerPending = null;
            }
        }
    }
}

