/*
 * Decompiled with CFR 0.152.
 */
package com.esotericsoftware.gloomhavenhelper;

import com.badlogic.gdx.Application;
import com.badlogic.gdx.Gdx;
import com.badlogic.gdx.files.FileHandle;
import com.badlogic.gdx.graphics.Color;
import com.badlogic.gdx.graphics.Texture;
import com.badlogic.gdx.graphics.g2d.Batch;
import com.badlogic.gdx.graphics.g2d.TextureAtlas;
import com.badlogic.gdx.graphics.g2d.TextureRegion;
import com.badlogic.gdx.math.MathUtils;
import com.badlogic.gdx.math.Vector2;
import com.badlogic.gdx.scenes.scene2d.Action;
import com.badlogic.gdx.scenes.scene2d.Actor;
import com.badlogic.gdx.scenes.scene2d.Group;
import com.badlogic.gdx.scenes.scene2d.InputEvent;
import com.badlogic.gdx.scenes.scene2d.InputListener;
import com.badlogic.gdx.scenes.scene2d.Touchable;
import com.badlogic.gdx.scenes.scene2d.actions.Actions;
import com.badlogic.gdx.scenes.scene2d.ui.Container;
import com.badlogic.gdx.scenes.scene2d.ui.Image;
import com.badlogic.gdx.scenes.scene2d.ui.ImageButton;
import com.badlogic.gdx.scenes.scene2d.ui.Label;
import com.badlogic.gdx.scenes.scene2d.ui.Table;
import com.badlogic.gdx.scenes.scene2d.ui.TextButton;
import com.badlogic.gdx.scenes.scene2d.ui.Value;
import com.badlogic.gdx.scenes.scene2d.utils.ChangeListener;
import com.badlogic.gdx.scenes.scene2d.utils.ClickListener;
import com.badlogic.gdx.scenes.scene2d.utils.Drawable;
import com.badlogic.gdx.scenes.scene2d.utils.SpriteDrawable;
import com.badlogic.gdx.utils.Array;
import com.badlogic.gdx.utils.ObjectSet;
import com.badlogic.gdx.utils.SnapshotArray;
import com.esotericsoftware.gloomhavenhelper.App;
import com.esotericsoftware.gloomhavenhelper.MonsterBox;
import com.esotericsoftware.gloomhavenhelper.PlayerRowMenu;
import com.esotericsoftware.gloomhavenhelper.SummonAddMenu;
import com.esotericsoftware.gloomhavenhelper.model.CharacterClass;
import com.esotericsoftware.gloomhavenhelper.model.Condition;
import com.esotericsoftware.gloomhavenhelper.model.Monster;
import com.esotericsoftware.gloomhavenhelper.model.Player;
import com.esotericsoftware.gloomhavenhelper.model.PlayerInit;
import com.esotericsoftware.gloomhavenhelper.model.SummonColor;
import com.esotericsoftware.gloomhavenhelper.network.Network;
import com.esotericsoftware.gloomhavenhelper.util.Animator;
import com.esotericsoftware.gloomhavenhelper.util.DragAdjust;
import com.esotericsoftware.gloomhavenhelper.util.HPAdjust;
import com.esotericsoftware.gloomhavenhelper.util.Row;
import com.esotericsoftware.gloomhavenhelper.util.TextMenu;
import com.esotericsoftware.gloomhavenhelper.util.builders.TextButtonBuilder;
import com.esotericsoftware.minlog.Log;

public class PlayerRow
extends Row {
    public static final ObjectSet<CharacterClass> localInit = new ObjectSet();
    private float hpPercent;
    Actor dragArea;
    private TextureRegion hpRegion;
    private TextureRegion initRegion;
    Drawable bloodDrawable;
    Drawable iconDrawable;
    Drawable glowDrawable;
    PlayerRowMenu menu;
    HPAdjust hpAdjust;
    HPAdjust xpAdjust;
    long lastAnimateIcon;
    DragAdjust initListener;
    Label nameLabel;
    Label hpLabel;
    Label lootLabel;
    Label xpLabel;
    Table leftInfo;
    Table rightInfo;
    ImageButton addSummonButton;
    float summonAlpha;
    float glowAlpha;
    public final Player player;

    public PlayerRow(Player player) {
        this.player = player;
        this.hpPercent = Math.min(1.0f, (float)player.hp / (float)player.hpMax);
        this.create();
        this.layoutUI();
        this.events();
    }

    private void create() {
        this.dragArea = new Actor();
        this.hpRegion = App.skin.getRegion("player-hp");
        this.initRegion = App.skin.getRegion("init");
        this.glowDrawable = App.skin.getDrawable("player-glow");
        this.bloodDrawable = App.skin.getDrawable("blood");
        this.iconDrawable = App.skin.getDrawable("class-icons/" + this.player.characterClass.name());
        this.nameLabel = new Label((CharSequence)this.player.characterClass.toString(), App.skin, "fancyLargeOutline", Color.WHITE);
        this.nameLabel.setEllipsis(true);
        this.leftInfo = new Table();
        this.rightInfo = new Table();
        this.hpLabel = new Label((CharSequence)"", App.skin, "plainExtraLargeOutlineNumbers", Color.WHITE);
        this.lootLabel = new Label((CharSequence)"", App.skin, "plainLargeOutlineFixedNumbers", App.lootGold);
        this.lootLabel.setAlignment(16);
        this.xpLabel = new Label((CharSequence)"", App.skin, "plainLargeOutlineFixedNumbers", App.xpBlue);
        this.xpLabel.setAlignment(16);
        this.addSummonButton = App.imageButton().imageUp("psd/add", App.buttonGray).imageOver("psd/add").imageDisabled("psd/add", App.disabledGray).create();
        this.menu = new PlayerRowMenu(this);
    }

    private void layoutUI() {
        TextureRegion bg;
        block7: {
            Image icon = new Image(this.iconDrawable);
            icon.setTouchable(Touchable.disabled);
            this.leftInfo.add(icon).pad(-36.0f, -16.0f, -40.0f, -14.0f).minSize(Value.prefWidth);
            this.leftInfo.add(this.nameLabel).growX().pad(-2.0f, 0.0f, -1.0f, 0.0f).minWidth(0.0f).prefWidth(0.0f).row();
            this.leftInfo.add(this.hpLabel).colspan(2).expand().pad(-2.0f, 53.0f, 0.0f, 0.0f).left();
            this.rightInfo.add(this.xpLabel).right().padRight(9.0f).height(0.0f).padTop(2.0f).minWidth(30.0f);
            this.rightInfo.add(new Image(App.skin.newDrawable("psd/xp", App.xpBlue))).row();
            this.rightInfo.add(this.lootLabel).right().padRight(7.0f).height(0.0f).padTop(17.0f).minWidth(30.0f);
            this.rightInfo.add(new Image(App.skin.newDrawable("abilities/loot", App.lootGold))).padTop(13.0f);
            bg = null;
            try {
                FileHandle file;
                if (Gdx.app.getType() == Application.ApplicationType.Desktop && (file = new FileHandle("class-bgs/" + this.player.characterClass.name() + ".png")).exists()) {
                    try {
                        bg = new TextureRegion(new Texture(file));
                        break block7;
                    }
                    catch (RuntimeException ex) {
                        Log.error("ghh", "Unable to read image: " + file, ex);
                    }
                }
                if ((bg = App.skin.optional("class-bgs/" + this.player.characterClass.name(), TextureRegion.class)) == null) {
                    bg = App.skin.getRegion("separate/class-bgs/" + this.player.characterClass.name());
                }
            }
            catch (RuntimeException file) {
                // empty catch block
            }
        }
        Table table = new Table(){

            @Override
            public void draw(Batch batch, float a) {
                PlayerRow.this.beginDesat(batch);
                super.draw(batch, a);
            }
        };
        table.setClip(true);
        table.pad(10.0f, 0.0f, 15.0f, 12.0f);
        if (bg != null) {
            table.background(new SpriteDrawable(new TextureAtlas.AtlasSprite((TextureAtlas.AtlasRegion)bg)));
        }
        table.add(this.dragArea).width(174.0f).fillY().pad(-20.0f, 0.0f, -20.0f, 0.0f);
        table.add(this.leftInfo).growX().top().left().fillY();
        table.add(this.addSummonButton).size(102.0f).padRight(9.0f);
        table.add(this.rightInfo).padRight(158.0f).fillY();
        this.bottom();
        this.monstersCell = this.add(this.monstersGroup).colspan(2).pad(0.0f, 212.0f, 0.0f, 5.0f).fillX().expandY().top();
        this.row();
        this.add(table).pad(-1.0f, -1.0f, 1.0f, -1.0f).fillX().height(Value.prefHeight).padBottom(-5.0f);
    }

    private void events() {
        this.dragStartActor = this.dragArea;
        this.dragArea.addListener(this.dragListener);
        this.dragArea.addListener(new ClickListener(){

            @Override
            public void touchDragged(InputEvent event, float x, float y, int pointer) {
                super.touchDragged(event, x, y, pointer);
                if (PlayerRow.this.dragListener.isDragging()) {
                    this.cancel();
                }
                if (PlayerRow.this.initListener.isDragging()) {
                    this.cancel();
                }
            }

            @Override
            public void clicked(InputEvent event, float x, float y) {
                if (App.state.canDraw) {
                    if (App.state.playerInit == PlayerInit.numpad) {
                        final TextMenu menu = new TextMenu(){

                            @Override
                            protected void updatePosition() {
                                (this).PlayerRow.this.dragArea.localToStageCoordinates(App.v2.set((this).PlayerRow.this.dragArea.getWidth(), Math.round((this).PlayerRow.this.dragArea.getHeight() / 2.0f)));
                                float x = App.v2.x - 12.0f;
                                float y = App.v2.y;
                                PlayerRow row = PlayerRow.this;
                                row.localToStageCoordinates(App.v2.set(0.0f, 0.0f));
                                this.setPosition(x, y, 0.0f, 0.0f, App.v2.x + 2.0f, App.v2.y, row.getWidth() - 3.0f, row.getHeight() + (float)(row.boxes.size == 0 ? 0 : 6));
                                super.updatePosition();
                            }
                        };
                        final Label numberLabel = new Label((CharSequence)"__", App.skin, "fancyLargeOutlineFixedNumbers", Color.WHITE);
                        numberLabel.setAlignment(1);
                        menu.table.add(new Container<Label>(numberLabel)).row();
                        menu.addListener(new InputListener(){

                            @Override
                            public boolean keyDown(InputEvent event, int keycode) {
                                if (keycode >= 7 && keycode <= 16) {
                                    String digit = Integer.toString(keycode - 7);
                                    numberLabel.setText(String.valueOf(numberLabel.getText().charAt(1)) + digit);
                                    if (numberLabel.getText().charAt(0) != '_') {
                                        (this).PlayerRow.this.player.init(Integer.parseInt(numberLabel.getText().toString()));
                                        localInit.add((this).PlayerRow.this.player.characterClass);
                                        menu.hide();
                                        App.state.changed();
                                    }
                                }
                                return true;
                            }
                        });
                        ChangeListener listener = new ChangeListener(){

                            @Override
                            public void changed(ChangeListener.ChangeEvent event, Actor actor) {
                                String digit = ((TextButton)actor).getText().toString();
                                numberLabel.setText(String.valueOf(numberLabel.getText().charAt(1)) + digit);
                                if (numberLabel.getText().charAt(0) != '_') {
                                    (this).PlayerRow.this.player.init(Integer.parseInt(numberLabel.getText().toString()));
                                    localInit.add((this).PlayerRow.this.player.characterClass);
                                    menu.hide();
                                    App.state.changed();
                                }
                            }
                        };
                        Table numberTable = new Table(App.skin);
                        numberTable.pad(-6.0f, 12.0f, 0.0f, 12.0f).defaults().size(100.0f);
                        numberTable.columnDefaults(0).right();
                        numberTable.columnDefaults(2).left();
                        int i = 1;
                        while (i <= 9) {
                            numberTable.add(((TextButtonBuilder)App.textButton(String.valueOf(i)).change(listener)).create());
                            if (i % 3 == 0) {
                                numberTable.row();
                            }
                            ++i;
                        }
                        numberTable.add();
                        numberTable.add(((TextButtonBuilder)App.textButton("0").change(listener)).create());
                        menu.table.add(numberTable).row();
                        menu.show(null, 0.0f, 0.0f, 0.0f, 0.0f, true);
                    }
                } else {
                    if (PlayerRow.this.turnComplete) {
                        PlayerRow.this.turnEndRevert();
                    } else {
                        PlayerRow.this.turnEnd(false);
                    }
                    App.state.changed();
                }
            }
        });
        this.setTouchable(Touchable.enabled);
        this.addListener(new ClickListener(){

            @Override
            public void clicked(InputEvent event, float x, float y) {
                if (!this.inTapSquare(x, y) || x < 200.0f || y > 152.0f) {
                    return;
                }
                App.gloom.rowsScroll.scrollTo(0.0f, PlayerRow.this.getY() - 7.0f, 0.0f, PlayerRow.this.getHeight() + 14.0f);
                PlayerRow.this.menu.show(null, 0.0f, 0.0f, 0.0f, 0.0f, true);
                PlayerRow.this.hpAdjust.changeContainer.clearActions();
                PlayerRow.this.hpAdjust.changeContainer.setVisible(false);
                PlayerRow.this.xpAdjust.changeContainer.clearActions();
                PlayerRow.this.xpAdjust.changeContainer.setVisible(false);
            }
        });
        this.hpAdjust = new HPAdjust((Actor)this, "plainExtraLargeOutlineNumbers"){

            @Override
            public boolean touchDown(InputEvent event, float x, float y, int pointer, int button) {
                if (x < 200.0f) {
                    return false;
                }
                if (x >= 780.0f) {
                    return false;
                }
                return super.touchDown(event, x, y, pointer, button);
            }

            @Override
            protected void getPosition(Vector2 position) {
                PlayerRow.this.hpLabel.localToStageCoordinates(position.set(PlayerRow.this.hpLabel.getWidth() + 3.0f, -5.0f));
            }

            @Override
            protected int getMax() {
                return PlayerRow.this.player.hpMax;
            }

            @Override
            protected int getValue() {
                return PlayerRow.this.player.hp;
            }

            @Override
            protected void setValue(int value) {
                if (PlayerRow.this.player.hp != value) {
                    PlayerRow.this.hpChanged(value + this.extra - this.start);
                }
                PlayerRow.this.player.hp = value;
                if (value > 0) {
                    App.state.changed();
                }
                super.setValue(value);
            }

            @Override
            protected void apply() {
                App.state.changed();
            }
        };
        this.xpAdjust = new HPAdjust((Actor)this, "plainExtraLargeOutlineNumbers"){

            @Override
            public boolean touchDown(InputEvent event, float x, float y, int pointer, int button) {
                if (x < 780.0f) {
                    return false;
                }
                return super.touchDown(event, x, y, pointer, button);
            }

            @Override
            protected void getPosition(Vector2 position) {
                PlayerRow.this.xpLabel.localToStageCoordinates(position.set(PlayerRow.this.xpLabel.getWidth() + 45.0f, -25.0f));
            }

            @Override
            protected int getValue() {
                return PlayerRow.this.player.xp;
            }

            @Override
            protected void setValue(int value) {
                PlayerRow.this.player.xp = value;
                App.state.changed();
                super.setValue(value);
            }
        };
        this.initListener = new DragAdjust(null, new Actor[]{this.dragArea}){

            @Override
            public boolean touchDown(InputEvent event, float x, float y, int pointer, int button) {
                if (App.state.playerInit != PlayerInit.dragNumber && App.state.playerInit != PlayerInit.dragNumberRequired) {
                    return false;
                }
                return super.touchDown(event, x, y, pointer, button);
            }

            @Override
            public void touchDragged(InputEvent event, float x, float y, int pointer) {
                super.touchDragged(event, x, this.getTouchDownY(), pointer);
            }

            @Override
            public void dragStart(InputEvent event, float x, float y, int pointer) {
                App.stage.cancelTouchFocusExcept(PlayerRow.this.initListener, PlayerRow.this.dragArea);
                PlayerRow.this.player.init(1);
                localInit.add(PlayerRow.this.player.characterClass);
                super.dragStart(event, x, y, pointer);
            }

            @Override
            public void dragStop(InputEvent event, float x, float y, int pointer) {
                super.dragStop(event, x, y, pointer);
                if (!App.state.canDraw) {
                    PlayerRow.this.setZIndex(99999);
                    SnapshotArray<Actor> children = App.gloom.rows.getChildren();
                    int i = 0;
                    int n = children.size;
                    while (i < n) {
                        int init;
                        Row row = (Row)children.get(i);
                        if (row != PlayerRow.this && (init = row.getInitiative()) >= 1 && init <= 99 && init >= PlayerRow.this.player.init) {
                            PlayerRow.this.setZIndex(i);
                            break;
                        }
                        ++i;
                    }
                }
                App.state.changed();
                if (!App.state.canDraw) {
                    Animator.storeChildren(App.gloom.rows, 0.1f);
                }
            }

            @Override
            protected int getValue() {
                return PlayerRow.this.player.init;
            }

            @Override
            protected void setValue(int value) {
                PlayerRow.this.player.init(value);
            }

            @Override
            protected int getMax() {
                return 99;
            }

            @Override
            protected int amount(float x, float y) {
                return Math.round(x / 9.0f);
            }
        };
        this.initListener.min = 1;
        this.addSummonButton.addListener(new InputListener(){

            @Override
            public boolean touchDown(InputEvent event, float x, float y, int pointer, int button) {
                event.stop();
                return super.touchDown(event, x, y, pointer, button);
            }
        });
        this.addSummonButton.addListener(new ChangeListener(){

            @Override
            public void changed(ChangeListener.ChangeEvent event, Actor actor) {
                SummonAddMenu menu = new SummonAddMenu(PlayerRow.this);
                menu.show(PlayerRow.this.addSummonButton, 19.0f, -22.0f, -41.0f, 22.0f, true);
            }
        });
    }

    @Override
    public void act(float delta) {
        super.act(delta);
        this.readyTime -= delta;
        this.hpPercent = App.animate(this.hpPercent, Math.min(1.0f, (float)this.player.hp / (float)this.player.hpMax), 0.2f, 2.0f, 2.0f, delta);
        this.summonAlpha = App.animate(this.summonAlpha, this.boxes.size != 0 ? 1 : 0, 0.2f, 2.0f, 2.0f, delta);
        if (!App.state.ignoreChanges) {
            float target = 0.0f;
            if (App.state.canDraw && this.isAlive()) {
                if ((App.state.playerInit == PlayerInit.numpad || App.state.playerInit == PlayerInit.dragNumberRequired) && this.player.init == 0) {
                    target = 1.0f;
                }
            } else if (this.isCurrentTurn()) {
                target = 1.0f;
            }
            this.glowAlpha = App.animate(this.glowAlpha, target, 0.2f, 2.0f, 2.0f, delta);
        }
        this.nameLabel.setText(this.player.name);
    }

    @Override
    public void draw(Batch batch, float a) {
        boolean showInit;
        int init = this.getInitiative();
        boolean bl = showInit = App.state.playerInit != PlayerInit.dragOrder && init > 0 && init < 100;
        if (showInit) {
            if (this.leftInfo.getPadLeft() == 0.0f) {
                this.leftInfo.padLeft(53.0f).invalidate();
                this.hpAdjust.minX = 252.0f;
            }
        } else if (this.leftInfo.getPadLeft() != 0.0f) {
            this.leftInfo.padLeft(0.0f).invalidate();
            this.hpAdjust.minX = 199.0f;
        }
        int hpMax = this.player.hpMax;
        this.hpLabel.setColor(App.c(Color.WHITE, a));
        this.hpLabel.setText(String.valueOf(this.player.hp) + "/" + hpMax);
        this.lootLabel.setText(this.player.loot);
        this.xpLabel.setText(this.player.xp);
        super.draw(batch, a);
        float x = this.getX();
        float y = this.getY();
        if (showInit) {
            batch.setColor(1.0f, 1.0f, 1.0f, a);
            batch.draw(this.initRegion, x + 188.0f, y + 97.0f);
            App.fancyExtraLargeOutlineNumbers.setColor(1.0f, 1.0f, 1.0f, a);
            boolean canHideInit = App.state.canDraw && this.player.characterClass != CharacterClass.Escort && this.player.characterClass != CharacterClass.Objective && (App.config.client && Network.clientRunning() && Network.clientIsConnected() || App.config.server && Network.serverRunning() && Network.serverHasClient());
            String initString = !canHideInit || localInit.contains(this.player.characterClass) ? this.player.initString : "??";
            App.fancyExtraLargeOutlineNumbers.draw(batch, initString, x + 202.0f, y + 89.0f, 0.0f, 1, false);
        }
        x += this.hpLabel.localToAscendantCoordinates((Actor)this, (Vector2)App.v2.set((float)this.hpLabel.getWidth(), (float)0.0f)).x + 18.0f;
        if (this.player.conditions.size > 0) {
            float space = 42.0f;
            if (this.player.conditions.size == 6) {
                space = 41.0f;
            } else if (this.player.conditions.size == 7) {
                x -= 5.0f;
                space = 36.0f;
            } else if (this.player.conditions.size > 7) {
                space = 31.0f;
                x -= 8.0f;
            }
            batch.setColor(App.c.set(1.0f, 1.0f, 1.0f, a));
            int i = 0;
            int last = this.player.conditions.size - 1;
            while (i <= last) {
                Condition condition = this.player.conditions.get(last - i);
                condition.drawable.draw(batch, x + (float)i * space, y + 29.0f, 34.0f, 34.0f);
                ++i;
            }
        }
        x = this.getX();
        if (this.summonAlpha != 0.0f) {
            batch.setColor(1.0f, 1.0f, 1.0f, this.summonAlpha * a);
            this.iconDrawable.draw(batch, x + 115.0f, y + this.getHeight() - 93.0f, 97.0f, 97.0f);
        }
        if (this.glowAlpha != 0.0f) {
            batch.setColor(1.0f, 1.0f, 1.0f, this.glowAlpha * a);
            this.glowDrawable.draw(batch, x + 24.0f, y + 2.0f, 156.0f, 142.0f);
        }
        this.endDesat(batch);
        float deadFade = MathUtils.clamp(this.hpPercent / (1.0f / (float)hpMax), 0.0f, 1.0f);
        batch.setColor(App.c(0x37373788, 0.533f * deadFade * a));
        this.hpRegion.setRegionWidth(117);
        batch.draw(this.hpRegion, x + 43.0f, y + 21.0f);
        if (this.hpPercent > 0.0f) {
            int hp = this.player.hp;
            batch.setColor(App.c(hp <= 3 && this.hpPercent <= 0.4f && hp != hpMax || this.hpPercent < 0.3f ? App.healthRed : App.healthGreen, a));
            this.hpRegion.setRegionWidth((int)Math.max(14.0f * deadFade, (float)Math.round(117.0f * this.hpPercent)));
            batch.draw(this.hpRegion, x + 43.0f, y + 21.0f);
        }
        batch.setColor(1.0f, 1.0f, 1.0f, a);
        this.bloodDrawable.draw(batch, x + this.leftInfo.getPadLeft() + 197.0f, y + 32.0f, 18.0f, 25.0f);
    }

    @Override
    public float desat() {
        if (!this.isAlive()) {
            return 1.0f;
        }
        return super.desat();
    }

    @Override
    protected void setParent(Group parent) {
        super.setParent(parent);
        if (parent == null) {
            this.hpAdjust.changeContainer.remove();
            this.xpAdjust.changeContainer.remove();
        } else {
            App.stage.addActor(this.hpAdjust.changeContainer);
            App.stage.addActor(this.xpAdjust.changeContainer);
        }
    }

    @Override
    public int getInitiative() {
        return this.isAlive() ? this.player.init : 102;
    }

    @Override
    public void turnStart(boolean endOfRound) {
        super.turnStart(endOfRound);
        Array<String> names = new Array<String>(2);
        if (this.player.conditions.contains(Condition.regenerate, true)) {
            names.add("regenerate");
        }
        if (this.player.conditions.contains(Condition.wound, true)) {
            names.add("wound");
        }
        this.flashIcons(names);
    }

    @Override
    public void turnEnd(boolean endOfRound) {
        if (this.turnComplete) {
            return;
        }
        super.turnEnd(endOfRound);
        if (this.isAlive() && App.state.expireConditions) {
            int i = this.player.conditions.size - 1;
            while (i >= 0) {
                Condition condition = this.player.conditions.get(i);
                switch (condition) {
                    case stun: 
                    case immobilize: 
                    case disarm: 
                    case muddle: 
                    case strengthen: 
                    case invisible: {
                        if (this.player.currentTurnConditions.contains(condition, true)) break;
                        this.player.conditions.removeIndex(i);
                        this.player.expiredConditions.add(condition);
                    }
                }
                --i;
            }
        }
    }

    @Override
    public void turnEndRevert() {
        if (!this.turnComplete) {
            return;
        }
        super.turnEndRevert();
        Array<String> names = new Array<String>(2);
        if (this.player.conditions.contains(Condition.regenerate, true)) {
            names.add("regenerate");
        }
        if (this.player.conditions.contains(Condition.wound, true)) {
            names.add("wound");
        }
        this.flashIcons(names);
        this.player.conditions.addAll(this.player.expiredConditions);
        this.player.conditions.sort();
        this.player.expiredConditions.clear();
    }

    @Override
    public void roundEnd() {
        this.player.expiredConditions.clear();
        this.player.currentTurnConditions.clear();
        if (this.player.characterClass != CharacterClass.Escort && this.player.characterClass != CharacterClass.Objective) {
            this.player.init(0);
        }
        super.roundEnd();
    }

    @Override
    public boolean hasExpiringConditions() {
        int i = this.player.conditions.size - 1;
        while (i >= 0) {
            if (this.isAlive()) {
                switch (this.player.conditions.get(i)) {
                    case stun: 
                    case immobilize: 
                    case disarm: 
                    case muddle: 
                    case strengthen: 
                    case invisible: {
                        return true;
                    }
                }
            }
            --i;
        }
        return false;
    }

    @Override
    public boolean isAlive() {
        return this.player.hp > 0 && !this.player.exhausted;
    }

    void hpChanged(int amount) {
        long time = System.currentTimeMillis();
        if (time > this.lastAnimateIcon + 1000L) {
            this.lastAnimateIcon = time;
            boolean poison = this.player.conditions.contains(Condition.poison, true);
            if (amount < 0) {
                if (poison) {
                    this.flashIcon("poison");
                }
            } else if (amount > 0) {
                boolean wound = this.player.conditions.contains(Condition.wound, true);
                if (poison && wound) {
                    this.flashIcon("poison");
                    this.addAction(Actions.sequence((Action)Actions.delay(0.4f), new Action(){

                        @Override
                        public boolean act(float delta) {
                            PlayerRow.this.flashIcon("wound");
                            return true;
                        }
                    }));
                } else if (poison) {
                    this.flashIcon("poison");
                } else if (wound) {
                    this.flashIcon("wound");
                }
            }
        }
    }

    public void flashIcons(Array<String> names) {
        int i = 0;
        int n = names.size;
        while (i < n) {
            final String name = names.get(i);
            if (i > 0) {
                this.addAction(Actions.sequence((Action)Actions.delay((float)i * 0.4f), new Action(){

                    @Override
                    public boolean act(float delta) {
                        PlayerRow.this.flashIcon(name);
                        return true;
                    }
                }));
            } else {
                this.flashIcon(name);
            }
            ++i;
        }
    }

    public void flashIcon(String name) {
        this.animateIcon(this.dragArea, "conditions/" + name + "-large", 2.0f, 105.0f, this.dragArea.getHeight() / 2.0f);
    }

    @Override
    public void setLevel(int level) {
        this.player.level = level;
        int oldMax = this.player.hpMax;
        this.player.hpMax = this.player.characterClass.hpMax(level);
        if (this.player.hp >= oldMax) {
            this.player.hp = this.player.hpMax;
        }
        for (MonsterBox box : this.boxes) {
            Monster monster = box.monster;
            oldMax = monster.hpMax;
            if (monster.summonColor == SummonColor.beast) {
                monster.hp = box.monster.hpMax = 8 + this.player.level * 2;
                continue;
            }
            monster.hpMax = monster.stats.hpMax();
            if (monster.hp < oldMax && oldMax != 0) continue;
            monster.hp = monster.hpMax;
        }
        App.state.changed();
    }

    @Override
    public int getLevel() {
        return this.player.level;
    }

    @Override
    public float getPrefHeight() {
        if (animatedHeight && Animator.enabled && this.animateHeight != 0.0f) {
            return this.animateHeight;
        }
        return super.getPrefHeight();
    }

    @Override
    public String toString() {
        String name = this.player.name;
        if (!name.equals(this.player.characterClass.toString())) {
            name = String.valueOf(name) + " (" + this.player.characterClass.name() + ")";
        }
        return name;
    }
}

