/*
 * Decompiled with CFR 0.152.
 */
package com.esotericsoftware.gloomhavenhelper.util;

import com.badlogic.gdx.graphics.g2d.Batch;
import com.badlogic.gdx.graphics.g2d.NinePatch;
import com.badlogic.gdx.graphics.g2d.TextureRegion;
import com.badlogic.gdx.math.Interpolation;
import com.badlogic.gdx.math.MathUtils;
import com.badlogic.gdx.math.Vector2;
import com.badlogic.gdx.scenes.scene2d.Action;
import com.badlogic.gdx.scenes.scene2d.Actor;
import com.badlogic.gdx.scenes.scene2d.Event;
import com.badlogic.gdx.scenes.scene2d.Group;
import com.badlogic.gdx.scenes.scene2d.InputEvent;
import com.badlogic.gdx.scenes.scene2d.InputListener;
import com.badlogic.gdx.scenes.scene2d.Touchable;
import com.badlogic.gdx.scenes.scene2d.actions.Actions;
import com.badlogic.gdx.scenes.scene2d.actions.FloatAction;
import com.badlogic.gdx.scenes.scene2d.ui.Button;
import com.badlogic.gdx.scenes.scene2d.ui.Table;
import com.badlogic.gdx.scenes.scene2d.utils.TiledDrawable;
import com.esotericsoftware.gloomhavenhelper.App;
import com.esotericsoftware.gloomhavenhelper.util.Animator;

public class Menu
extends Table {
    public static int menusShown;
    private final TextureRegion vignette;
    private final TextureRegion arrow;
    private final TextureRegion corner;
    private final TextureRegion white;
    private final NinePatch dimCorners;
    private final TiledDrawable bg;
    private final TiledDrawable top;
    private final TiledDrawable bottom;
    private final TiledDrawable left;
    private final TiledDrawable right;
    private boolean hidden;
    private float arrowX;
    private float arrowY;
    public boolean arrowFlip;
    public boolean showArrow = true;
    private Actor positionActor;
    private float positionX;
    private float positionY;
    private float positionWidth;
    private float positionHeight;
    public boolean preferRight;
    private FloatAction bgAlpha;
    private float bgX;
    private float bgY;
    private float bgWidth;
    private float bgHeight;
    public float bgOffsetX;
    public float bgOffsetY;
    public float bgOffsetWidth;
    public float bgOffsetHeight;
    public boolean animate = true;
    public boolean autoHide = true;
    final InputListener hideListener = new InputListener(){

        @Override
        public boolean handle(Event event) {
            if (!(event instanceof InputEvent)) {
                return false;
            }
            if (Menu.this.isAscendantOf(event.getTarget())) {
                return false;
            }
            InputEvent inputEvent = (InputEvent)event;
            if (inputEvent.getType() == InputEvent.Type.touchDown) {
                Menu.this.hide();
            }
            event.cancel();
            return true;
        }
    };

    public Menu() {
        super(App.skin);
        this.vignette = App.skin.getRegion("menu/vignette");
        this.arrow = App.skin.getRegion("menu/arrow");
        this.corner = App.skin.getRegion("menu/corner");
        this.white = App.skin.getRegion("white");
        this.dimCorners = App.skin.getPatch("dim-corners");
        this.bg = App.skin.getTiledDrawable("menu/bg");
        this.top = App.skin.getTiledDrawable("menu/top");
        this.bottom = App.skin.getTiledDrawable("menu/bottom");
        this.left = App.skin.getTiledDrawable("menu/left");
        this.right = App.skin.getTiledDrawable("menu/right");
        this.setTransform(true);
        this.pad(12.0f);
    }

    @Override
    public void draw(Batch batch, float parentAlpha) {
        if (this.bgAlpha != null) {
            if (!this.hidden) {
                this.updatePosition();
            }
            batch.setColor(0.0f, 0.0f, 0.0f, 0.5f * this.bgAlpha.getValue() * this.getColor().a);
            batch.draw(this.white, 0.0f, 0.0f, App.stage.getWidth(), this.bgY);
            batch.draw(this.white, 0.0f, this.bgY + this.bgHeight, App.stage.getWidth(), App.stage.getHeight() - (this.bgY + this.bgHeight));
            batch.draw(this.white, 0.0f, this.bgY, this.bgX, this.bgHeight);
            batch.draw(this.white, this.bgX + this.bgWidth, this.bgY, App.stage.getWidth() - (this.bgX + this.bgWidth), this.bgHeight);
            this.dimCorners.draw(batch, this.bgX, this.bgY, this.bgWidth, this.bgHeight);
        }
        super.draw(batch, parentAlpha);
    }

    @Override
    protected void drawBackground(Batch batch, float parentAlpha, float x, float y) {
        float w = this.getWidth() - 18.0f;
        float h = this.getHeight() - 18.0f;
        batch.setColor(1.0f, 1.0f, 1.0f, this.getColor().a * parentAlpha);
        this.bg.draw(batch, x += 9.0f, y += 9.0f, w, h);
        batch.draw(this.vignette, x, y, w, h);
    }

    @Override
    protected void drawChildren(Batch batch, float parentAlpha) {
        super.drawChildren(batch, parentAlpha);
        float w = this.getWidth();
        float h = this.getHeight();
        batch.setColor(1.0f, 1.0f, 1.0f, this.getColor().a * parentAlpha);
        if (this.showArrow) {
            if (this.arrowFlip) {
                batch.draw(this.arrow.getTexture(), this.arrowX, this.arrowY, this.arrow.getRegionWidth(), this.arrow.getRegionHeight(), this.arrow.getU2(), this.arrow.getV2(), this.arrow.getU(), this.arrow.getV());
            } else {
                batch.draw(this.arrow, this.arrowX, this.arrowY);
            }
        }
        this.bottom.draw(batch, 0.0f, 0.0f, w, 21.0f);
        this.top.draw(batch, 0.0f, h - 17.0f, w, 17.0f);
        this.left.draw(batch, 0.0f, 0.0f, 21.0f, h);
        this.right.draw(batch, w - 18.0f, 0.0f, 18.0f, h);
        float x = -5.0f;
        float y = -5.0f;
        w -= 27.0f;
        batch.draw(this.corner, x, y + (h -= 27.0f));
        float u = this.corner.getU();
        float v = this.corner.getV();
        float u2 = this.corner.getU2();
        float v2 = this.corner.getV2();
        batch.draw(this.corner.getTexture(), x + w, y + h, 37.0f, 37.0f, u2, v2, u, v);
        batch.draw(this.corner.getTexture(), x + w, y, 37.0f, 37.0f, u2, v, u, v2);
        batch.draw(this.corner.getTexture(), x, y, 37.0f, 37.0f, u, v, u2, v2);
    }

    public void setBackgroundOffset(float bgOffsetX, float bgOffsetY, float bgOffsetWidth, float bgOffsetHeight) {
        this.bgOffsetX = bgOffsetX;
        this.bgOffsetY = bgOffsetY;
        this.bgOffsetWidth = bgOffsetWidth;
        this.bgOffsetHeight = bgOffsetHeight;
    }

    public void setPosition(float positionX, float positionY, float positionWidth, float positionHeight, float bgX, float bgY, float bgWidth, float bgHeight) {
        this.positionX = positionX;
        this.positionY = positionY;
        this.positionWidth = positionWidth;
        this.positionHeight = positionHeight;
        this.bgX = bgX;
        this.bgY = bgY;
        this.bgWidth = bgWidth;
        this.bgHeight = bgHeight;
    }

    protected void updatePosition() {
        boolean right;
        float h;
        float w;
        float y;
        float x;
        float width = this.getPrefWidth();
        float height = this.getPrefHeight();
        if (width > App.stage.getWidth() - 18.0f) {
            width = App.stage.getWidth() - 18.0f;
        }
        if (height > App.stage.getHeight() - 18.0f) {
            height = App.stage.getHeight() - 18.0f;
        }
        if (this.positionActor != null && this.positionActor.getParent() != null) {
            float px = this.positionActor.getX();
            float py = this.positionActor.getY();
            if (this.positionActor instanceof Animator.HasAnimator) {
                Animator animator = ((Animator.HasAnimator)((Object)this.positionActor)).getAnimator();
                if (animator.animating) {
                    px = animator.target.x;
                    py = animator.target.y;
                }
            }
            Vector2 temp = this.positionActor.getParent().localToStageCoordinates(App.v2.set(px + this.bgOffsetX, py + this.bgOffsetY));
            this.bgX = temp.x;
            this.bgY = temp.y;
            this.positionActor.getParent().localToStageCoordinates(temp.set(px + this.positionActor.getWidth() + this.bgOffsetWidth, py + this.positionActor.getHeight() + this.bgOffsetHeight)).sub(this.bgX, this.bgY);
            this.bgWidth = temp.x;
            this.bgHeight = temp.y;
            temp = this.positionActor.getParent().localToStageCoordinates(App.v2.set(px + this.positionX, py + this.positionY));
            x = temp.x;
            y = temp.y;
            temp = this.positionActor.getParent().localToStageCoordinates(App.v2.set(px + this.positionActor.getWidth() + this.positionWidth, py + this.positionActor.getHeight() + this.positionHeight)).sub(x, y);
            w = temp.x;
            h = temp.y;
        } else {
            x = this.positionX;
            y = this.positionY;
            w = this.positionWidth;
            h = this.positionHeight;
        }
        y += (float)Math.round(h / 2.0f);
        float screenEdgeSpace = 10.0f;
        float arrowWidth = 44.0f;
        float arrowBottomToTip = 50.0f;
        float arrowTopToTip = 29.0f;
        float arrowTipToCorner = 67.0f;
        float leftRemaining = x - arrowWidth - width;
        float rightRemaining = App.stage.getWidth() - x - w - arrowWidth - width;
        float bottomRemaining = y - height / 2.0f;
        float topRemaining = App.stage.getHeight() - (y + height);
        if (leftRemaining < 0.0f && rightRemaining < 0.0f) {
            right = rightRemaining > leftRemaining;
        } else {
            boolean bl = right = this.preferRight && rightRemaining >= 0.0f || !this.preferRight && leftRemaining < 0.0f;
        }
        boolean bottom = topRemaining < 0.0f && bottomRemaining < 0.0f ? bottomRemaining > topRemaining : bottomRemaining >= 0.0f;
        bottom = true;
        right = this.dir(right);
        this.arrowFlip = !right;
        this.arrowX = right ? x + w : x - arrowWidth;
        this.arrowY = y - arrowBottomToTip;
        this.arrowX = MathUtils.clamp(this.arrowX, right ? 0.0f : screenEdgeSpace + width, App.stage.getWidth() - 44.0f);
        this.arrowY = MathUtils.clamp(this.arrowY, -24.0f + screenEdgeSpace, App.stage.getHeight() - screenEdgeSpace);
        x = right ? this.arrowX + arrowWidth : this.arrowX - width;
        y = bottom ? this.arrowY + arrowBottomToTip + arrowTipToCorner - height : this.arrowY + arrowBottomToTip - arrowTipToCorner;
        x = MathUtils.clamp(x, screenEdgeSpace, App.stage.getWidth() - width - screenEdgeSpace);
        y = MathUtils.clamp(y, screenEdgeSpace, App.stage.getHeight() - height - screenEdgeSpace);
        this.arrowX = right ? -arrowWidth : width;
        this.arrowY -= y;
        if (this.arrowY < 10.0f) {
            this.arrowY = 10.0f;
        }
        this.setBounds(x, y, width, height);
        this.setOrigin(right ? this.arrowX : this.arrowX + arrowWidth, this.arrowY + arrowBottomToTip);
        this.arrowY = MathUtils.clamp(this.arrowY, 5.0f, height - 87.0f);
    }

    protected boolean dir(boolean right) {
        return right;
    }

    public boolean show(Menu menu) {
        boolean shown = this.show(menu.positionActor, menu.positionX, menu.positionY, menu.positionWidth, menu.positionHeight, menu.preferRight);
        this.bgX = menu.bgX;
        this.bgY = menu.bgY;
        this.bgWidth = menu.bgWidth;
        this.bgHeight = menu.bgHeight;
        this.setBackgroundOffset(menu.bgOffsetX, menu.bgOffsetY, menu.bgOffsetWidth, menu.bgOffsetHeight);
        return shown;
    }

    public boolean show(Actor positionActor, float positionX, float positionY, float positionWidth, float positionHeight, boolean preferRight) {
        this.setTouchable(Touchable.enabled);
        this.pack();
        this.positionActor = positionActor;
        this.positionX = positionX;
        this.positionY = positionY;
        this.positionWidth = positionWidth;
        this.positionHeight = positionHeight;
        this.preferRight = preferRight;
        this.updatePosition();
        if (positionActor instanceof Button) {
            ((Button)positionActor).setChecked(true);
        }
        if (!this.hasParent()) {
            this.hidden = true;
        }
        if (!this.hidden) {
            return false;
        }
        this.hidden = false;
        this.clearActions();
        App.stage.mouseMoved(Integer.MAX_VALUE, Integer.MAX_VALUE);
        App.stage.act(0.0f);
        App.stage.setKeyboardFocus(this);
        if (this.autoHide) {
            App.stage.addCaptureListener(this.hideListener);
        }
        App.stage.addActor(this);
        this.getColor().a = 1.0f;
        if (this.animate) {
            this.setScale(0.0f, 0.0f);
            this.addAction(Actions.scaleTo(1.0f, 1.0f, 0.2f, Interpolation.fastSlow));
            this.bgAlpha = new FloatAction(0.0f, 1.0f, 0.2f, Interpolation.slowFast);
            this.addAction(this.bgAlpha);
        } else {
            this.setScale(1.0f, 1.0f);
            this.bgAlpha = new FloatAction(1.0f, 1.0f, 0.0f);
            this.bgAlpha.act(0.0f);
        }
        ++menusShown;
        return true;
    }

    public boolean hide() {
        if (this.positionActor instanceof Button) {
            ((Button)this.positionActor).setChecked(false);
        }
        App.stage.removeCaptureListener(this.hideListener);
        App.stage.setScrollFocus(App.gloom.rowsScroll);
        this.setTouchable(Touchable.disabled);
        if (this.hidden) {
            return false;
        }
        this.hidden = true;
        if (!this.hasParent()) {
            return false;
        }
        --menusShown;
        this.clearActions();
        if (this.animate) {
            float time = 0.35f;
            this.addAction(Actions.sequence((Action)Actions.parallel((Action)Actions.fadeOut(time, Interpolation.fastSlow), (Action)Actions.moveTo(this.getX(), this.getY() - 50.0f, time, Interpolation.fastSlow)), (Action)Actions.removeActor()));
        } else {
            this.remove();
        }
        return true;
    }

    @Override
    protected void setParent(Group parent) {
        if (parent == null) {
            App.stage.removeCaptureListener(this.hideListener);
        }
        super.setParent(parent);
    }
}

