/*
 * Decompiled with CFR 0.152.
 */
package com.esotericsoftware.gloomhavenhelper;

import com.badlogic.gdx.graphics.Color;
import com.badlogic.gdx.scenes.scene2d.Actor;
import com.badlogic.gdx.scenes.scene2d.Touchable;
import com.badlogic.gdx.scenes.scene2d.ui.Container;
import com.badlogic.gdx.scenes.scene2d.ui.ImageButton;
import com.badlogic.gdx.scenes.scene2d.ui.Label;
import com.badlogic.gdx.scenes.scene2d.ui.Stack;
import com.badlogic.gdx.scenes.scene2d.utils.ChangeListener;
import com.esotericsoftware.gloomhavenhelper.App;
import com.esotericsoftware.gloomhavenhelper.MonsterRow;
import com.esotericsoftware.gloomhavenhelper.model.AttackModifier;
import com.esotericsoftware.gloomhavenhelper.util.Menu;
import com.esotericsoftware.gloomhavenhelper.util.builders.ImageButtonBuilder;

public class MonsterBlessCurseMenu
extends Menu {
    final MonsterRow row;
    private ImageButton blessPlusButton;
    private ImageButton blessMinusButton;
    private ImageButton cursePlusButton;
    private ImageButton curseMinusButton;
    Label blessLabel;
    Label curseLabel;

    public MonsterBlessCurseMenu(MonsterRow row) {
        this.row = row;
        this.create();
        this.layoutUI();
        this.events();
        this.setBackgroundOffset(-4.0f, -2.0f, 898.0f, 5.0f);
    }

    private void create() {
        ImageButtonBuilder sub = App.imageButton().imageUp("psd/sub", App.buttonGray).imageOver("psd/sub").imageDisabled("psd/sub", App.disabledGray);
        ImageButtonBuilder add = App.imageButton().imageUp("psd/add", App.buttonGray).imageOver("psd/add").imageDisabled("psd/add", App.disabledGray);
        this.blessMinusButton = sub.create();
        this.blessPlusButton = add.create();
        this.curseMinusButton = sub.create();
        this.cursePlusButton = add.create();
        this.blessLabel = new Label((CharSequence)"", App.skin, "plainMediumOutlineFixedNumbers", Color.WHITE);
        this.blessLabel.setTouchable(Touchable.disabled);
        this.curseLabel = new Label((CharSequence)"", App.skin, "plainMediumOutlineFixedNumbers", Color.WHITE);
        this.curseLabel.setTouchable(Touchable.disabled);
    }

    private void layoutUI() {
        this.columnDefaults(0).size(100.0f);
        this.columnDefaults(1).fill();
        this.columnDefaults(2).size(100.0f);
        this.add(this.blessMinusButton);
        this.add(new Stack(App.image("bless-large"), new Container<Label>(this.blessLabel).pad(0.0f, 0.0f, -48.0f, -44.0f)));
        this.add(this.blessPlusButton).row();
        this.add(this.curseMinusButton);
        this.add(new Stack(App.image("curse-large"), new Container<Label>(this.curseLabel).pad(0.0f, 0.0f, -48.0f, -44.0f)));
        this.add(this.cursePlusButton).row();
    }

    private void events() {
        this.blessPlusButton.addListener(new ChangeListener(){

            @Override
            public void changed(ChangeListener.ChangeEvent event, Actor actor) {
                if (App.state.count(AttackModifier.bless, false) >= 10) {
                    return;
                }
                int bless = App.parseInt(MonsterBlessCurseMenu.this.blessLabel.getText().toString()) + 1;
                MonsterBlessCurseMenu.this.blessLabel.setText("" + bless);
                App.state.add(AttackModifier.bless);
                App.state.attackModifiers.shuffle();
            }
        });
        this.blessMinusButton.addListener(new ChangeListener(){

            @Override
            public void changed(ChangeListener.ChangeEvent event, Actor actor) {
                if (App.state.count(AttackModifier.bless, false) == 0) {
                    return;
                }
                int bless = Math.max(0, App.parseInt(MonsterBlessCurseMenu.this.blessLabel.getText().toString()) - 1);
                MonsterBlessCurseMenu.this.blessLabel.setText("" + bless);
                App.state.remove(AttackModifier.bless);
                App.state.attackModifiers.shuffle();
            }
        });
        this.cursePlusButton.addListener(new ChangeListener(){

            @Override
            public void changed(ChangeListener.ChangeEvent event, Actor actor) {
                if (App.state.count(AttackModifier.curse, false) >= 10) {
                    return;
                }
                int curse = App.parseInt(MonsterBlessCurseMenu.this.curseLabel.getText().toString()) + 1;
                MonsterBlessCurseMenu.this.curseLabel.setText("" + curse);
                App.state.addCurse();
                App.state.attackModifiers.shuffle();
            }
        });
        this.curseMinusButton.addListener(new ChangeListener(){

            @Override
            public void changed(ChangeListener.ChangeEvent event, Actor actor) {
                if (App.state.count(AttackModifier.curse, false) == 0) {
                    return;
                }
                int curse = Math.max(0, App.parseInt(MonsterBlessCurseMenu.this.curseLabel.getText().toString()) - 1);
                MonsterBlessCurseMenu.this.curseLabel.setText("" + curse);
                App.state.remove(AttackModifier.curse);
                App.state.attackModifiers.shuffle();
            }
        });
    }

    @Override
    public boolean show(Actor positionActor, float positionX, float positionY, float positionWidth, float positionHeight, boolean preferRight) {
        this.blessLabel.setText(String.valueOf(App.state.count(AttackModifier.bless, false)));
        this.curseLabel.setText(String.valueOf(App.state.count(AttackModifier.curse, false)));
        return super.show(positionActor, positionX, positionY, positionWidth, positionHeight, preferRight);
    }

    @Override
    protected boolean dir(boolean right) {
        return true;
    }

    @Override
    public void setPosition(float positionX, float positionY, float positionWidth, float positionHeight, float bgX, float bgY, float bgWidth, float bgHeight) {
        super.setPosition(positionX, positionY, positionWidth, positionHeight, bgX, bgY, bgWidth, bgHeight);
    }

    @Override
    public boolean hide() {
        super.hide();
        App.state.changed();
        return true;
    }

    @Override
    public void act(float delta) {
        super.act(delta);
        int blesses = App.state.count(AttackModifier.bless, false);
        this.blessMinusButton.setDisabled(blesses <= 0);
        this.blessPlusButton.setDisabled(blesses >= 10);
        int curses = App.state.count(AttackModifier.curse, false);
        this.curseMinusButton.setDisabled(curses <= 0);
        this.cursePlusButton.setDisabled(curses >= 10);
    }
}

