/*
 * Decompiled with CFR 0.152.
 */
package ghidra.util.datastruct;

import java.lang.ref.ReferenceQueue;
import java.lang.ref.WeakReference;
import java.util.AbstractCollection;
import java.util.AbstractSet;
import java.util.Collection;
import java.util.Iterator;
import java.util.Map;
import java.util.NoSuchElementException;
import java.util.Objects;
import java.util.Set;

public abstract class AbstractWeakValueMap<K, V>
implements Map<K, V> {
    protected ReferenceQueue<V> refQueue = new ReferenceQueue();

    protected AbstractWeakValueMap() {
    }

    protected abstract Map<K, WeakValueRef<K, V>> getRefMap();

    @Override
    public V put(K key, V value) {
        this.processQueue();
        WeakValueRef<K, V> ref = new WeakValueRef<K, V>(key, value, this.refQueue);
        WeakValueRef<K, V> oldRef = this.getRefMap().put(key, ref);
        if (oldRef != null) {
            return (V)oldRef.get();
        }
        return null;
    }

    @Override
    public V get(Object key) {
        this.processQueue();
        WeakValueRef<K, V> ref = this.getRefMap().get(key);
        if (ref != null) {
            return (V)ref.get();
        }
        return null;
    }

    @Override
    public int size() {
        this.processQueue();
        return this.getRefMap().size();
    }

    @Override
    public void clear() {
        this.getRefMap().clear();
        this.refQueue = new ReferenceQueue();
    }

    @Override
    public boolean isEmpty() {
        this.processQueue();
        return this.getRefMap().isEmpty();
    }

    @Override
    public boolean containsKey(Object key) {
        this.processQueue();
        return this.getRefMap().containsKey(key);
    }

    @Override
    public boolean containsValue(Object value) {
        this.processQueue();
        for (WeakValueRef<K, V> ref : this.getRefMap().values()) {
            if (!value.equals(ref.get())) continue;
            return true;
        }
        return false;
    }

    @Override
    public Collection<V> values() {
        this.processQueue();
        return new WeakValuesCollection();
    }

    @Override
    public void putAll(Map<? extends K, ? extends V> map) {
        for (K key : map.keySet()) {
            V value = map.get(key);
            if (value == null) continue;
            this.put(key, value);
        }
    }

    @Override
    public Set<Map.Entry<K, V>> entrySet() {
        return new EntrySet();
    }

    @Override
    public Set<K> keySet() {
        this.processQueue();
        return this.getRefMap().keySet();
    }

    @Override
    public V remove(Object key) {
        WeakValueRef<K, V> ref = this.getRefMap().remove(key);
        if (ref != null) {
            return (V)ref.get();
        }
        return null;
    }

    protected void processQueue() {
        WeakValueRef ref;
        while ((ref = (WeakValueRef)this.refQueue.poll()) != null) {
            this.getRefMap().remove(ref.key);
        }
    }

    protected static class WeakValueRef<K, V>
    extends WeakReference<V> {
        K key;

        WeakValueRef(K key, V value, ReferenceQueue<V> refQueue) {
            super(value, refQueue);
            this.key = key;
        }
    }

    private class WeakValuesCollection
    extends AbstractCollection<V> {
        private WeakValuesCollection() {
        }

        @Override
        public Iterator<V> iterator() {
            return new WeakValuesIterator();
        }

        @Override
        public int size() {
            return AbstractWeakValueMap.this.size();
        }
    }

    private class EntrySet
    extends AbstractSet<Map.Entry<K, V>> {
        private EntrySet() {
        }

        @Override
        public Iterator<Map.Entry<K, V>> iterator() {
            return new EntryIterator();
        }

        @Override
        public boolean contains(Object o) {
            if (o instanceof Map.Entry) {
                Map.Entry e = (Map.Entry)o;
                Object key = e.getKey();
                Object v = AbstractWeakValueMap.this.get(key);
                return Objects.equals(v, e.getValue());
            }
            return false;
        }

        @Override
        public boolean remove(Object o) {
            Map.Entry e;
            Object key;
            Object v;
            if (o instanceof Map.Entry && Objects.equals(v = AbstractWeakValueMap.this.get(key = (e = (Map.Entry)o).getKey()), e.getValue())) {
                this.remove(key);
                return true;
            }
            return false;
        }

        @Override
        public int size() {
            return AbstractWeakValueMap.this.size();
        }

        @Override
        public void clear() {
            AbstractWeakValueMap.this.clear();
        }
    }

    private class EntryIterator
    implements Iterator<Map.Entry<K, V>> {
        private Iterator<Map.Entry<K, WeakValueRef<K, V>>> refMapIterator;
        private K nextKey;
        private V nextValue;

        public EntryIterator() {
            this.refMapIterator = AbstractWeakValueMap.this.getRefMap().entrySet().iterator();
        }

        @Override
        public boolean hasNext() {
            while (this.nextValue == null && this.refMapIterator.hasNext()) {
                Map.Entry next = this.refMapIterator.next();
                this.nextKey = next.getKey();
                this.nextValue = next.getValue().get();
            }
            return this.nextValue != null;
        }

        @Override
        public Map.Entry<K, V> next() {
            if (!this.hasNext()) {
                throw new NoSuchElementException();
            }
            GeneratedEntry result = new GeneratedEntry(this.nextKey, this.nextValue);
            this.nextKey = null;
            this.nextValue = null;
            return result;
        }

        @Override
        public void remove() {
            this.refMapIterator.remove();
        }
    }

    private class WeakValuesIterator
    implements Iterator<V> {
        private Iterator<Map.Entry<K, WeakValueRef<K, V>>> refMapIterator;
        private V nextValue;

        public WeakValuesIterator() {
            this.refMapIterator = AbstractWeakValueMap.this.getRefMap().entrySet().iterator();
        }

        @Override
        public boolean hasNext() {
            while (this.nextValue == null && this.refMapIterator.hasNext()) {
                Map.Entry next = this.refMapIterator.next();
                this.nextValue = next.getValue().get();
            }
            return this.nextValue != null;
        }

        @Override
        public V next() {
            if (!this.hasNext()) {
                throw new NoSuchElementException();
            }
            Object returnValue = this.nextValue;
            this.nextValue = null;
            return returnValue;
        }

        @Override
        public void remove() {
            this.refMapIterator.remove();
        }
    }

    protected class GeneratedEntry
    implements Map.Entry<K, V> {
        K key;
        V value;

        GeneratedEntry(K key, V value) {
            this.key = key;
            this.value = value;
        }

        @Override
        public K getKey() {
            return this.key;
        }

        @Override
        public V getValue() {
            return this.value;
        }

        @Override
        public V setValue(V value) {
            throw new UnsupportedOperationException();
        }
    }
}

