/*
 * Decompiled with CFR 0.152.
 */
package ghidra.generic.util.datastruct;

import ghidra.generic.util.datastruct.SortedList;
import ghidra.generic.util.datastruct.ValueSortedMap;
import ghidra.util.ReversedListIterator;
import java.lang.reflect.Array;
import java.util.Collection;
import java.util.Comparator;
import java.util.Iterator;
import java.util.List;
import java.util.ListIterator;
import java.util.Map;
import java.util.NoSuchElementException;

public class RestrictedValueSortedMap<K, V>
implements ValueSortedMap<K, V> {
    private final ValueSortedMap<K, V> wrapped;
    private final Comparator<V> comparator;
    private final boolean hasFrom;
    private final V fromValue;
    private final boolean fromInclusive;
    private final boolean hasTo;
    private final V toValue;
    private final boolean toInclusive;

    protected RestrictedValueSortedMap(ValueSortedMap<K, V> wrapped, Comparator<V> comparator, boolean hasFrom, V fromValue, boolean fromInclusive, boolean hasTo, V toValue, boolean toInclusive) {
        int cmp;
        if (hasFrom && hasTo && ((cmp = comparator.compare(fromValue, toValue)) > 0 || cmp == 0 && !fromInclusive && !toInclusive)) {
            throw new IllegalArgumentException("from must be less than to");
        }
        this.wrapped = wrapped;
        this.comparator = comparator;
        this.hasFrom = hasFrom;
        this.fromValue = fromValue;
        this.fromInclusive = fromInclusive;
        this.hasTo = hasTo;
        this.toValue = toValue;
        this.toInclusive = toInclusive;
    }

    protected int getLowestIndex() {
        if (!this.hasFrom) {
            return 0;
        }
        int i = this.fromInclusive ? this.wrapped.values().ceilingIndex(this.fromValue) : this.wrapped.values().higherIndex(this.fromValue);
        if (i == -1) {
            return this.wrapped.size();
        }
        return i;
    }

    protected int getHighestIndexPlusOne() {
        if (!this.hasTo) {
            return this.wrapped.size();
        }
        int i = this.toInclusive ? this.wrapped.values().floorIndex(this.toValue) : this.wrapped.values().lowerIndex(this.toValue);
        if (i == -1) {
            return 0;
        }
        return i;
    }

    @Override
    public int size() {
        return this.restrictedSize();
    }

    protected int inBoundsOrNeg1(int index) {
        if (index == -1) {
            return -1;
        }
        int lowest = this.getLowestIndex();
        if (index < lowest) {
            return -1;
        }
        if (index >= this.getHighestIndexPlusOne()) {
            return -1;
        }
        return index - lowest;
    }

    protected int restrictedSize() {
        int fromIndex = this.getLowestIndex();
        int toIndex = this.getHighestIndexPlusOne();
        return toIndex - fromIndex;
    }

    @Override
    public boolean isEmpty() {
        return this.restrictedIsEmpty();
    }

    protected boolean restrictedIsEmpty() {
        return this.restrictedSize() != 0;
    }

    protected boolean inBounds(V val) {
        int toCmp;
        int fromCmp;
        if (this.hasFrom && ((fromCmp = this.comparator.compare(val, this.fromValue)) < 0 || fromCmp == 0 && !this.fromInclusive)) {
            return false;
        }
        return !this.hasTo || (toCmp = this.comparator.compare(val, this.toValue)) <= 0 && (toCmp != 0 || this.toInclusive);
    }

    protected V inBoundsOrNull(V val) {
        if (!this.inBounds(val)) {
            return null;
        }
        return val;
    }

    protected Map.Entry<K, V> inBoundsOrNull(Map.Entry<K, V> ent) {
        if (!this.inBounds(ent.getValue())) {
            return null;
        }
        return ent;
    }

    @Override
    public boolean containsKey(Object key) {
        if (!this.wrapped.containsKey(key)) {
            return false;
        }
        Object val = this.wrapped.get(key);
        return this.inBounds(val);
    }

    @Override
    public boolean containsValue(Object value) {
        if (!this.inBounds(value)) {
            return false;
        }
        return this.wrapped.containsValue(value);
    }

    @Override
    public V get(Object key) {
        return this.inBoundsOrNull(this.wrapped.get(key));
    }

    @Override
    public V put(K key, V value) {
        throw new UnsupportedOperationException();
    }

    @Override
    public V remove(Object key) {
        throw new UnsupportedOperationException();
    }

    @Override
    public void putAll(Map<? extends K, ? extends V> m) {
        throw new UnsupportedOperationException();
    }

    @Override
    public void clear() {
        throw new UnsupportedOperationException();
    }

    @Override
    public ValueSortedMap.ValueSortedMapEntryList<K, V> entrySet() {
        return new RestrictedValueSortedMapEntryList();
    }

    @Override
    public Map.Entry<K, V> lowerEntryByValue(V value) {
        return this.inBoundsOrNull(this.wrapped.lowerEntryByValue(value));
    }

    @Override
    public Map.Entry<K, V> floorEntryByValue(V value) {
        return this.inBoundsOrNull(this.wrapped.floorEntryByValue(value));
    }

    @Override
    public Map.Entry<K, V> ceilingEntryByValue(V value) {
        return this.inBoundsOrNull(this.wrapped.ceilingEntryByValue(value));
    }

    @Override
    public Map.Entry<K, V> higherEntryByValue(V value) {
        return this.inBoundsOrNull(this.wrapped.higherEntryByValue(value));
    }

    @Override
    public ValueSortedMap<K, V> subMapByValue(V fromValue, boolean fromInclusive, V toValue, boolean toInclusive) {
        if (!this.inBounds(fromValue) || !this.inBounds(toValue)) {
            throw new IllegalArgumentException("Bounds must be within existing bounds");
        }
        return new RestrictedValueSortedMap<K, V>(this.wrapped, this.comparator, true, fromValue, fromInclusive, true, toValue, toInclusive);
    }

    @Override
    public ValueSortedMap<K, V> headMapByValue(V toValue, boolean inclusive) {
        if (!this.inBounds(toValue)) {
            throw new IllegalArgumentException("Bounds must be within existing bounds");
        }
        return new RestrictedValueSortedMap<K, V>(this.wrapped, this.comparator, this.hasFrom, this.fromValue, this.fromInclusive, true, toValue, inclusive);
    }

    @Override
    public ValueSortedMap<K, V> tailMapByValue(V fromValue, boolean inclusive) {
        if (!this.inBounds(fromValue)) {
            throw new IllegalArgumentException("Bounds must be within existing bounds");
        }
        return new RestrictedValueSortedMap<K, V>(this.wrapped, this.comparator, true, fromValue, inclusive, this.hasTo, this.toValue, this.toInclusive);
    }

    @Override
    public ValueSortedMap.ValueSortedMapKeyList<K> keySet() {
        return new RestrictedValueSortedMapKeyList();
    }

    @Override
    public boolean update(K key) {
        throw new UnsupportedOperationException();
    }

    @Override
    public SortedList<V> values() {
        return new RestrictedSortedList();
    }

    public class RestrictedValueSortedMapEntryList
    implements ValueSortedMap.ValueSortedMapEntryList<K, V> {
        @Override
        public int size() {
            return RestrictedValueSortedMap.this.restrictedSize();
        }

        @Override
        public boolean isEmpty() {
            return RestrictedValueSortedMap.this.restrictedIsEmpty();
        }

        @Override
        public boolean contains(Object o) {
            if (!RestrictedValueSortedMap.this.wrapped.entrySet().contains(o)) {
                return false;
            }
            Map.Entry ent = (Map.Entry)o;
            Object val = ent.getValue();
            return RestrictedValueSortedMap.this.inBounds(val);
        }

        @Override
        public Iterator<Map.Entry<K, V>> iterator() {
            return new RestrictedEntryListIterator();
        }

        @Override
        public Object[] toArray() {
            Object[] result = new Object[this.size()];
            int i = 0;
            Iterator iterator = this.iterator();
            while (iterator.hasNext()) {
                Map.Entry ent;
                result[i] = ent = iterator.next();
                ++i;
            }
            return result;
        }

        @Override
        public <T> T[] toArray(T[] a) {
            int size = this.size();
            if (a.length != size) {
                a = (Object[])Array.newInstance(a.getClass().getComponentType(), size);
            }
            int i = 0;
            for (Map.Entry ent : this) {
                a[i] = ent;
                ++i;
            }
            return a;
        }

        @Override
        public boolean add(Map.Entry<K, V> e) {
            throw new UnsupportedOperationException();
        }

        @Override
        public boolean remove(Object o) {
            throw new UnsupportedOperationException();
        }

        @Override
        public boolean containsAll(Collection<?> c) {
            for (Object o : c) {
                if (this.contains(o)) continue;
                return false;
            }
            return true;
        }

        @Override
        public boolean addAll(Collection<? extends Map.Entry<K, V>> c) {
            throw new UnsupportedOperationException();
        }

        @Override
        public boolean retainAll(Collection<?> c) {
            throw new UnsupportedOperationException();
        }

        @Override
        public boolean removeAll(Collection<?> c) {
            throw new UnsupportedOperationException();
        }

        @Override
        public void clear() {
            throw new UnsupportedOperationException();
        }

        @Override
        public boolean addAll(int index, Collection<? extends Map.Entry<K, V>> c) {
            throw new UnsupportedOperationException();
        }

        @Override
        public Map.Entry<K, V> get(int index) {
            if (index < 0) {
                throw new IndexOutOfBoundsException("" + index);
            }
            Map.Entry ent = RestrictedValueSortedMap.this.inBoundsOrNull((Map.Entry)RestrictedValueSortedMap.this.wrapped.entrySet().get(RestrictedValueSortedMap.this.getLowestIndex() + index));
            if (ent == null) {
                throw new IndexOutOfBoundsException("" + index);
            }
            return ent;
        }

        @Override
        public Map.Entry<K, V> set(int index, Map.Entry<K, V> element) {
            throw new UnsupportedOperationException();
        }

        @Override
        public void add(int index, Map.Entry<K, V> element) {
            throw new UnsupportedOperationException();
        }

        @Override
        public Map.Entry<K, V> remove(int index) {
            throw new UnsupportedOperationException();
        }

        @Override
        public int indexOf(Object o) {
            return RestrictedValueSortedMap.this.inBoundsOrNeg1(RestrictedValueSortedMap.this.wrapped.entrySet().indexOf(o));
        }

        @Override
        public int lastIndexOf(Object o) {
            return RestrictedValueSortedMap.this.inBoundsOrNeg1(RestrictedValueSortedMap.this.wrapped.entrySet().lastIndexOf(o));
        }

        @Override
        public ListIterator<Map.Entry<K, V>> listIterator() {
            return new RestrictedEntryListIterator();
        }

        @Override
        public ListIterator<Map.Entry<K, V>> listIterator(int index) {
            return new RestrictedEntryListIterator(index);
        }

        @Override
        public List<Map.Entry<K, V>> subList(int fromIndex, int toIndex) {
            throw new UnsupportedOperationException();
        }

        @Override
        public void addFirst(Map.Entry<K, V> e) {
            throw new UnsupportedOperationException();
        }

        @Override
        public void addLast(Map.Entry<K, V> e) {
            throw new UnsupportedOperationException();
        }

        @Override
        public boolean offerFirst(Map.Entry<K, V> e) {
            throw new UnsupportedOperationException();
        }

        @Override
        public boolean offerLast(Map.Entry<K, V> e) {
            throw new UnsupportedOperationException();
        }

        @Override
        public Map.Entry<K, V> removeFirst() {
            throw new UnsupportedOperationException();
        }

        @Override
        public Map.Entry<K, V> removeLast() {
            throw new UnsupportedOperationException();
        }

        @Override
        public Map.Entry<K, V> pollFirst() {
            throw new UnsupportedOperationException();
        }

        @Override
        public Map.Entry<K, V> pollLast() {
            throw new UnsupportedOperationException();
        }

        @Override
        public Map.Entry<K, V> getFirst() {
            Object ent = this.peekFirst();
            if (ent == null) {
                throw new NoSuchElementException();
            }
            return ent;
        }

        @Override
        public Map.Entry<K, V> getLast() {
            Object ent = this.peekLast();
            if (ent == null) {
                throw new NoSuchElementException();
            }
            return ent;
        }

        @Override
        public Map.Entry<K, V> peekFirst() {
            Map.Entry ent = !RestrictedValueSortedMap.this.hasFrom ? (Map.Entry)RestrictedValueSortedMap.this.wrapped.entrySet().getFirst() : (RestrictedValueSortedMap.this.fromInclusive ? RestrictedValueSortedMap.this.wrapped.ceilingEntryByValue(RestrictedValueSortedMap.this.fromValue) : RestrictedValueSortedMap.this.wrapped.higherEntryByValue(RestrictedValueSortedMap.this.fromValue));
            return RestrictedValueSortedMap.this.inBoundsOrNull(ent);
        }

        @Override
        public Map.Entry<K, V> peekLast() {
            Map.Entry ent = !RestrictedValueSortedMap.this.hasTo ? (Map.Entry)RestrictedValueSortedMap.this.wrapped.entrySet().getLast() : (RestrictedValueSortedMap.this.toInclusive ? RestrictedValueSortedMap.this.wrapped.floorEntryByValue(RestrictedValueSortedMap.this.toValue) : RestrictedValueSortedMap.this.wrapped.lowerEntryByValue(RestrictedValueSortedMap.this.toValue));
            return RestrictedValueSortedMap.this.inBoundsOrNull(ent);
        }

        @Override
        public boolean removeFirstOccurrence(Object o) {
            throw new UnsupportedOperationException();
        }

        @Override
        public boolean removeLastOccurrence(Object o) {
            throw new UnsupportedOperationException();
        }

        @Override
        public boolean offer(Map.Entry<K, V> e) {
            throw new UnsupportedOperationException();
        }

        @Override
        public Map.Entry<K, V> remove() {
            throw new UnsupportedOperationException();
        }

        @Override
        public Map.Entry<K, V> poll() {
            throw new UnsupportedOperationException();
        }

        @Override
        public Map.Entry<K, V> element() {
            return this.getFirst();
        }

        @Override
        public Map.Entry<K, V> peek() {
            return this.peekFirst();
        }

        @Override
        public void push(Map.Entry<K, V> e) {
            throw new UnsupportedOperationException();
        }

        @Override
        public Map.Entry<K, V> pop() {
            throw new UnsupportedOperationException();
        }

        @Override
        public Iterator<Map.Entry<K, V>> descendingIterator() {
            return new ReversedListIterator(new RestrictedEntryListIterator(RestrictedValueSortedMap.this.restrictedSize()));
        }
    }

    public class RestrictedValueSortedMapKeyList
    implements ValueSortedMap.ValueSortedMapKeyList<K> {
        @Override
        public int size() {
            return RestrictedValueSortedMap.this.restrictedSize();
        }

        @Override
        public boolean isEmpty() {
            return RestrictedValueSortedMap.this.restrictedIsEmpty();
        }

        @Override
        public boolean contains(Object o) {
            return RestrictedValueSortedMap.this.containsKey(o);
        }

        @Override
        public Iterator<K> iterator() {
            return new RestrictedKeyListIterator();
        }

        @Override
        public Object[] toArray() {
            Object[] result = new Object[this.size()];
            int i = 0;
            for (Object key : this) {
                result[i] = key;
                ++i;
            }
            return result;
        }

        @Override
        public <T> T[] toArray(T[] a) {
            int size = this.size();
            if (a.length != size) {
                a = (Object[])Array.newInstance(a.getClass().getComponentType(), size);
            }
            int i = 0;
            for (Object key : this) {
                a[i] = key;
                ++i;
            }
            return a;
        }

        @Override
        public boolean add(K e) {
            throw new UnsupportedOperationException();
        }

        @Override
        public boolean remove(Object o) {
            throw new UnsupportedOperationException();
        }

        @Override
        public boolean containsAll(Collection<?> c) {
            for (Object o : c) {
                if (this.contains(o)) continue;
                return false;
            }
            return true;
        }

        @Override
        public boolean addAll(Collection<? extends K> c) {
            throw new UnsupportedOperationException();
        }

        @Override
        public boolean retainAll(Collection<?> c) {
            throw new UnsupportedOperationException();
        }

        @Override
        public boolean removeAll(Collection<?> c) {
            throw new UnsupportedOperationException();
        }

        @Override
        public void clear() {
            throw new UnsupportedOperationException();
        }

        @Override
        public boolean addAll(int index, Collection<? extends K> c) {
            throw new UnsupportedOperationException();
        }

        @Override
        public K get(int index) {
            if (index < 0) {
                throw new IndexOutOfBoundsException("" + index);
            }
            Map.Entry ent = RestrictedValueSortedMap.this.inBoundsOrNull((Map.Entry)RestrictedValueSortedMap.this.wrapped.entrySet().get(RestrictedValueSortedMap.this.getLowestIndex() + index));
            if (ent == null) {
                throw new IndexOutOfBoundsException("" + index);
            }
            return ent.getKey();
        }

        @Override
        public K set(int index, K element) {
            throw new UnsupportedOperationException();
        }

        @Override
        public void add(int index, K element) {
            throw new UnsupportedOperationException();
        }

        @Override
        public K remove(int index) {
            throw new UnsupportedOperationException();
        }

        @Override
        public int indexOf(Object o) {
            return RestrictedValueSortedMap.this.inBoundsOrNeg1(RestrictedValueSortedMap.this.wrapped.keySet().indexOf(o));
        }

        @Override
        public int lastIndexOf(Object o) {
            return RestrictedValueSortedMap.this.inBoundsOrNeg1(RestrictedValueSortedMap.this.wrapped.keySet().lastIndexOf(o));
        }

        @Override
        public ListIterator<K> listIterator() {
            return new RestrictedKeyListIterator();
        }

        @Override
        public ListIterator<K> listIterator(int index) {
            return new RestrictedKeyListIterator(index);
        }

        @Override
        public List<K> subList(int fromIndex, int toIndex) {
            throw new UnsupportedOperationException();
        }

        @Override
        public void addFirst(K e) {
            throw new UnsupportedOperationException();
        }

        @Override
        public void addLast(K e) {
            throw new UnsupportedOperationException();
        }

        @Override
        public boolean offerFirst(K e) {
            throw new UnsupportedOperationException();
        }

        @Override
        public boolean offerLast(K e) {
            throw new UnsupportedOperationException();
        }

        @Override
        public K removeFirst() {
            throw new UnsupportedOperationException();
        }

        @Override
        public K removeLast() {
            throw new UnsupportedOperationException();
        }

        @Override
        public K pollFirst() {
            throw new UnsupportedOperationException();
        }

        @Override
        public K pollLast() {
            throw new UnsupportedOperationException();
        }

        @Override
        public K getFirst() {
            Map.Entry ent = (Map.Entry)RestrictedValueSortedMap.this.entrySet().peekFirst();
            if (ent == null) {
                throw new NoSuchElementException();
            }
            return ent.getKey();
        }

        @Override
        public K getLast() {
            Map.Entry ent = (Map.Entry)RestrictedValueSortedMap.this.entrySet().peekLast();
            if (ent == null) {
                throw new NoSuchElementException();
            }
            return ent.getKey();
        }

        @Override
        public K peekFirst() {
            Map.Entry ent = (Map.Entry)RestrictedValueSortedMap.this.entrySet().peekFirst();
            if (ent == null) {
                return null;
            }
            return ent.getKey();
        }

        @Override
        public K peekLast() {
            Map.Entry ent = (Map.Entry)RestrictedValueSortedMap.this.entrySet().peekLast();
            if (ent == null) {
                return null;
            }
            return ent.getKey();
        }

        @Override
        public boolean removeFirstOccurrence(Object o) {
            throw new UnsupportedOperationException();
        }

        @Override
        public boolean removeLastOccurrence(Object o) {
            throw new UnsupportedOperationException();
        }

        @Override
        public boolean offer(K e) {
            throw new UnsupportedOperationException();
        }

        @Override
        public K remove() {
            throw new UnsupportedOperationException();
        }

        @Override
        public K poll() {
            throw new UnsupportedOperationException();
        }

        @Override
        public K element() {
            return this.getFirst();
        }

        @Override
        public K peek() {
            return this.peekFirst();
        }

        @Override
        public void push(K e) {
            throw new UnsupportedOperationException();
        }

        @Override
        public K pop() {
            throw new UnsupportedOperationException();
        }

        @Override
        public Iterator<K> descendingIterator() {
            return new ReversedListIterator(new RestrictedKeyListIterator(RestrictedValueSortedMap.this.restrictedSize()));
        }
    }

    public class RestrictedSortedList
    implements SortedList<V> {
        @Override
        public int size() {
            return RestrictedValueSortedMap.this.restrictedSize();
        }

        @Override
        public boolean isEmpty() {
            return RestrictedValueSortedMap.this.restrictedIsEmpty();
        }

        @Override
        public boolean contains(Object o) {
            return RestrictedValueSortedMap.this.containsValue(o);
        }

        @Override
        public Iterator<V> iterator() {
            return new RestrictedValueListIterator();
        }

        @Override
        public Object[] toArray() {
            Object[] result = new Object[this.size()];
            int i = 0;
            for (Object val : this) {
                result[i] = val;
                ++i;
            }
            return result;
        }

        @Override
        public <T> T[] toArray(T[] a) {
            int size = this.size();
            if (a.length != size) {
                a = (Object[])Array.newInstance(a.getClass().getComponentType(), size);
            }
            int i = 0;
            for (Object val : this) {
                a[i] = val;
                ++i;
            }
            return a;
        }

        @Override
        public boolean add(V e) {
            throw new UnsupportedOperationException();
        }

        @Override
        public boolean remove(Object o) {
            throw new UnsupportedOperationException();
        }

        @Override
        public boolean containsAll(Collection<?> c) {
            for (Object o : c) {
                if (this.contains(o)) continue;
                return false;
            }
            return true;
        }

        @Override
        public boolean addAll(Collection<? extends V> c) {
            throw new UnsupportedOperationException();
        }

        @Override
        public boolean addAll(int index, Collection<? extends V> c) {
            throw new UnsupportedOperationException();
        }

        @Override
        public boolean removeAll(Collection<?> c) {
            throw new UnsupportedOperationException();
        }

        @Override
        public boolean retainAll(Collection<?> c) {
            throw new UnsupportedOperationException();
        }

        @Override
        public void clear() {
            throw new UnsupportedOperationException();
        }

        @Override
        public V get(int index) {
            if (index < 0) {
                throw new IndexOutOfBoundsException("" + index);
            }
            Map.Entry ent = RestrictedValueSortedMap.this.inBoundsOrNull((Map.Entry)RestrictedValueSortedMap.this.wrapped.entrySet().get(RestrictedValueSortedMap.this.getLowestIndex() + index));
            if (ent == null) {
                throw new IndexOutOfBoundsException("" + index);
            }
            return ent.getValue();
        }

        @Override
        public V set(int index, V element) {
            throw new UnsupportedOperationException();
        }

        @Override
        public void add(int index, V element) {
            throw new UnsupportedOperationException();
        }

        @Override
        public V remove(int index) {
            throw new UnsupportedOperationException();
        }

        @Override
        public int indexOf(Object o) {
            return RestrictedValueSortedMap.this.inBoundsOrNeg1(RestrictedValueSortedMap.this.wrapped.values().indexOf(o));
        }

        @Override
        public int lastIndexOf(Object o) {
            return RestrictedValueSortedMap.this.inBoundsOrNeg1(RestrictedValueSortedMap.this.wrapped.values().lastIndexOf(o));
        }

        @Override
        public ListIterator<V> listIterator() {
            return new RestrictedValueListIterator();
        }

        @Override
        public ListIterator<V> listIterator(int index) {
            return new RestrictedValueListIterator(index);
        }

        @Override
        public List<V> subList(int fromIndex, int toIndex) {
            throw new UnsupportedOperationException();
        }

        @Override
        public int lowerIndex(V element) {
            return RestrictedValueSortedMap.this.inBoundsOrNeg1(RestrictedValueSortedMap.this.wrapped.values().lowerIndex(element));
        }

        @Override
        public int floorIndex(V element) {
            return RestrictedValueSortedMap.this.inBoundsOrNeg1(RestrictedValueSortedMap.this.wrapped.values().floorIndex(element));
        }

        @Override
        public int ceilingIndex(V element) {
            return RestrictedValueSortedMap.this.inBoundsOrNeg1(RestrictedValueSortedMap.this.wrapped.values().ceilingIndex(element));
        }

        @Override
        public int higherIndex(V element) {
            return RestrictedValueSortedMap.this.inBoundsOrNeg1(RestrictedValueSortedMap.this.wrapped.values().higherIndex(element));
        }
    }

    public class RestrictedValueListIterator
    implements ListIterator<V> {
        protected final RestrictedEntryListIterator wit;

        public RestrictedValueListIterator() {
            this(0);
        }

        public RestrictedValueListIterator(int start) {
            this.wit = new RestrictedEntryListIterator(start);
        }

        @Override
        public boolean hasNext() {
            return this.wit.hasNext();
        }

        @Override
        public V next() {
            return this.wit.next().getValue();
        }

        @Override
        public boolean hasPrevious() {
            return this.wit.hasPrevious();
        }

        @Override
        public V previous() {
            return this.wit.previous().getValue();
        }

        @Override
        public int nextIndex() {
            return this.wit.nextIndex();
        }

        @Override
        public int previousIndex() {
            return this.wit.previousIndex();
        }

        @Override
        public void remove() {
            throw new UnsupportedOperationException();
        }

        @Override
        public void set(V e) {
            throw new UnsupportedOperationException();
        }

        @Override
        public void add(V e) {
            throw new UnsupportedOperationException();
        }
    }

    public class RestrictedKeyListIterator
    implements ListIterator<K> {
        protected final RestrictedEntryListIterator wit;

        public RestrictedKeyListIterator() {
            this(0);
        }

        public RestrictedKeyListIterator(int start) {
            this.wit = new RestrictedEntryListIterator(start);
        }

        @Override
        public boolean hasNext() {
            return this.wit.hasNext();
        }

        @Override
        public K next() {
            return this.wit.next().getKey();
        }

        @Override
        public boolean hasPrevious() {
            return this.wit.hasPrevious();
        }

        @Override
        public K previous() {
            return this.wit.previous().getKey();
        }

        @Override
        public int nextIndex() {
            return this.wit.nextIndex();
        }

        @Override
        public int previousIndex() {
            return this.wit.previousIndex();
        }

        @Override
        public void remove() {
            throw new UnsupportedOperationException();
        }

        @Override
        public void set(K e) {
            throw new UnsupportedOperationException();
        }

        @Override
        public void add(K e) {
            throw new UnsupportedOperationException();
        }
    }

    public class RestrictedEntryListIterator
    implements ListIterator<Map.Entry<K, V>> {
        protected final ListIterator<Map.Entry<K, V>> wit;

        public RestrictedEntryListIterator() {
            this(0);
        }

        public RestrictedEntryListIterator(int start) {
            this.wit = RestrictedValueSortedMap.this.wrapped.entrySet().listIterator(RestrictedValueSortedMap.this.getLowestIndex() + start);
        }

        @Override
        public boolean hasNext() {
            if (!this.wit.hasNext()) {
                return false;
            }
            Map.Entry next = this.wit.next();
            this.wit.previous();
            return RestrictedValueSortedMap.this.inBounds(next.getValue());
        }

        @Override
        public Map.Entry<K, V> next() {
            return this.wit.next();
        }

        @Override
        public boolean hasPrevious() {
            if (!this.wit.hasPrevious()) {
                return false;
            }
            Map.Entry prev = this.wit.previous();
            this.wit.next();
            return RestrictedValueSortedMap.this.inBounds(prev.getValue());
        }

        @Override
        public Map.Entry<K, V> previous() {
            return this.wit.previous();
        }

        @Override
        public int nextIndex() {
            return this.wit.nextIndex() - RestrictedValueSortedMap.this.getLowestIndex();
        }

        @Override
        public int previousIndex() {
            return this.wit.previousIndex() - RestrictedValueSortedMap.this.getLowestIndex();
        }

        @Override
        public void remove() {
            throw new UnsupportedOperationException();
        }

        @Override
        public void set(Map.Entry<K, V> e) {
            throw new UnsupportedOperationException();
        }

        @Override
        public void add(Map.Entry<K, V> e) {
            throw new UnsupportedOperationException();
        }
    }
}

