/*
 * Decompiled with CFR 0.152.
 */
package ghidra.framework.remote;

import java.io.Serializable;
import java.security.Principal;
import java.security.cert.X509Certificate;
import javax.security.auth.callback.Callback;
import javax.security.auth.x500.X500Principal;

public class SignatureCallback
implements Callback,
Serializable {
    public static final long serialVersionUID = 1L;
    private X500Principal[] recognizedAuthorities;
    private final byte[] token;
    private final byte[] serverSignature;
    private byte[] signature;
    private X509Certificate[] certChain;

    public SignatureCallback(X500Principal[] recognizedAuthorities, byte[] token, byte[] serverSignature) {
        this.token = token;
        this.serverSignature = serverSignature;
        this.recognizedAuthorities = recognizedAuthorities;
    }

    public Principal[] getRecognizedAuthorities() {
        return this.recognizedAuthorities == null ? null : (Principal[])this.recognizedAuthorities.clone();
    }

    public byte[] getToken() {
        return this.token == null ? null : (byte[])this.token.clone();
    }

    public byte[] getSignature() {
        return this.signature == null ? null : (byte[])this.signature.clone();
    }

    public byte[] getServerSignature() {
        return this.serverSignature;
    }

    public X509Certificate[] getCertificateChain() {
        return this.certChain;
    }

    public void sign(X509Certificate[] sigCertChain, byte[] certSignature) {
        this.certChain = sigCertChain;
        this.signature = certSignature == null ? null : (byte[])certSignature.clone();
    }

    public String getSigAlg() {
        return null;
    }
}

