/*
 * Decompiled with CFR 0.152.
 */
package ghidra.feature.fid.service;

import ghidra.feature.fid.db.FunctionRecord;
import ghidra.feature.fid.db.LibraryRecord;
import ghidra.feature.fid.plugin.HashLookupListMode;
import ghidra.feature.fid.service.FidMatch;
import ghidra.feature.fid.service.FidMatchScore;
import ghidra.program.model.address.Address;

class FidMatchImpl
implements FidMatch {
    private final LibraryRecord library;
    private final Address functionEntryPoint;
    private final FidMatchScore scoreDelegate;

    FidMatchImpl(LibraryRecord library, Address functionEntryPoint, FidMatchScore score) {
        this.library = library;
        this.functionEntryPoint = functionEntryPoint;
        this.scoreDelegate = score;
    }

    @Override
    public LibraryRecord getLibraryRecord() {
        return this.library;
    }

    @Override
    public Address getMatchedFunctionEntryPoint() {
        return this.functionEntryPoint;
    }

    public String toString() {
        return this.scoreDelegate + " @ " + this.functionEntryPoint;
    }

    @Override
    public FunctionRecord getFunctionRecord() {
        return this.scoreDelegate.getFunctionRecord();
    }

    @Override
    public float getPrimaryFunctionCodeUnitScore() {
        return this.scoreDelegate.getPrimaryFunctionCodeUnitScore();
    }

    @Override
    public HashLookupListMode getPrimaryFunctionMatchMode() {
        return this.scoreDelegate.getPrimaryFunctionMatchMode();
    }

    @Override
    public float getChildFunctionCodeUnitScore() {
        return this.scoreDelegate.getChildFunctionCodeUnitScore();
    }

    @Override
    public float getParentFunctionCodeUnitScore() {
        return this.scoreDelegate.getParentFunctionCodeUnitScore();
    }

    @Override
    public float getOverallScore() {
        return this.scoreDelegate.getOverallScore();
    }
}

