/*
 * Decompiled with CFR 0.152.
 */
package ghidra.app.cmd.data.exceptionhandling;

import ghidra.app.cmd.data.AbstractCreateDataBackgroundCmd;
import ghidra.app.cmd.data.exceptionhandling.CreateEHCatchHandlerMapBackgroundCmd;
import ghidra.app.cmd.data.exceptionhandling.EHCatchHandlerModel;
import ghidra.app.cmd.data.exceptionhandling.EHESTypeListModel;
import ghidra.app.util.datatype.microsoft.DataApplyOptions;
import ghidra.app.util.datatype.microsoft.DataValidationOptions;
import ghidra.framework.model.DomainObject;
import ghidra.program.model.address.Address;
import ghidra.program.model.data.InvalidDataTypeException;
import ghidra.program.model.listing.Program;
import ghidra.util.exception.AssertException;
import ghidra.util.exception.CancelledException;

public class CreateEHESTypeListBackgroundCmd
extends AbstractCreateDataBackgroundCmd<EHESTypeListModel> {
    public CreateEHESTypeListBackgroundCmd(Address address) {
        super("ESTypeList", address, 1);
    }

    public CreateEHESTypeListBackgroundCmd(Address address, DataValidationOptions validationOptions, DataApplyOptions applyOptions) {
        super("ESTypeList", address, 1, validationOptions, applyOptions);
    }

    CreateEHESTypeListBackgroundCmd(EHESTypeListModel esTypeListModel, DataApplyOptions applyOptions) {
        super(esTypeListModel, applyOptions);
    }

    @Override
    protected EHESTypeListModel createModel(Program program) {
        if (this.model == null) {
            this.model = new EHESTypeListModel(program, this.getDataAddress(), this.validationOptions);
        }
        return (EHESTypeListModel)this.model;
    }

    @Override
    protected boolean createAssociatedData() throws CancelledException {
        return this.createCatchHandlerMapEntries();
    }

    private boolean createCatchHandlerMapEntries() throws CancelledException {
        EHCatchHandlerModel catchHandlerModel;
        int catchHandlerCount;
        Address handlerTypeMapAddress;
        Address compAddress;
        this.monitor.setMessage("Creating HandlerTypes for ESTypeList");
        Program program = ((EHESTypeListModel)this.model).getProgram();
        try {
            compAddress = ((EHESTypeListModel)this.model).getComponentAddressOfHandlerTypeMapAddress();
            handlerTypeMapAddress = ((EHESTypeListModel)this.model).getHandlerTypeMapAddress();
            catchHandlerCount = ((EHESTypeListModel)this.model).getHandlerTypeCount();
        }
        catch (InvalidDataTypeException e) {
            throw new AssertException((Throwable)e);
        }
        if (handlerTypeMapAddress == null || catchHandlerCount == 0) {
            return true;
        }
        this.monitor.checkCancelled();
        try {
            catchHandlerModel = ((EHESTypeListModel)this.model).getCatchHandlerModel();
        }
        catch (InvalidDataTypeException e) {
            throw new AssertException((Throwable)e);
        }
        try {
            catchHandlerModel.validate();
        }
        catch (InvalidDataTypeException e1) {
            this.handleErrorMessage(program, catchHandlerModel.getName(), handlerTypeMapAddress, compAddress, (Exception)((Object)e1));
            return false;
        }
        this.monitor.checkCancelled();
        CreateEHCatchHandlerMapBackgroundCmd cmd = new CreateEHCatchHandlerMapBackgroundCmd(catchHandlerModel, this.applyOptions);
        return cmd.applyTo((DomainObject)program, this.monitor);
    }

    @Override
    protected boolean createMarkup() throws CancelledException {
        return true;
    }
}

