/*
 * Decompiled with CFR 0.152.
 */
package ghidra.framework.project.extensions;

import docking.widgets.table.threaded.ThreadedTableModelListener;
import generic.theme.GColor;
import ghidra.framework.plugintool.dialog.AbstractDetailsPanel;
import ghidra.framework.project.extensions.ExtensionDetails;
import ghidra.framework.project.extensions.ExtensionTablePanel;
import java.awt.Color;
import java.awt.Point;
import javax.swing.text.SimpleAttributeSet;

class ExtensionDetailsPanel
extends AbstractDetailsPanel {
    private static final Color FG_COLOR_AUTHOR = new GColor("color.fg.extensionpanel.details.author");
    private static final Color FG_COLOR_DATE = new GColor("color.fg.extensionpanel.details.date");
    private static final Color FG_COLOR_DESCRIPTION = new GColor("color.fg.extensionpanel.details.description");
    private static final Color FG_COLOR_NAME = new GColor("color.fg.extensionpanel.details.name");
    private static final Color FG_COLOR_PATH = new GColor("color.fg.extensionpanel.path");
    private static final Color FG_COLOR_TITLE = new GColor("color.fg.extensionpanel.details.title");
    private static final Color FG_COLOR_VERSION = new GColor("color.fg.extensionpanel.details.version");
    private SimpleAttributeSet nameAttrSet;
    private SimpleAttributeSet descrAttrSet;
    private SimpleAttributeSet authorAttrSet;
    private SimpleAttributeSet createdOnAttrSet;
    private SimpleAttributeSet versionAttrSet;
    private SimpleAttributeSet pathAttrSet;

    ExtensionDetailsPanel(final ExtensionTablePanel tablePanel) {
        this.createFieldAttributes();
        this.createMainPanel();
        tablePanel.getTableModel().addThreadedTableModelListener(new ThreadedTableModelListener(){

            public void loadPending() {
            }

            public void loadingStarted() {
            }

            public void loadingFinished(boolean wasCancelled) {
                ExtensionDetailsPanel.this.setDescription(tablePanel.getSelectedItem());
            }
        });
        tablePanel.getTable().getSelectionModel().addListSelectionListener(e -> this.setDescription(tablePanel.getSelectedItem()));
    }

    public void setDescription(ExtensionDetails details) {
        this.clear();
        if (details == null) {
            return;
        }
        StringBuilder buffer = new StringBuilder("<HTML>");
        buffer.append("<TABLE cellpadding=2>");
        this.insertRowTitle(buffer, "Name");
        this.insertRowValue(buffer, details.getName(), this.nameAttrSet);
        this.insertRowTitle(buffer, "Description");
        this.insertRowValue(buffer, details.getDescription(), this.descrAttrSet);
        this.insertRowTitle(buffer, "Author");
        this.insertRowValue(buffer, details.getAuthor(), this.authorAttrSet);
        this.insertRowTitle(buffer, "Created-on");
        String date = details.getCreatedOn();
        this.insertRowValue(buffer, date, this.createdOnAttrSet);
        this.insertRowTitle(buffer, "Version");
        String version = details.getVersion();
        if (version.equals("@extversion@")) {
            this.insertRowValue(buffer, "", this.versionAttrSet);
        } else {
            this.insertRowValue(buffer, version, this.versionAttrSet);
        }
        String installPath = details.getInstallPath();
        if (installPath != null) {
            this.insertRowTitle(buffer, "Install Path");
            this.insertRowValue(buffer, installPath, this.pathAttrSet);
        }
        buffer.append("</TABLE>");
        this.textLabel.setText(buffer.toString());
        this.sp.getViewport().setViewPosition(new Point(0, 0));
    }

    @Override
    protected void createFieldAttributes() {
        titleAttrSet = this.createAttributeSet(FG_COLOR_TITLE);
        this.nameAttrSet = this.createAttributeSet(FG_COLOR_NAME);
        this.descrAttrSet = this.createAttributeSet(FG_COLOR_DESCRIPTION);
        this.authorAttrSet = this.createAttributeSet(FG_COLOR_AUTHOR);
        this.createdOnAttrSet = this.createAttributeSet(FG_COLOR_DATE);
        this.versionAttrSet = this.createAttributeSet(FG_COLOR_VERSION);
        this.pathAttrSet = this.createAttributeSet(FG_COLOR_PATH);
    }
}

