/*
 * Decompiled with CFR 0.152.
 */
package ghidra.framework.main.datatree;

import ghidra.framework.main.datatree.VersionControlDialog;
import ghidra.framework.model.DomainFile;
import ghidra.framework.plugintool.PluginTool;
import ghidra.util.SystemUtilities;
import ghidra.util.task.Task;
import java.awt.Component;
import java.util.List;

public abstract class VersionControlTask
extends Task {
    protected List<DomainFile> list;
    protected int actionID;
    protected boolean keepCheckedOut;
    protected boolean createKeep;
    protected String comments;
    protected boolean filesInUse;
    protected PluginTool tool;
    protected boolean wasCanceled;
    protected Component parent;

    protected VersionControlTask(String title, PluginTool tool, List<DomainFile> list, Component parent) {
        super(title, true, true, true);
        this.tool = tool;
        this.list = list;
        this.parent = parent;
    }

    protected void showDialog(boolean addToVersionControl, String filename, boolean isLinkFile) {
        Runnable r = () -> {
            VersionControlDialog vcDialog = new VersionControlDialog(addToVersionControl);
            vcDialog.setCurrentFileName(filename);
            vcDialog.setMultiFiles(this.list.size() > 1);
            if (isLinkFile) {
                vcDialog.setKeepCheckboxEnabled(false, false, "Link files may not be Checked Out");
            } else if (this.filesInUse) {
                vcDialog.setKeepCheckboxEnabled(false, true, "Must keep Checked Out because the file is in use");
            }
            this.actionID = vcDialog.showDialog(this.tool, this.parent);
            this.keepCheckedOut = vcDialog.keepCheckedOut();
            this.createKeep = vcDialog.shouldCreateKeepFile();
            this.comments = vcDialog.getComments();
            if (this.comments.length() == 0) {
                this.comments = null;
            }
        };
        SystemUtilities.runSwingNow((Runnable)r);
    }

    protected void checkFilesInUse() {
        this.filesInUse = false;
        for (int i = 0; i < this.list.size(); ++i) {
            DomainFile df = this.list.get(i);
            if (df.getConsumers().size() <= 0) continue;
            this.filesInUse = true;
            return;
        }
    }

    protected boolean checkFilesForUnsavedChanges() {
        for (int i = 0; i < this.list.size(); ++i) {
            DomainFile df = this.list.get(i);
            if (!df.modifiedSinceCheckout()) continue;
            return true;
        }
        return false;
    }
}

