/*
 * Decompiled with CFR 0.152.
 */
package ghidra.util.task;

import ghidra.util.task.AbstractSwingUpdateManager;
import utility.function.Dummy;

public class BufferedSwingRunner
extends AbstractSwingUpdateManager {
    private Runnable nextRunnable;

    public BufferedSwingRunner(int minDelay, int maxDelay) {
        super(minDelay, maxDelay, DEFAULT_NAME);
    }

    public BufferedSwingRunner() {
        super(250, 30000, DEFAULT_NAME);
    }

    @Override
    protected void swingDoWork() {
        Runnable currentRunnable = this.prepareCurrentRunnable();
        currentRunnable.run();
    }

    public synchronized void run(Runnable r) {
        this.nextRunnable = r;
        this.update();
    }

    public synchronized void runLater(Runnable r) {
        this.nextRunnable = r;
        this.updateLater();
    }

    private synchronized Runnable prepareCurrentRunnable() {
        Runnable currentRunnable = this.nextRunnable;
        this.nextRunnable = null;
        return Dummy.ifNull((Runnable)currentRunnable);
    }
}

