/*
 * Decompiled with CFR 0.152.
 */
package generic.theme.laf;

import generic.theme.Gui;
import ghidra.util.datastruct.WeakDataStructureFactory;
import ghidra.util.datastruct.WeakSet;
import java.awt.Component;
import java.awt.Font;
import java.util.Objects;

public class ComponentFontRegistry {
    private WeakSet<Component> components = WeakDataStructureFactory.createCopyOnReadWeakSet();
    private String fontId;

    public ComponentFontRegistry(String fontId) {
        this.fontId = fontId;
    }

    public void addComponent(Component component) {
        component.setFont(Gui.getFont(this.fontId));
        this.components.add((Object)component);
    }

    public void updateComponentFonts() {
        Font font = Gui.getFont(this.fontId);
        for (Component component : this.components) {
            Font existingFont = component.getFont();
            if (Objects.equals(existingFont, font)) continue;
            component.setFont(font);
        }
    }
}

