/*
 * Decompiled with CFR 0.152.
 */
package ghidra.app.plugin.core.debug.gui.action;

import docking.ActionContext;
import docking.ComponentProvider;
import docking.action.builder.MultiStateActionBuilder;
import docking.menu.ActionState;
import docking.menu.MultiStateDockingAction;
import docking.widgets.EventTrigger;
import docking.widgets.fieldpanel.support.BackgroundColorModel;
import docking.widgets.fieldpanel.support.FieldSelection;
import ghidra.app.plugin.core.debug.DebuggerCoordinates;
import ghidra.app.plugin.core.debug.gui.DebuggerResources;
import ghidra.app.plugin.core.debug.gui.action.DebuggerTrackLocationAction;
import ghidra.app.plugin.core.debug.gui.action.GoToInput;
import ghidra.app.plugin.core.debug.gui.action.LocationTracker;
import ghidra.app.plugin.core.debug.gui.action.LocationTrackingSpec;
import ghidra.app.plugin.core.debug.gui.action.LocationTrackingSpecFactory;
import ghidra.app.plugin.core.debug.gui.action.NoneLocationTrackingSpec;
import ghidra.app.plugin.core.debug.gui.action.PCLocationTrackingSpec;
import ghidra.app.plugin.core.debug.gui.colors.DebuggerTrackedRegisterBackgroundColorModel;
import ghidra.app.plugin.core.debug.gui.colors.MultiSelectionBlendedLayoutBackgroundColorManager;
import ghidra.app.plugin.core.debug.gui.colors.SelectionGenerator;
import ghidra.app.plugin.core.debug.gui.colors.SelectionTranslator;
import ghidra.app.plugin.core.debug.gui.listing.DebuggerTrackedRegisterListingBackgroundColorModel;
import ghidra.app.util.viewer.listingpanel.ListingBackgroundColorModel;
import ghidra.app.util.viewer.listingpanel.ListingPanel;
import ghidra.async.AsyncUtils;
import ghidra.framework.model.DomainObjectListener;
import ghidra.framework.options.SaveState;
import ghidra.framework.plugintool.AutoConfigState;
import ghidra.framework.plugintool.Plugin;
import ghidra.framework.plugintool.PluginTool;
import ghidra.framework.plugintool.annotation.AutoConfigStateField;
import ghidra.program.model.listing.Program;
import ghidra.program.util.ProgramLocation;
import ghidra.trace.model.Trace;
import ghidra.trace.model.TraceAddressSnapRange;
import ghidra.trace.model.TraceDomainObjectListener;
import ghidra.trace.model.stack.TraceStack;
import ghidra.trace.model.thread.TraceThread;
import ghidra.trace.util.TraceAddressSpace;
import ghidra.trace.util.TraceChangeType;
import ghidra.util.Msg;
import java.awt.Color;
import java.lang.invoke.MethodHandles;
import java.math.BigInteger;
import java.util.List;
import java.util.Objects;
import java.util.TreeMap;
import java.util.concurrent.CompletableFuture;

public class DebuggerTrackLocationTrait {
    protected static final AutoConfigState.ClassHandler<DebuggerTrackLocationTrait> CONFIG_STATE_HANDLER = AutoConfigState.wireHandler(DebuggerTrackLocationTrait.class, (MethodHandles.Lookup)MethodHandles.lookup());
    protected MultiStateDockingAction<LocationTrackingSpec> action;
    private final LocationTrackingSpec defaultSpec;
    @AutoConfigStateField(codec=LocationTrackingSpec.TrackingSpecConfigFieldCodec.class)
    protected LocationTrackingSpec spec;
    protected LocationTracker tracker;
    protected final PluginTool tool;
    protected final Plugin plugin;
    protected final ComponentProvider provider;
    protected final ForTrackingListener listener;
    protected final ColorModel colorModel;
    protected final TrackSelectionGenerator selectionGenerator;
    protected DebuggerCoordinates current;
    protected ProgramLocation trackedLocation;

    public DebuggerTrackLocationTrait(PluginTool tool, Plugin plugin, ComponentProvider provider) {
        this.spec = this.defaultSpec = PCLocationTrackingSpec.INSTANCE;
        this.tracker = this.spec.getTracker();
        this.listener = new ForTrackingListener();
        this.current = DebuggerCoordinates.NOWHERE;
        this.tool = tool;
        this.plugin = plugin;
        this.provider = provider;
        this.colorModel = new ColorModel();
        this.selectionGenerator = new TrackSelectionGenerator();
    }

    public BackgroundColorModel getBackgroundColorModel() {
        return this.colorModel;
    }

    public ListingBackgroundColorModel createListingBackgroundColorModel(ListingPanel listingPanel) {
        return new ListingColorModel(listingPanel);
    }

    public SelectionGenerator getSelectionGenerator() {
        return this.selectionGenerator;
    }

    protected boolean sameCoordinates(DebuggerCoordinates a, DebuggerCoordinates b) {
        if (!Objects.equals(a.getView(), b.getView())) {
            return false;
        }
        if (!Objects.equals(a.getTime(), b.getTime())) {
            return false;
        }
        if (!Objects.equals(a.getThread(), b.getThread())) {
            return false;
        }
        return Objects.equals(a.getFrame(), b.getFrame());
    }

    public void setSpec(LocationTrackingSpec spec) {
        if (this.action == null) {
            this.doSetSpec(spec);
        } else {
            this.action.setCurrentActionStateByUserData((Object)spec);
        }
    }

    public LocationTrackingSpec getSpec() {
        return this.spec;
    }

    public ProgramLocation getTrackedLocation() {
        return this.trackedLocation;
    }

    public MultiStateDockingAction<LocationTrackingSpec> installAction() {
        this.action = (MultiStateDockingAction)((MultiStateActionBuilder)DebuggerTrackLocationAction.builder(this.plugin).stateGenerator(this::getStates).onAction(this::clickedSpecButton)).onActionStateChanged(this::clickedSpecMenu).buildAndInstallLocal(this.provider);
        this.action.setCurrentActionStateByUserData((Object)this.defaultSpec);
        return this.action;
    }

    public List<ActionState<LocationTrackingSpec>> getStates() {
        TreeMap<String, ActionState> states = new TreeMap<String, ActionState>();
        for (LocationTrackingSpec spec : LocationTrackingSpecFactory.allSuggested(this.tool).values()) {
            states.put(spec.getConfigName(), new ActionState(spec.getMenuName(), spec.getMenuIcon(), (Object)spec));
        }
        ActionState current = this.action.getCurrentState();
        if (current != null) {
            states.put(((LocationTrackingSpec)current.getUserData()).getConfigName(), current);
        }
        return List.copyOf(states.values());
    }

    protected void clickedSpecButton(ActionContext ctx) {
        this.doTrack();
    }

    protected void clickedSpecMenu(ActionState<LocationTrackingSpec> newState, EventTrigger trigger) {
        this.doSetSpec((LocationTrackingSpec)newState.getUserData());
    }

    protected void doSetSpec(LocationTrackingSpec spec) {
        if (this.spec != spec) {
            this.spec = spec;
            this.tracker = spec.getTracker();
            this.specChanged(spec);
        }
        this.doTrack();
    }

    protected CompletableFuture<ProgramLocation> computeTrackedLocation() {
        DebuggerCoordinates cur = this.current;
        if (cur.getView() == null) {
            return AsyncUtils.nil();
        }
        TraceThread thread = cur.getThread();
        if (thread == null || this.spec == null) {
            return AsyncUtils.nil();
        }
        return this.tracker.computeTraceAddress(this.tool, cur).thenApply(address -> address == null ? null : new ProgramLocation((Program)cur.getView(), address));
    }

    public String computeLabelText() {
        if (this.spec == null || this.trackedLocation == null) {
            return "";
        }
        return this.spec.getLocationLabel() + " = " + this.trackedLocation.getByteAddress();
    }

    protected void doTrack() {
        ((CompletableFuture)this.computeTrackedLocation().thenAccept(loc -> {
            this.trackedLocation = loc;
            this.locationTracked();
        })).exceptionally(ex -> {
            Msg.error((Object)this, (Object)("Error while computing location: " + ex));
            return null;
        });
    }

    protected void addNewListeners() {
        Trace trace = this.current.getTrace();
        if (trace != null) {
            trace.addListener((DomainObjectListener)this.listener);
        }
    }

    protected void removeOldListeners() {
        Trace trace = this.current.getTrace();
        if (trace != null) {
            trace.removeListener((DomainObjectListener)this.listener);
        }
    }

    public void goToCoordinates(DebuggerCoordinates coordinates) {
        boolean doListeners;
        if (this.sameCoordinates(this.current, coordinates)) {
            this.current = coordinates;
            return;
        }
        boolean bl = doListeners = !Objects.equals(this.current.getTrace(), coordinates.getTrace());
        if (doListeners) {
            this.removeOldListeners();
        }
        this.current = coordinates;
        if (doListeners) {
            this.addNewListeners();
        }
        this.doTrack();
    }

    public void writeConfigState(SaveState saveState) {
        CONFIG_STATE_HANDLER.writeConfigState((Object)this, saveState);
    }

    public void readConfigState(SaveState saveState) {
        CONFIG_STATE_HANDLER.readConfigState((Object)this, saveState);
        this.tracker = this.spec.getTracker();
        this.action.setCurrentActionStateByUserData((Object)this.spec);
    }

    public GoToInput getDefaultGoToInput(ProgramLocation loc) {
        if (this.tracker == null) {
            return NoneLocationTrackingSpec.INSTANCE.getDefaultGoToInput(this.tool, this.current, loc);
        }
        return this.tracker.getDefaultGoToInput(this.tool, this.current, loc);
    }

    protected void locationTracked() {
    }

    protected void specChanged(LocationTrackingSpec spec) {
    }

    protected class ForTrackingListener
    extends TraceDomainObjectListener {
        public ForTrackingListener() {
            this.listenFor((TraceChangeType)Trace.TraceMemoryBytesChangeType.CHANGED, this::registersChanged);
            this.listenFor((TraceChangeType)Trace.TraceStackChangeType.CHANGED, this::stackChanged);
        }

        private void registersChanged(TraceAddressSpace space, TraceAddressSnapRange range, byte[] oldValue, byte[] newValue) {
            if (DebuggerTrackLocationTrait.this.current.getView() == null || DebuggerTrackLocationTrait.this.spec == null) {
                return;
            }
            if (!DebuggerTrackLocationTrait.this.tracker.affectedByBytesChange(space, range, DebuggerTrackLocationTrait.this.current)) {
                return;
            }
            DebuggerTrackLocationTrait.this.doTrack();
        }

        private void stackChanged(TraceStack stack) {
            if (DebuggerTrackLocationTrait.this.current.getView() == null || DebuggerTrackLocationTrait.this.spec == null) {
                return;
            }
            if (!DebuggerTrackLocationTrait.this.tracker.affectedByStackChange(stack, DebuggerTrackLocationTrait.this.current)) {
                return;
            }
            DebuggerTrackLocationTrait.this.doTrack();
        }
    }

    protected class ColorModel
    extends DebuggerTrackedRegisterBackgroundColorModel {
        protected ColorModel() {
        }

        @Override
        protected ProgramLocation getTrackedLocation() {
            return DebuggerTrackLocationTrait.this.trackedLocation;
        }
    }

    protected class TrackSelectionGenerator
    implements SelectionGenerator {
        private final Color trackingColor = DebuggerResources.COLOR_REGISTER_MARKERS;

        protected TrackSelectionGenerator() {
        }

        @Override
        public void addSelections(BigInteger layoutIndex, SelectionTranslator translator, List<MultiSelectionBlendedLayoutBackgroundColorManager.ColoredFieldSelection> selections) {
            if (DebuggerTrackLocationTrait.this.trackedLocation == null || this.trackingColor == null) {
                return;
            }
            FieldSelection fieldSel = translator.convertAddressToField(DebuggerTrackLocationTrait.this.trackedLocation.getAddress());
            selections.add(new MultiSelectionBlendedLayoutBackgroundColorManager.ColoredFieldSelection(fieldSel, this.trackingColor));
        }
    }

    protected class ListingColorModel
    extends DebuggerTrackedRegisterListingBackgroundColorModel {
        public ListingColorModel(ListingPanel listingPanel) {
            super(listingPanel);
        }

        @Override
        protected ProgramLocation getTrackedLocation() {
            return DebuggerTrackLocationTrait.this.trackedLocation;
        }
    }
}

