/*
 * Decompiled with CFR 0.152.
 */
package ghidra.program.util;

import ghidra.program.database.register.InMemoryRangeMapAdapter;
import ghidra.program.model.address.Address;
import ghidra.program.model.address.AddressRange;
import ghidra.program.model.address.AddressRangeImpl;
import ghidra.program.model.address.AddressRangeIterator;
import ghidra.program.model.address.AddressSet;
import ghidra.program.model.address.AddressSetView;
import ghidra.program.model.address.AddressSpace;
import ghidra.program.model.address.OverlayAddressSpace;
import ghidra.program.model.lang.Language;
import ghidra.program.model.lang.Register;
import ghidra.program.model.lang.RegisterValue;
import ghidra.program.model.listing.ContextChangeException;
import ghidra.program.util.AbstractProgramContext;
import ghidra.program.util.RangeMapAdapter;
import ghidra.program.util.RegisterValueStore;
import ghidra.util.exception.AssertException;
import ghidra.util.exception.CancelledException;
import ghidra.util.task.TaskMonitor;
import java.math.BigInteger;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.Map;
import java.util.Set;

public abstract class AbstractStoredProgramContext
extends AbstractProgramContext {
    protected Map<Register, RegisterValueStore> registerValueMap = new HashMap<Register, RegisterValueStore>();
    protected Map<Register, RegisterValueStore> defaultRegisterValueMap = new HashMap<Register, RegisterValueStore>();
    private Set<Register> registersWithValues;

    protected AbstractStoredProgramContext(Language language) {
        super(language);
    }

    public void flushProcessorContextWriteCache() {
        RegisterValueStore store = this.registerValueMap.get(this.baseContextRegister);
        if (store != null) {
            store.flushWriteCache();
        }
    }

    public void invalidateProcessorContextWriteCache() {
        RegisterValueStore store = this.registerValueMap.get(this.baseContextRegister);
        if (store != null) {
            store.invalidateWriteCache();
        }
    }

    protected void moveAddressRange(Address fromAddr, Address toAddr, long length, TaskMonitor monitor) throws CancelledException {
        for (RegisterValueStore store : this.registerValueMap.values()) {
            store.moveAddressRange(fromAddr, toAddr, length, monitor);
        }
    }

    protected final RegisterValueStore createRegisterValueStore(Register baseRegister, RangeMapAdapter adapter) {
        RegisterValueStore store = new RegisterValueStore(baseRegister, adapter, baseRegister.isProcessorContext());
        this.registerValueMap.put(baseRegister, store);
        return store;
    }

    @Override
    public void setRegisterValue(Address start, Address end, RegisterValue value) throws ContextChangeException {
        if (value == null) {
            throw new IllegalArgumentException("Value cannot be null, use remove() instead!");
        }
        Register baseRegister = value.getRegister().getBaseRegister();
        RegisterValueStore store = this.registerValueMap.get(baseRegister);
        if (store == null) {
            RangeMapAdapter adapter = this.createNewRangeMapAdapter(baseRegister);
            store = this.createRegisterValueStore(baseRegister, adapter);
        }
        store.setValue(start, end, value);
        if (this.registersWithValues != null && !this.registersWithValues.contains(baseRegister)) {
            this.addRegisterWithValue(baseRegister);
        }
    }

    private void addRegisterWithValue(Register reg) {
        this.registersWithValues.add(reg);
        for (Register child : reg.getChildRegisters()) {
            this.addRegisterWithValue(child);
        }
    }

    @Override
    public RegisterValue getRegisterValue(Register register, Address address) {
        RegisterValue registerValue = this.getRegisterValue(register, address, this.registerValueMap);
        if (registerValue != null && registerValue.hasValue()) {
            return registerValue;
        }
        RegisterValue defaultRegisterValue = this.getRegisterValue(register, address, this.defaultRegisterValueMap);
        if (defaultRegisterValue != null) {
            return defaultRegisterValue.combineValues(registerValue);
        }
        return registerValue;
    }

    @Override
    public BigInteger getValue(Register register, Address address, boolean signed) {
        RegisterValue registerValue = this.getRegisterValue(register, address);
        if (registerValue != null) {
            return signed ? registerValue.getSignedValue() : registerValue.getUnsignedValue();
        }
        return null;
    }

    protected void deleteAddressRange(Address start, Address end, TaskMonitor monitor) {
        for (RegisterValueStore registerValueStore : this.registerValueMap.values()) {
            registerValueStore.clearValue(start, end, null);
        }
        this.invalidateReadCache();
    }

    private RegisterValue getRegisterValue(Register register, Address address, Map<Register, RegisterValueStore> map) {
        RegisterValueStore store;
        if (map == this.defaultRegisterValueMap && address.getAddressSpace().isOverlaySpace()) {
            address = ((OverlayAddressSpace)address.getAddressSpace()).translateAddress(address, true);
        }
        if ((store = map.get(register.getBaseRegister())) == null) {
            return null;
        }
        return store.getValue(register, address);
    }

    @Override
    public AddressRangeIterator getRegisterValueAddressRanges(Register register) {
        RegisterValueStore store = this.registerValueMap.get(register.getBaseRegister());
        if (store == null) {
            return new AddressSet().getAddressRanges();
        }
        return new RegisterAddressRangeIterator(register, store.getAddressRangeIterator(), this.registerValueMap);
    }

    @Override
    public AddressRange getRegisterValueRangeContaining(Register register, Address addr) {
        RegisterValueStore store = this.registerValueMap.get(register.getBaseRegister());
        if (store == null) {
            return new AddressRangeImpl(addr, addr);
        }
        return store.getValueRangeContaining(addr);
    }

    @Override
    public AddressRangeIterator getRegisterValueAddressRanges(Register register, Address start, Address end) {
        RegisterValueStore store = this.registerValueMap.get(register.getBaseRegister());
        if (store == null) {
            return new AddressSet().getAddressRanges();
        }
        return new RegisterAddressRangeIterator(register, store.getAddressRangeIterator(start, end), this.registerValueMap);
    }

    @Override
    public AddressRangeIterator getDefaultRegisterValueAddressRanges(Register register) {
        RegisterValueStore store = this.defaultRegisterValueMap.get(register.getBaseRegister());
        if (store == null) {
            return new AddressSet().getAddressRanges();
        }
        return new RegisterAddressRangeIterator(register, store.getAddressRangeIterator(), this.defaultRegisterValueMap);
    }

    @Override
    public AddressRangeIterator getDefaultRegisterValueAddressRanges(Register register, Address start, Address end) {
        RegisterValueStore store = this.defaultRegisterValueMap.get(register.getBaseRegister());
        if (store == null) {
            return new AddressSet().getAddressRanges();
        }
        return new RegisterAddressRangeIterator(register, store.getAddressRangeIterator(start, end), this.defaultRegisterValueMap);
    }

    @Override
    public Register[] getRegistersWithValues() {
        if (this.registersWithValues == null) {
            this.registersWithValues = new HashSet<Register>();
            for (Register register : this.language.getRegisters()) {
                RegisterValueStore store = this.registerValueMap.get(register.getBaseRegister());
                if (store != null && !store.isEmpty()) {
                    this.registersWithValues.add(register);
                    continue;
                }
                store = this.defaultRegisterValueMap.get(register.getBaseRegister());
                if (store == null || store.isEmpty()) continue;
                this.registersWithValues.add(register);
            }
        }
        Register[] regs = new Register[this.registersWithValues.size()];
        return this.registersWithValues.toArray(regs);
    }

    @Override
    public boolean hasValueOverRange(Register reg, BigInteger value, AddressSetView addrSet) {
        AddressRangeIterator it = addrSet.getAddressRanges();
        while (it.hasNext()) {
            AddressRange range = (AddressRange)it.next();
            if (this.hasValueOverRange(reg, value, range.getMinAddress(), range.getMaxAddress())) continue;
            return false;
        }
        return true;
    }

    private boolean hasValueOverRange(Register reg, BigInteger value, Address start, Address end) {
        AddressRange range;
        AddressRangeIterator it = this.getRegisterValueAddressRanges(reg, start, end);
        if (it.hasNext() && (range = (AddressRange)it.next()).getMinAddress().equals(start) && range.getMaxAddress().equals(end)) {
            BigInteger regValue = this.getValue(reg, start, true);
            return value.equals(regValue);
        }
        return false;
    }

    @Override
    public void remove(Address start, Address end, Register register) throws ContextChangeException {
        if (start.getAddressSpace() != end.getAddressSpace()) {
            throw new AssertException("start and end address must be in the same address space");
        }
        RegisterValueStore values = this.registerValueMap.get(register.getBaseRegister());
        if (values != null) {
            values.clearValue(start, end, register);
        }
        this.invalidateReadCache();
    }

    @Override
    public void setValue(Register register, Address start, Address end, BigInteger value) throws ContextChangeException {
        if (start.getAddressSpace() != end.getAddressSpace()) {
            throw new AssertException("start and end address must be in the same address space");
        }
        if (value == null) {
            this.remove(start, end, register);
            return;
        }
        this.setRegisterValue(start, end, new RegisterValue(register, value));
    }

    @Override
    public void setDefaultValue(RegisterValue registerValue, Address start, Address end) {
        if (start.getAddressSpace() != end.getAddressSpace()) {
            throw new AssertException("start and end address must be in the same address space");
        }
        Register baseRegister = registerValue.getRegister().getBaseRegister();
        RegisterValueStore store = this.defaultRegisterValueMap.get(baseRegister);
        if (store == null) {
            InMemoryRangeMapAdapter adapter = new InMemoryRangeMapAdapter();
            store = new RegisterValueStore(baseRegister, adapter, false);
            this.defaultRegisterValueMap.put(baseRegister, store);
        }
        store.setValue(start, end, registerValue);
        this.invalidateReadCache();
    }

    @Override
    public RegisterValue getDefaultValue(Register register, Address address) {
        AddressSpace space = address.getAddressSpace();
        if (space.isOverlaySpace()) {
            address = ((OverlayAddressSpace)space).translateAddress(address, true);
        } else if (space.getType() == 14) {
            return new RegisterValue(register);
        }
        return this.getRegisterValue(register, address, this.defaultRegisterValueMap);
    }

    @Override
    public RegisterValue getNonDefaultValue(Register register, Address address) {
        return this.getRegisterValue(register, address, this.registerValueMap);
    }

    protected abstract RangeMapAdapter createNewRangeMapAdapter(Register var1);

    protected void invalidateReadCache() {
        this.registersWithValues = null;
    }

    protected void invalidateWriteCache() {
        RegisterValueStore store = this.registerValueMap.get(this.baseContextRegister);
        if (store != null) {
            store.invalidateWriteCache();
        }
    }

    @Override
    public RegisterValue getDisassemblyContext(Address address) {
        RegisterValue defaultValue = this.getRegisterValue(this.baseContextRegister, address, this.defaultRegisterValueMap);
        RegisterValue currentValue = this.getRegisterValue(this.baseContextRegister, address, this.registerValueMap);
        defaultValue = defaultValue == null ? this.defaultDisassemblyContext : defaultValue.combineValues(this.defaultDisassemblyContext);
        return defaultValue.combineValues(currentValue);
    }

    class RegisterAddressRangeIterator
    implements AddressRangeIterator {
        private Register register;
        private AddressRangeIterator it;
        private AddressRange nextRange;
        private Map<Register, RegisterValueStore> map;

        RegisterAddressRangeIterator(Register register, AddressRangeIterator it, Map<Register, RegisterValueStore> map) {
            this.register = register;
            this.it = it;
            this.map = map;
            this.findNextRange();
        }

        private void findNextRange() {
            while (this.it.hasNext()) {
                this.nextRange = (AddressRange)this.it.next();
                RegisterValue bytes = AbstractStoredProgramContext.this.getRegisterValue(this.register, this.nextRange.getMinAddress(), this.map);
                if (bytes == null || !bytes.hasAnyValue()) continue;
                return;
            }
            this.nextRange = null;
        }

        @Override
        public Iterator<AddressRange> iterator() {
            return this;
        }

        @Override
        public void remove() {
            throw new UnsupportedOperationException();
        }

        @Override
        public boolean hasNext() {
            return this.nextRange != null;
        }

        @Override
        public AddressRange next() {
            AddressRange retRange = this.nextRange;
            this.findNextRange();
            return retRange;
        }
    }
}

