/*
 * Decompiled with CFR 0.152.
 */
package ghidra.program.database.module;

import db.DBRecord;
import db.Field;
import ghidra.program.database.DBObjectCache;
import ghidra.program.database.DatabaseObject;
import ghidra.program.database.module.FragmentDB;
import ghidra.program.database.module.FragmentDBAdapter;
import ghidra.program.database.module.ModuleDBAdapter;
import ghidra.program.database.module.ModuleManager;
import ghidra.program.database.module.ParentChildDBAdapter;
import ghidra.program.model.address.Address;
import ghidra.program.model.address.AddressSet;
import ghidra.program.model.address.AddressSetView;
import ghidra.program.model.listing.CircularDependencyException;
import ghidra.program.model.listing.CodeUnit;
import ghidra.program.model.listing.DuplicateGroupException;
import ghidra.program.model.listing.Group;
import ghidra.program.model.listing.ProgramFragment;
import ghidra.program.model.listing.ProgramModule;
import ghidra.util.Lock;
import ghidra.util.exception.DuplicateNameException;
import ghidra.util.exception.NotEmptyException;
import ghidra.util.exception.NotFoundException;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Comparator;
import java.util.List;

class ModuleDB
extends DatabaseObject
implements ProgramModule {
    private DBRecord record;
    private ModuleManager moduleMgr;
    private ModuleDBAdapter moduleAdapter;
    private FragmentDBAdapter fragmentAdapter;
    private ParentChildDBAdapter parentChildAdapter;
    private int childCount;
    private Lock lock;

    ModuleDB(ModuleManager moduleMgr, DBObjectCache<ModuleDB> cache, DBRecord record) throws IOException {
        super(cache, record.getKey());
        this.moduleMgr = moduleMgr;
        this.record = record;
        this.childCount = record.getIntValue(2);
        this.moduleAdapter = moduleMgr.getModuleAdapter();
        this.fragmentAdapter = moduleMgr.getFragmentAdapter();
        this.parentChildAdapter = moduleMgr.getParentChildAdapter();
        this.lock = moduleMgr.getLock();
    }

    @Override
    protected boolean refresh() {
        try {
            DBRecord rec = this.moduleAdapter.getModuleRecord(this.key);
            if (rec != null) {
                this.record = rec;
                this.childCount = rec.getIntValue(2);
                return true;
            }
        }
        catch (IOException e) {
            this.moduleMgr.dbError(e);
        }
        return false;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void add(ProgramFragment fragment) throws DuplicateGroupException {
        this.lock.acquire();
        try {
            this.checkDeleted();
            FragmentDB frag = (FragmentDB)fragment;
            long fragID = frag.getKey();
            DBRecord parentChildRecord = this.parentChildAdapter.getParentChildRecord(this.key, -fragID);
            if (parentChildRecord != null) {
                throw new DuplicateGroupException(frag.getName() + " already exists a child of " + this.getName());
            }
            DBRecord pcRec = this.parentChildAdapter.addParentChildRecord(this.key, -fragID);
            this.updateChildCount(1);
            this.updateOrderField(pcRec, this.childCount - 1);
            this.moduleMgr.fragmentAdded(this.key, frag);
        }
        catch (IOException e) {
            this.moduleMgr.dbError(e);
        }
        finally {
            this.lock.release();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void add(ProgramModule module) throws CircularDependencyException, DuplicateGroupException {
        this.lock.acquire();
        try {
            this.checkDeleted();
            ModuleDB moduleDB = (ModuleDB)module;
            long moduleID = moduleDB.getKey();
            DBRecord parentChildRecord = this.parentChildAdapter.getParentChildRecord(this.key, moduleID);
            if (parentChildRecord != null) {
                throw new DuplicateGroupException(module.getName() + " already exists a child of " + this.getName());
            }
            if (this.moduleMgr.isDescendant(this.key, moduleID)) {
                throw new CircularDependencyException(this.getName() + " is already a descendant of " + module.getName());
            }
            DBRecord pcRec = this.parentChildAdapter.addParentChildRecord(this.key, moduleID);
            this.updateChildCount(1);
            this.updateOrderField(pcRec, this.childCount - 1);
            this.moduleMgr.moduleAdded(this.key, module);
        }
        catch (IOException e) {
            this.moduleMgr.dbError(e);
        }
        finally {
            this.lock.release();
        }
    }

    @Override
    public boolean contains(ProgramFragment fragment) {
        if (!(fragment instanceof FragmentDB)) {
            return false;
        }
        FragmentDB frag = (FragmentDB)fragment;
        if (this.moduleMgr != frag.getModuleManager()) {
            return false;
        }
        return this.contains(-frag.getKey());
    }

    @Override
    public boolean contains(ProgramModule module) {
        if (!(module instanceof ModuleDB)) {
            return false;
        }
        ModuleDB moduleDB = (ModuleDB)module;
        if (this.moduleMgr != moduleDB.moduleMgr) {
            return false;
        }
        return this.contains(moduleDB.getKey());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public ProgramFragment createFragment(String fragmentName) throws DuplicateNameException {
        this.lock.acquire();
        try {
            this.checkDeleted();
            if (this.moduleAdapter.getModuleRecord(fragmentName) != null || this.fragmentAdapter.getFragmentRecord(fragmentName) != null) {
                throw new DuplicateNameException(fragmentName + " already exists");
            }
            DBRecord fragmentRecord = this.fragmentAdapter.createFragmentRecord(this.key, fragmentName);
            DBRecord pcRec = this.parentChildAdapter.addParentChildRecord(this.key, -fragmentRecord.getKey());
            this.updateChildCount(1);
            this.updateOrderField(pcRec, this.childCount - 1);
            FragmentDB frag = this.moduleMgr.getFragmentDB(fragmentRecord);
            this.moduleMgr.fragmentAdded(this.key, frag);
            FragmentDB fragmentDB = frag;
            return fragmentDB;
        }
        catch (IOException e) {
            this.moduleMgr.dbError(e);
        }
        finally {
            this.lock.release();
        }
        return null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public ProgramModule createModule(String moduleName) throws DuplicateNameException {
        this.lock.acquire();
        try {
            this.checkDeleted();
            if (this.moduleAdapter.getModuleRecord(moduleName) != null || this.fragmentAdapter.getFragmentRecord(moduleName) != null) {
                throw new DuplicateNameException(moduleName + " already exists");
            }
            DBRecord moduleRecord = this.moduleAdapter.createModuleRecord(this.key, moduleName);
            DBRecord pcRec = this.parentChildAdapter.addParentChildRecord(this.key, moduleRecord.getKey());
            ModuleDB moduleDB = this.moduleMgr.getModuleDB(moduleRecord);
            this.updateChildCount(1);
            this.updateOrderField(pcRec, this.childCount - 1);
            this.moduleMgr.moduleAdded(this.key, moduleDB);
            ModuleDB moduleDB2 = moduleDB;
            return moduleDB2;
        }
        catch (IOException e) {
            this.moduleMgr.dbError(e);
        }
        finally {
            this.lock.release();
        }
        return null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public Group[] getChildren() {
        this.lock.acquire();
        try {
            this.checkIsValid();
            List<DBRecord> list = this.getParentChildRecords();
            Group[] kids = new Group[list.size()];
            if (kids.length != this.childCount) {
                throw new IOException("Inconsistent module child count (" + kids.length + " vs. " + this.childCount + "): " + this.getName());
            }
            for (int i = 0; i < list.size(); ++i) {
                DBRecord rec = list.get(i);
                long childID = rec.getLongValue(1);
                kids[i] = childID < 0L ? this.moduleMgr.getFragmentDB(-childID) : this.moduleMgr.getModuleDB(childID);
            }
            Group[] groupArray = kids;
            return groupArray;
        }
        catch (IOException e) {
            this.moduleMgr.dbError(e);
        }
        finally {
            this.lock.release();
        }
        return new Group[0];
    }

    @Override
    public String getComment() {
        this.lock.acquire();
        try {
            this.checkIsValid();
            String string = this.record.getString(1);
            return string;
        }
        finally {
            this.lock.release();
        }
    }

    @Override
    public Address getFirstAddress() {
        this.lock.acquire();
        try {
            this.checkIsValid();
            Address address = this.findFirstAddress(this);
            return address;
        }
        catch (IOException e) {
            this.moduleMgr.dbError(e);
        }
        finally {
            this.lock.release();
        }
        return null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public int getIndex(String name) {
        this.lock.acquire();
        try {
            this.checkIsValid();
            DBRecord fragmentRecord = this.fragmentAdapter.getFragmentRecord(name);
            DBRecord pcRec = null;
            if (fragmentRecord != null) {
                pcRec = this.parentChildAdapter.getParentChildRecord(this.key, -fragmentRecord.getKey());
            } else {
                DBRecord moduleRecord = this.moduleAdapter.getModuleRecord(name);
                if (moduleRecord != null) {
                    pcRec = this.parentChildAdapter.getParentChildRecord(this.key, moduleRecord.getKey());
                }
            }
            if (pcRec != null) {
                int n = pcRec.getIntValue(2);
                return n;
            }
        }
        catch (IOException e) {
            this.moduleMgr.dbError(e);
        }
        finally {
            this.lock.release();
        }
        return -1;
    }

    @Override
    public Address getLastAddress() {
        this.lock.acquire();
        try {
            this.checkIsValid();
            Address address = this.findLastAddress(this);
            return address;
        }
        catch (IOException e) {
            this.moduleMgr.dbError(e);
        }
        finally {
            this.lock.release();
        }
        return null;
    }

    @Override
    public Address getMaxAddress() {
        this.lock.acquire();
        try {
            this.checkIsValid();
            Address address = this.findMaxAddress(this, null);
            return address;
        }
        catch (IOException e) {
            this.moduleMgr.dbError(e);
        }
        finally {
            this.lock.release();
        }
        return null;
    }

    @Override
    public Address getMinAddress() {
        this.lock.acquire();
        try {
            this.checkIsValid();
            Address address = this.findMinAddress(this, null);
            return address;
        }
        catch (IOException e) {
            this.moduleMgr.dbError(e);
        }
        finally {
            this.lock.release();
        }
        return null;
    }

    @Override
    public AddressSetView getAddressSet() {
        AddressSet set = new AddressSet();
        Group[] children = this.getChildren();
        for (int i = 0; i < children.length; ++i) {
            if (children[i] instanceof ProgramFragment) {
                set.add((ProgramFragment)children[i]);
                continue;
            }
            ProgramModule m = (ProgramModule)children[i];
            set.add(m.getAddressSet());
        }
        return set;
    }

    @Override
    public int getNumChildren() {
        this.lock.acquire();
        try {
            this.checkIsValid();
            int n = this.childCount;
            return n;
        }
        finally {
            this.lock.release();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public boolean isDescendant(ProgramFragment fragment) {
        if (!(fragment instanceof FragmentDB)) {
            return false;
        }
        this.lock.acquire();
        try {
            this.checkIsValid();
            FragmentDB frag = (FragmentDB)fragment;
            boolean bl = this.moduleMgr.isDescendant(-frag.getKey(), this.key);
            return bl;
        }
        catch (IOException e) {
            this.moduleMgr.dbError(e);
        }
        finally {
            this.lock.release();
        }
        return false;
    }

    @Override
    public boolean isDescendant(ProgramModule module) {
        if (!(module instanceof ModuleDB)) {
            return false;
        }
        ModuleDB moduleDB = (ModuleDB)module;
        try {
            return this.moduleMgr.isDescendant(moduleDB.key, this.key);
        }
        catch (IOException e) {
            this.moduleMgr.dbError(e);
            return false;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void moveChild(String name, int index) throws NotFoundException {
        this.lock.acquire();
        try {
            this.checkDeleted();
            int currentIndex = 0;
            boolean foundName = false;
            DatabaseObject group = null;
            List<DBRecord> list = this.getParentChildRecords();
            for (int i = 0; i < list.size(); ++i) {
                DBRecord rec = list.get(i);
                long childID = rec.getLongValue(1);
                String childName = null;
                DBRecord childRec = null;
                if (childID < 0L) {
                    childRec = this.fragmentAdapter.getFragmentRecord(-childID);
                    childName = childRec.getString(0);
                } else {
                    childRec = this.moduleAdapter.getModuleRecord(childID);
                    childName = childRec.getString(0);
                }
                if (!childName.equals(name)) continue;
                foundName = true;
                currentIndex = i;
                group = childID < 0L ? this.moduleMgr.getFragmentDB(childRec) : this.moduleMgr.getModuleDB(childRec);
            }
            if (!foundName) {
                throw new NotFoundException(name + " is not a child of " + this.getName());
            }
            DBRecord pcRec = list.remove(currentIndex);
            list.add(index, pcRec);
            this.updateChildOrder(list);
            this.moduleMgr.childReordered(this, (Group)((Object)group));
        }
        catch (IOException e) {
            this.moduleMgr.dbError(e);
        }
        finally {
            this.lock.release();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public boolean removeChild(String name) throws NotEmptyException {
        this.lock.acquire();
        try {
            this.checkDeleted();
            DBRecord rec = this.fragmentAdapter.getFragmentRecord(name);
            boolean deleteChild = false;
            if (rec != null) {
                long childID = rec.getKey();
                DBRecord pcRec = this.parentChildAdapter.getParentChildRecord(this.key, -childID);
                if (pcRec == null) {
                    boolean bl = this.removeModuleRecord(name);
                    return bl;
                }
                Field[] keys = this.parentChildAdapter.getParentChildKeys(-childID, 1);
                if (keys.length == 1) {
                    FragmentDB frag = this.moduleMgr.getFragmentDB(childID);
                    if (!frag.isEmpty()) {
                        throw new NotEmptyException(frag.getName() + " is not empty");
                    }
                    deleteChild = true;
                }
                boolean bl = this.removeChild(childID, pcRec, true, deleteChild);
                return bl;
            }
            boolean bl = this.removeModuleRecord(name);
            return bl;
        }
        catch (IOException e) {
            this.moduleMgr.dbError(e);
        }
        finally {
            this.lock.release();
        }
        return false;
    }

    private boolean removeModuleRecord(String name) throws IOException, NotEmptyException {
        DBRecord rec = this.moduleAdapter.getModuleRecord(name);
        if (rec == null) {
            return false;
        }
        boolean deleteChild = false;
        long childID = rec.getKey();
        DBRecord pcRec = this.parentChildAdapter.getParentChildRecord(this.key, childID);
        if (pcRec == null) {
            return false;
        }
        Field[] keys = this.parentChildAdapter.getParentChildKeys(childID, 1);
        if (keys.length == 1) {
            ModuleDB module = this.moduleMgr.getModuleDB(childID);
            if (module.getNumChildren() > 0) {
                throw new NotEmptyException(this.getName() + " is not empty");
            }
            deleteChild = true;
        }
        return this.removeChild(childID, pcRec, false, deleteChild);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void reparent(String name, ProgramModule oldParent) throws NotFoundException {
        Group group = null;
        ProgramFragment f = null;
        this.lock.acquire();
        try {
            long childID;
            this.checkDeleted();
            ProgramModule m = this.moduleMgr.getModule(name);
            if (m == null) {
                f = this.moduleMgr.getFragment(name);
                if (f == null) {
                    throw new NotFoundException(name + " was not found as child of " + this.getName());
                }
                childID = -((FragmentDB)f).getKey();
                group = f;
            } else {
                childID = ((ModuleDB)m).key;
                group = m;
            }
            ModuleDB oldModuleDB = (ModuleDB)oldParent;
            DBRecord oldPcRec = this.parentChildAdapter.getParentChildRecord(oldModuleDB.key, childID);
            this.parentChildAdapter.removeParentChildRecord(oldPcRec.getKey());
            oldModuleDB.updateChildCount(-1);
            DBRecord newPcRec = this.parentChildAdapter.addParentChildRecord(this.key, childID);
            this.updateChildCount(1);
            this.updateOrderField(newPcRec, this.childCount - 1);
            oldModuleDB.resetChildOrder();
            this.moduleMgr.childReparented(group, oldParent.getName(), this.getName());
        }
        catch (IOException e) {
            this.moduleMgr.dbError(e);
        }
        finally {
            this.lock.release();
        }
    }

    @Override
    public boolean contains(CodeUnit codeUnit) {
        FragmentDB frag = this.moduleMgr.getFragment(codeUnit);
        if (frag != null) {
            return this.contains(frag);
        }
        return false;
    }

    @Override
    public String getName() {
        this.lock.acquire();
        try {
            this.checkIsValid();
            String string = this.record.getString(0);
            return string;
        }
        finally {
            this.lock.release();
        }
    }

    @Override
    public int getNumParents() {
        this.lock.acquire();
        try {
            this.checkIsValid();
            Field[] keys = this.parentChildAdapter.getParentChildKeys(this.key, 1);
            int n = keys.length;
            return n;
        }
        catch (IOException e) {
            this.moduleMgr.dbError(e);
        }
        finally {
            this.lock.release();
        }
        return 0;
    }

    @Override
    public String[] getParentNames() {
        return this.moduleMgr.getParentNames(this.key);
    }

    @Override
    public ProgramModule[] getParents() {
        return this.moduleMgr.getParents(this.key);
    }

    @Override
    public String getTreeName() {
        return this.moduleMgr.getTreeName();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void setComment(String comment) {
        this.lock.acquire();
        try {
            this.checkDeleted();
            String oldComments = this.record.getString(1);
            if (oldComments == null || !oldComments.equals(comment)) {
                this.record.setString(1, comment);
                try {
                    this.moduleAdapter.updateModuleRecord(this.record);
                    this.moduleMgr.commentsChanged(oldComments, this);
                }
                catch (IOException e) {
                    this.moduleMgr.dbError(e);
                }
            }
        }
        finally {
            this.lock.release();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void setName(String name) throws DuplicateNameException {
        this.lock.acquire();
        try {
            this.checkDeleted();
            if (this.key == ModuleManager.ROOT_MODULE_ID) {
                this.moduleMgr.getProgram().setName(name);
                return;
            }
            DBRecord r = this.moduleAdapter.getModuleRecord(name);
            if (r != null) {
                if (this.key != r.getKey()) {
                    throw new DuplicateNameException(name + " already exists");
                }
                return;
            }
            if (this.fragmentAdapter.getFragmentRecord(name) != null) {
                throw new DuplicateNameException(name + " already exists");
            }
            String oldName = this.record.getString(0);
            this.record.setString(0, name);
            this.moduleAdapter.updateModuleRecord(this.record);
            this.moduleMgr.nameChanged(oldName, this);
        }
        catch (IOException e) {
            this.moduleMgr.dbError(e);
        }
        finally {
            this.lock.release();
        }
    }

    DBRecord getRecord() {
        return this.record;
    }

    private boolean contains(long childID) {
        try {
            DBRecord rec = this.parentChildAdapter.getParentChildRecord(this.key, childID);
            return rec != null;
        }
        catch (IOException e) {
            this.moduleMgr.dbError(e);
            return false;
        }
    }

    private boolean removeChild(long childID, DBRecord pcRec, boolean isFragment, boolean deleteChild) throws IOException {
        this.parentChildAdapter.removeParentChildRecord(pcRec.getKey());
        this.updateChildCount(-1);
        String name = null;
        boolean success = true;
        if (isFragment) {
            DBRecord fragRec = this.fragmentAdapter.getFragmentRecord(childID);
            name = fragRec.getString(0);
            if (deleteChild) {
                success = this.fragmentAdapter.removeFragmentRecord(childID);
            }
        } else {
            DBRecord mrec = this.moduleAdapter.getModuleRecord(childID);
            name = mrec.getString(0);
            if (deleteChild) {
                success = this.moduleAdapter.removeModuleRecord(childID);
            }
        }
        if (success) {
            this.resetChildOrder();
            this.moduleMgr.groupRemoved(this, childID, name, isFragment, deleteChild);
        }
        return success;
    }

    private List<DBRecord> getParentChildRecords() throws IOException {
        Field[] keys = this.parentChildAdapter.getParentChildKeys(this.key, 0);
        ArrayList<DBRecord> list = new ArrayList<DBRecord>();
        ParentChildRecordComparator c = new ParentChildRecordComparator();
        for (int i = 0; i < keys.length; ++i) {
            DBRecord rec = this.parentChildAdapter.getParentChildRecord(keys[i].getLongValue());
            int index = Collections.binarySearch(list, rec, c);
            if (index < 0) {
                index = -index - 1;
            }
            list.add(index, rec);
        }
        return list;
    }

    private void updateChildOrder(List<DBRecord> list) throws IOException {
        for (int i = 0; i < list.size(); ++i) {
            DBRecord pcRec = list.get(i);
            if (i == pcRec.getIntValue(2)) continue;
            pcRec.setIntValue(2, i);
            this.parentChildAdapter.updateParentChildRecord(pcRec);
        }
    }

    private void resetChildOrder() throws IOException {
        List<DBRecord> list = this.getParentChildRecords();
        this.updateChildOrder(list);
    }

    private void updateOrderField(DBRecord pcRec, int orderValue) throws IOException {
        pcRec.setIntValue(2, orderValue);
        this.parentChildAdapter.updateParentChildRecord(pcRec);
    }

    private Address findFirstAddress(ModuleDB module) throws IOException {
        List<DBRecord> list = module.getParentChildRecords();
        for (int i = 0; i < list.size(); ++i) {
            DBRecord rec = list.get(i);
            long childID = rec.getLongValue(1);
            if (childID < 0L) {
                FragmentDB frag = this.moduleMgr.getFragmentDB(-childID);
                if (frag.isEmpty()) continue;
                return frag.getMinAddress();
            }
            ModuleDB m = this.moduleMgr.getModuleDB(childID);
            Address addr = this.findFirstAddress(m);
            if (addr == null) continue;
            return addr;
        }
        return null;
    }

    private Address findLastAddress(ModuleDB module) throws IOException {
        List<DBRecord> list = module.getParentChildRecords();
        for (int i = list.size() - 1; i >= 0; --i) {
            DBRecord rec = list.get(i);
            long childID = rec.getLongValue(1);
            if (childID < 0L) {
                FragmentDB frag = this.moduleMgr.getFragmentDB(-childID);
                if (frag.isEmpty()) continue;
                return frag.getMaxAddress();
            }
            ModuleDB m = this.moduleMgr.getModuleDB(childID);
            Address addr = this.findLastAddress(m);
            if (addr == null) continue;
            return addr;
        }
        return null;
    }

    private Address findMinAddress(ModuleDB module, Address addr) throws IOException {
        Address minAddr = addr;
        List<DBRecord> list = module.getParentChildRecords();
        for (int i = 0; i < list.size(); ++i) {
            DBRecord rec = list.get(i);
            long childID = rec.getLongValue(1);
            Address childMinAddr = null;
            if (childID < 0L) {
                FragmentDB frag = this.moduleMgr.getFragmentDB(-childID);
                if (!frag.isEmpty()) {
                    childMinAddr = frag.getMinAddress();
                }
            } else {
                ModuleDB m = this.moduleMgr.getModuleDB(childID);
                childMinAddr = this.findMinAddress(m, addr);
            }
            if (childMinAddr != null && minAddr == null) {
                minAddr = childMinAddr;
                continue;
            }
            if (childMinAddr == null || childMinAddr.compareTo(minAddr) >= 0) continue;
            minAddr = childMinAddr;
        }
        return minAddr;
    }

    private Address findMaxAddress(ModuleDB module, Address addr) throws IOException {
        Address maxAddr = addr;
        List<DBRecord> list = module.getParentChildRecords();
        for (int i = 0; i < list.size(); ++i) {
            DBRecord rec = list.get(i);
            long childID = rec.getLongValue(1);
            Address childMaxAddr = null;
            if (childID < 0L) {
                FragmentDB frag = this.moduleMgr.getFragmentDB(-childID);
                if (!frag.isEmpty()) {
                    childMaxAddr = frag.getMaxAddress();
                }
            } else {
                ModuleDB m = this.moduleMgr.getModuleDB(childID);
                childMaxAddr = this.findMaxAddress(m, addr);
            }
            if (childMaxAddr != null && maxAddr == null) {
                maxAddr = childMaxAddr;
                continue;
            }
            if (childMaxAddr == null || childMaxAddr.compareTo(maxAddr) <= 0) continue;
            maxAddr = childMaxAddr;
        }
        return maxAddr;
    }

    private void updateChildCount(int change) throws IOException {
        this.childCount += change;
        this.record.setIntValue(2, this.childCount);
        this.moduleAdapter.updateModuleRecord(this.record);
    }

    @Override
    public Object getVersionTag() {
        return this.moduleMgr.getVersionTag();
    }

    @Override
    public long getModificationNumber() {
        return this.moduleMgr.getModificationNumber();
    }

    @Override
    public long getTreeID() {
        return this.moduleMgr.getTreeID();
    }

    public String toString() {
        return this.record.getString(0);
    }

    private class ParentChildRecordComparator
    implements Comparator<DBRecord> {
        private ParentChildRecordComparator() {
        }

        @Override
        public int compare(DBRecord r1, DBRecord r2) {
            int index2;
            int index1 = r1.getIntValue(2);
            if (index1 < (index2 = r2.getIntValue(2))) {
                return -1;
            }
            if (index1 > index2) {
                return 1;
            }
            return 0;
        }
    }
}

