/*
 * Decompiled with CFR 0.152.
 */
package ghidra.program.database.mem;

import ghidra.program.model.address.Address;
import ghidra.program.model.address.AddressRange;
import ghidra.program.model.address.AddressRangeImpl;
import ghidra.program.model.address.AddressRangeIterator;
import ghidra.program.model.address.AddressSetView;
import java.util.ConcurrentModificationException;
import java.util.Iterator;
import java.util.NoSuchElementException;

class RecoverableAddressRangeIterator
implements AddressRangeIterator {
    private AddressSetView set;
    private boolean forward;
    private AddressRangeIterator iterator;
    private AddressRange next;

    RecoverableAddressRangeIterator(AddressSetView set, Address start, boolean forward) {
        this.set = set;
        this.forward = forward;
        this.initIterator(start);
        try {
            this.next = (AddressRange)this.iterator.next();
        }
        catch (NoSuchElementException e) {
            this.next = null;
        }
    }

    private void initIterator(Address start) {
        this.iterator = start == null ? this.set.getAddressRanges(this.forward) : this.set.getAddressRanges(start, this.forward);
    }

    @Override
    public Iterator<AddressRange> iterator() {
        return this;
    }

    @Override
    public AddressRange next() throws NoSuchElementException {
        AddressRange range = this.next;
        if (range == null) {
            throw new NoSuchElementException();
        }
        try {
            this.next = (AddressRange)this.iterator.next();
        }
        catch (ConcurrentModificationException e) {
            this.next = this.recoverNext(range);
        }
        catch (NoSuchElementException e) {
            this.next = null;
        }
        return range;
    }

    /*
     * Loose catch block
     */
    private AddressRange recoverNext(AddressRange lastRange) {
        while (true) {
            try {
                Address lastAddr = this.forward ? lastRange.getMaxAddress() : lastRange.getMinAddress();
                this.initIterator(lastAddr);
                AddressRange r = (AddressRange)this.iterator.next();
                if (!r.intersects(lastRange)) {
                    return r;
                }
                if (this.forward) {
                    if (r.getMaxAddress().compareTo(lastAddr) > 0) {
                        return new AddressRangeImpl(lastAddr.next(), r.getMaxAddress());
                    }
                } else if (r.getMinAddress().compareTo(lastAddr) < 0) {
                    return new AddressRangeImpl(r.getMinAddress(), lastAddr.previous());
                }
                return (AddressRange)this.iterator.next();
            }
            catch (ConcurrentModificationException lastAddr) {
                continue;
            }
            break;
        }
        catch (NoSuchElementException e) {
            return null;
        }
    }

    @Override
    public boolean hasNext() {
        return this.next != null;
    }
}

