/*
 * Decompiled with CFR 0.152.
 */
package ghidra.program.database.data;

import db.DBHandle;
import db.Transaction;
import db.util.ErrorHandler;
import ghidra.framework.model.DomainFile;
import ghidra.framework.options.Options;
import ghidra.program.database.ManagerDB;
import ghidra.program.database.ProgramDB;
import ghidra.program.database.data.ProgramBasedDataTypeManagerDB;
import ghidra.program.database.map.AddressMap;
import ghidra.program.model.address.Address;
import ghidra.program.model.data.ArchiveType;
import ghidra.program.model.data.Category;
import ghidra.program.model.data.CategoryPath;
import ghidra.program.model.data.DataType;
import ghidra.program.model.data.DataTypePath;
import ghidra.program.model.listing.Program;
import ghidra.util.InvalidNameException;
import ghidra.util.Lock;
import ghidra.util.UniversalID;
import ghidra.util.exception.AssertException;
import ghidra.util.exception.CancelledException;
import ghidra.util.exception.VersionException;
import ghidra.util.task.TaskMonitor;
import java.io.IOException;
import java.util.Iterator;
import java.util.LinkedList;

public class ProgramDataTypeManager
extends ProgramBasedDataTypeManagerDB
implements ManagerDB {
    private static final String OLD_DT_ARCHIVE_FILENAMES = "DataTypeArchiveFilenames";
    private ProgramDB program;
    private boolean upgrade;

    public ProgramDataTypeManager(DBHandle handle, AddressMap addrMap, int openMode, ErrorHandler errHandler, Lock lock, TaskMonitor monitor) throws CancelledException, VersionException, IOException {
        super(handle, addrMap, openMode, null, errHandler, lock, monitor);
        this.upgrade = openMode == 3;
    }

    @Override
    public void saveDataOrganization() throws IOException {
        super.saveDataOrganization();
    }

    @Override
    protected void dataSettingChanged(Address dataAddr) {
        this.program.setChanged(109, dataAddr, dataAddr, null, null);
    }

    @Override
    public boolean allowsDefaultBuiltInSettings() {
        return true;
    }

    @Override
    public void setProgram(ProgramDB p) {
        this.program = p;
        try {
            this.setProgramArchitecture(p, p.getSymbolTable().getVariableStorageManager(), false, TaskMonitor.DUMMY);
        }
        catch (CancelledException e) {
            throw new AssertException((Throwable)e);
        }
        catch (IOException e) {
            this.errHandler.dbError(e);
        }
        if (this.upgrade) {
            this.removeOldFileNameList();
        }
    }

    private void removeOldFileNameList() {
        Options options = this.program.getOptions("Program Information");
        if (options.contains(OLD_DT_ARCHIVE_FILENAMES)) {
            options.removeOption(OLD_DT_ARCHIVE_FILENAMES);
        }
    }

    @Override
    public void invalidateCache(boolean all) throws IOException {
        super.invalidateCache();
    }

    @Override
    public void programReady(int openMode, int currentRevision, TaskMonitor monitor) throws IOException, CancelledException {
        if (openMode == 3) {
            this.doSourceArchiveUpdates(monitor);
            this.migrateOldFlexArrayComponentsIfRequired(monitor);
        }
    }

    public void languageChanged(TaskMonitor monitor) throws IOException, CancelledException {
        this.setProgramArchitecture(this.program, this.program.getSymbolTable().getVariableStorageManager(), true, monitor);
    }

    @Override
    public String getName() {
        return this.program.getName();
    }

    @Override
    public void setName(String name) throws InvalidNameException {
        if (name == null || name.length() == 0) {
            throw new InvalidNameException("Name is invalid: " + name);
        }
        this.program.setName(name);
        Category root = this.getRootCategory();
        this.categoryRenamed(CategoryPath.ROOT, root);
    }

    @Override
    public void sourceArchiveChanged(UniversalID sourceArchiveID) {
        super.sourceArchiveChanged(sourceArchiveID);
        this.program.sourceArchiveChanged(sourceArchiveID, 112);
    }

    @Override
    protected void sourceArchiveAdded(UniversalID sourceArchiveID) {
        super.sourceArchiveAdded(sourceArchiveID);
        this.program.sourceArchiveAdded(sourceArchiveID, 111);
    }

    @Override
    public void dataTypeChanged(DataType dt, boolean isAutoChange) {
        super.dataTypeChanged(dt, isAutoChange);
        if (!this.isCreatingDataType()) {
            this.program.dataTypeChanged(this.getID(dt), 108, isAutoChange, null, dt);
        }
    }

    @Override
    protected void dataTypeAdded(DataType newDt, DataType originalDataType) {
        super.dataTypeAdded(newDt, originalDataType);
        this.program.dataTypeAdded(this.getID(newDt), 104, null, newDt);
    }

    @Override
    protected void dataTypeReplaced(long existingDtID, DataTypePath existingPath, DataType replacementDt) {
        super.dataTypeReplaced(existingDtID, existingPath, replacementDt);
        this.program.dataTypeChanged(existingDtID, 110, true, existingPath, replacementDt);
    }

    @Override
    protected void dataTypeDeleted(long deletedID, DataTypePath deletedDataTypePath) {
        super.dataTypeDeleted(deletedID, deletedDataTypePath);
        this.program.dataTypeChanged(deletedID, 105, false, deletedDataTypePath, null);
    }

    @Override
    protected void dataTypeMoved(DataType dt, DataTypePath oldPath, DataTypePath newPath) {
        super.dataTypeMoved(dt, oldPath, newPath);
        Category category = this.getCategory(oldPath.getCategoryPath());
        this.program.dataTypeChanged(this.getID(dt), 107, false, category, dt);
    }

    @Override
    protected void dataTypeNameChanged(DataType dt, String oldName) {
        super.dataTypeNameChanged(dt, oldName);
        this.program.dataTypeChanged(this.getID(dt), 106, false, oldName, dt);
    }

    @Override
    protected void categoryCreated(Category newCategory) {
        super.categoryCreated(newCategory);
        this.program.categoryAdded(newCategory.getID(), 100, newCategory.getParent(), newCategory);
    }

    @Override
    protected void categoryRenamed(CategoryPath oldPath, Category category) {
        super.categoryRenamed(oldPath, category);
        this.program.categoryChanged(category.getID(), 102, oldPath.getName(), category);
    }

    @Override
    protected void categoryRemoved(Category parent, String name, long categoryID) {
        super.categoryRemoved(parent, name, categoryID);
        this.program.categoryChanged(categoryID, 101, parent, name);
    }

    @Override
    protected void categoryMoved(CategoryPath oldPath, Category category) {
        super.categoryMoved(oldPath, category);
        this.program.categoryChanged(category.getID(), 103, oldPath.getParent(), category);
    }

    @Override
    protected void favoritesChanged(DataType dataType, boolean isFavorite) {
        super.favoritesChanged(dataType, isFavorite);
    }

    @Override
    protected void replaceDataTypeIDs(long oldDataTypeID, long newDataTypeID) {
        if (oldDataTypeID == newDataTypeID) {
            return;
        }
        this.program.getCodeManager().replaceDataTypes(oldDataTypeID, newDataTypeID);
        this.program.getSymbolTable().replaceDataTypes(oldDataTypeID, newDataTypeID);
        this.program.getFunctionManager().replaceDataTypes(oldDataTypeID, newDataTypeID);
    }

    @Override
    protected void deleteDataTypeIDs(LinkedList<Long> deletedIds, TaskMonitor monitor) throws CancelledException {
        long[] ids = new long[deletedIds.size()];
        Iterator it = deletedIds.iterator();
        int i = 0;
        while (it.hasNext()) {
            ids[i++] = (Long)it.next();
        }
        this.program.getCodeManager().clearData(ids, monitor);
        this.program.getFunctionManager().invalidateCache(false);
    }

    @Override
    public boolean isUpdatable() {
        return this.program.isChangeable();
    }

    @Override
    public Transaction openTransaction(String description) throws IllegalStateException {
        return this.program.openTransaction(description);
    }

    @Override
    public int startTransaction(String description) {
        return this.program.startTransaction(description);
    }

    @Override
    public void flushEvents() {
        this.program.flushEvents();
    }

    @Override
    public void endTransaction(int transactionID, boolean commit) {
        this.program.endTransaction(transactionID, commit);
    }

    @Override
    public void close() {
    }

    @Override
    public Program getProgram() {
        return this.program;
    }

    @Override
    public DomainFile getDomainFile() {
        return this.program.getDomainFile();
    }

    @Override
    public String getDomainFileID() {
        DomainFile domainFile = this.program.getDomainFile();
        return domainFile != null ? domainFile.getFileID() : null;
    }

    @Override
    public String getPath() {
        DomainFile domainFile = this.program.getDomainFile();
        return domainFile != null ? domainFile.getPathname() : null;
    }

    @Override
    public ArchiveType getType() {
        return ArchiveType.PROGRAM;
    }
}

